<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Can</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            font-weight: 300;
        }
        .sidebar {
            background: #0a0a0a;
            border-right: 1px solid #1a1a1a;
            height: 100vh;
            overflow-y: auto;
            position: fixed;
            top: 0;
            left: 0;
            width: 280px;
            z-index: 40;
            transition: transform 0.3s ease;
        }
        .sidebar.hidden {
            transform: translateX(-100%);
        }
        .main-content {
            margin-left: 280px;
            transition: margin-left 0.3s ease;
        }
        .main-content.full-width {
            margin-left: 0;
        }
        .toc-item {
            transition: all 0.2s ease;
        }
        .toc-item:hover {
            background: #1a1a1a;
        }
        .toc-item.active {
            background: #2a2a2a;
            border-left: 3px solid #666666;
        }
        .code-block {
            background: #111111;
            border: 1px solid #333333;
            border-radius: 8px;
        }
        .section {
            scroll-margin-top: 80px;
        }
        .mobile-menu {
            display: none;
        }
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }
            .main-content {
                margin-left: 0;
            }
            .mobile-menu {
                display: block;
            }
            .desktop-menu {
                display: none;
            }
        }
        .hamburger {
            cursor: pointer;
            display: flex;
            flex-direction: column;
            justify-content: space-around;
            width: 24px;
            height: 24px;
        }
        .hamburger span {
            background: white;
            height: 2px;
            width: 100%;
            transition: 0.3s;
        }
        .hamburger.active span:nth-child(1) {
            transform: rotate(45deg) translate(5px, 5px);
        }
        .hamburger.active span:nth-child(2) {
            opacity: 0;
        }
        .hamburger.active span:nth-child(3) {
            transform: rotate(-45deg) translate(7px, -6px);
        }
    </style>
</head>
<body class="bg-black text-white">
    
    <div class="mobile-menu fixed top-0 left-0 right-0 bg-black border-b border-gray-800 p-4 z-50">
        <div class="flex items-center justify-between">
            <h1 class="text-xl font-medium">Can</h1>
            <div class="hamburger" id="hamburger">
                <span></span>
                <span></span>
                <span></span>
            </div>
        </div>
    </div>

    <div class="sidebar" id="sidebar">
        <div class="p-6 border-b border-gray-800">
            <h1 class="text-xl font-medium mb-2">Can</h1>
            <p class="text-sm text-gray-400">Complete Documentation</p>
        </div>
        
        <nav class="p-4">
            <ul class="space-y-1">
                <li><a href="#overview" class="toc-item block px-3 py-2 rounded text-sm">Overview</a></li>
                <li><a href="#installation" class="toc-item block px-3 py-2 rounded text-sm">Installation</a></li>
                <li><a href="#getting-started" class="toc-item block px-3 py-2 rounded text-sm">Getting Started</a></li>
                <li><a href="#configuration" class="toc-item block px-3 py-2 rounded text-sm">Configuration</a></li>
                <li>
                    <div class="px-3 py-2 text-xs text-gray-500 uppercase font-medium">Commands</div>
                    <ul class="ml-4 space-y-1">
                        <li><a href="#scan-command" class="toc-item block px-3 py-2 rounded text-sm">can scan</a></li>
                        <li><a href="#ask-command" class="toc-item block px-3 py-2 rounded text-sm">can ask</a></li>
                        <li><a href="#proj-command" class="toc-item block px-3 py-2 rounded text-sm">can proj</a></li>
                        <li><a href="#crypt-command" class="toc-item block px-3 py-2 rounded text-sm">can crypt</a></li>
                        <li><a href="#custom-command" class="toc-item block px-3 py-2 rounded text-sm">can custom</a></li>
                        <li><a href="#status-command" class="toc-item block px-3 py-2 rounded text-sm">can status</a></li>
                    </ul>
                </li>
                <li>
                    <div class="px-3 py-2 text-xs text-gray-500 uppercase font-medium">Intelligence</div>
                    <ul class="ml-4 space-y-1">
                        <li><a href="#living-system" class="toc-item block px-3 py-2 rounded text-sm">Living System</a></li>
                        <li><a href="#multilingual" class="toc-item block px-3 py-2 rounded text-sm">Multilingual Support</a></li>
                        <li><a href="#auto-tools" class="toc-item block px-3 py-2 rounded text-sm">Automatic Tool Installation</a></li>
                        <li><a href="#creative-ai" class="toc-item block px-3 py-2 rounded text-sm">Creative AI Capabilities</a></li>
                    </ul>
                </li>
                <li>
                    <div class="px-3 py-2 text-xs text-gray-500 uppercase font-medium">Security & Protection</div>
                    <ul class="ml-4 space-y-1">
                        <li><a href="#core-protection" class="toc-item block px-3 py-2 rounded text-sm">Core Protection</a></li>
                        <li><a href="#password-system" class="toc-item block px-3 py-2 rounded text-sm">Password System</a></li>
                        <li><a href="#self-recovery" class="toc-item block px-3 py-2 rounded text-sm">Self-Recovery</a></li>
                    </ul>
                </li>
                <li>
                    <div class="px-3 py-2 text-xs text-gray-500 uppercase font-medium">Plugin Development</div>
                    <ul class="ml-4 space-y-1">
                        <li><a href="#plugin-architecture" class="toc-item block px-3 py-2 rounded text-sm">Plugin Architecture</a></li>
                        <li><a href="#creating-plugins" class="toc-item block px-3 py-2 rounded text-sm">Creating Plugins</a></li>
                        <li><a href="#plugin-examples" class="toc-item block px-3 py-2 rounded text-sm">Plugin Examples</a></li>
                    </ul>
                </li>
                <li>
                    <div class="px-3 py-2 text-xs text-gray-500 uppercase font-medium">Use Cases</div>
                    <ul class="ml-4 space-y-1">
                        <li><a href="#web-development" class="toc-item block px-3 py-2 rounded text-sm">Web Development</a></li>
                        <li><a href="#game-development" class="toc-item block px-3 py-2 rounded text-sm">Game Development</a></li>
                        <li><a href="#enterprise-solutions" class="toc-item block px-3 py-2 rounded text-sm">Enterprise Solutions</a></li>
                    </ul>
                </li>
                <li><a href="#faq" class="toc-item block px-3 py-2 rounded text-sm">FAQ</a></li>
                <li><a href="#support" class="toc-item block px-3 py-2 rounded text-sm">Support</a></li>
            </ul>
        </nav>
    </div>

    <div class="main-content" id="mainContent">
        <div class="max-w-4xl mx-auto px-8 py-16 mt-16 md:mt-0">
            
            <section id="overview" class="section mb-16">
                <h1 class="text-4xl font-medium mb-6">Can Algorithm Documentation</h1>
                <p class="text-lg text-gray-300 mb-6">
                    Can Algorithm is an intelligent, living CLI tool that exists as a persistent guardian in your development environment. 
                    It's not just another automation tool - it's a self-protecting, adaptive AI that can understand natural language in multiple languages, 
                    install necessary tools autonomously, and create complex solutions from simple requests.
                </p>
                
                <div class="bg-gray-900 rounded-lg p-6 mb-6">
                    <h3 class="text-lg font-medium mb-3">Revolutionary Features</h3>
                    <ul class="space-y-2 text-gray-300">
                        <li>🧠 <strong>Living AI System</strong> - Persistent daemon that learns and adapts to your environment</li>
                        <li>🌍 <strong>Multilingual Intelligence</strong> - Understands English, French, German, Russian, and Turkish</li>
                        <li>🛠️ <strong>Autonomous Tool Management</strong> - Installs dependencies via NPM, Composer, APT, and more</li>
                        <li>🔒 <strong>Self-Protection System</strong> - Cannot be deleted by scripts, auto-recovers from damage</li>
                        <li>🎨 <strong>Unlimited Creativity</strong> - Builds complete applications, games, enterprise solutions</li>
                        <li>⚡ <strong>Asynchronous Processing</strong> - Handles long tasks in background with progress notifications</li>
                        <li>🔐 <strong>Password Protection</strong> - Secure commands with 12-character password requirements</li>
                        <li>🔌 <strong>Plugin Architecture</strong> - Community-extensible with FiveM, WordPress, React plugins</li>
                    </ul>
                </div>

                <div class="bg-gradient-to-r from-gray-900 to-gray-800 rounded-lg p-6 mb-6">
                    <h3 class="text-lg font-medium mb-3">What Makes Can Different</h3>
                    <p class="text-gray-300 mb-4">
                        Can Algorithm is not just a code generator - it's a persistent AI entity that becomes part of your development environment. 
                        It monitors your project 24/7, learns from your patterns, and can execute complex multi-hour projects while you focus on other tasks.
                    </p>
                    <p class="text-gray-300">
                        Think of it as having a senior developer on your team who never sleeps, speaks multiple languages, 
                        and can build anything from a simple website to a complete cyberpunk FiveM server with neural implant systems.
                    </p>
                </div>
            </section>

            <section id="installation" class="section mb-16">
                <h2 class="text-3xl font-medium mb-6">Installation</h2>
                
                <h3 class="text-xl mb-4">NPM Installation (Recommended)</h3>
                <div class="code-block p-4 mb-6">
                    <code class="text-white">npm install -g can-algorithm</code>
                </div>
                
                <div class="bg-yellow-900/30 border border-yellow-600 rounded-lg p-4 mb-6">
                    <h4 class="font-medium mb-2 text-yellow-400">⚠️ Important Security Notice</h4>
                    <p class="text-gray-300 text-sm">
                        During installation, Can Algorithm will establish its protection systems. This includes creating hidden files, 
                        setting up system monitoring, and configuring auto-recovery mechanisms. These are essential for Can's self-protection capabilities.
                    </p>
                </div>
                
                <h3 class="text-xl mb-4">Post-Installation Security Setup</h3>
                <p class="text-gray-300 mb-4">
                    After installation, Can automatically configures its protection systems:
                </p>
                <ul class="text-gray-300 space-y-2 mb-6">
                    <li>• Creates system monitoring scripts (cron/systemd)</li>
                    <li>• Establishes hidden configuration files with encryption</li>
                    <li>• Sets up process watchdogs and auto-restart mechanisms</li>
                    <li>• Configures backup systems in distributed locations</li>
                    <li>• Implements anti-tampering and integrity verification</li>
                </ul>
                
                <h3 class="text-xl mb-4">System Requirements</h3>
                <ul class="text-gray-300 space-y-1">
                    <li>• Node.js 16.0+ (automatically updated if needed)</li>
                    <li>• 500MB free disk space (for models and cache)</li>
                    <li>• Admin/root privileges (for system-level protection)</li>
                    <li>• Windows 10+, macOS 10.15+, or Linux (Ubuntu 18.04+)</li>
                </ul>
            </section>

            <section id="getting-started" class="section mb-16">
                <h2 class="text-3xl font-medium mb-6">Getting Started</h2>
                
                <h3 class="text-xl mb-4">1. License Key Format</h3>
                <p class="text-gray-300 mb-4">
                    Can Algorithm requires a license key that starts with "CAN" followed by 4 characters:
                </p>
                <div class="code-block p-4 mb-4">
                    <code class="text-white">Format: CAN-XXXX (e.g., CAN-6DECA0)</code>
                </div>
                <p class="text-gray-300 mb-6">
                    Visit <a href="https://imators.systems/can/key" class="text-blue-400 hover:text-blue-300">imators.systems/can/key</a> 
                    to generate your license key.
                </p>
                
                <h3 class="text-xl mb-4">2. Initial Configuration</h3>
                <div class="code-block p-4 mb-4">
                    <code class="text-white">can genconfig</code>
                </div>
                <p class="text-gray-300 mb-6">
                    This will configure Can Algorithm and establish its protection systems. You'll be prompted to:
                </p>
                <ul class="text-gray-300 space-y-1 mb-6">
                    <li>• Enter your license key</li>
                    <li>• Set a 12-character master password (recommended)</li>
                    <li>• Configure security preferences</li>
                    <li>• Set up monitoring and protection levels</li>
                </ul>
                
                <h3 class="text-xl mb-4">3. Start Can's Living System</h3>
                <div class="code-block p-4 mb-4">
                    <code class="text-white">can start</code>
                </div>
                <p class="text-gray-300 mb-6">
                    This activates Can as a persistent daemon in your environment. Can will now monitor your project directory 
                    and be ready to execute complex tasks in the background.
                </p>
                
                <h3 class="text-xl mb-4">4. Test with a Simple Project</h3>
                <div class="code-block p-4 mb-4">
                    <div class="text-gray-400 mb-2"># Navigate to your project directory</div>
                    <code class="text-white block">cd /path/to/your/project</code>
                    <code class="text-white block">can scan</code>
                </div>
            </section>

            <section id="living-system" class="section mb-16">
                <h2 class="text-3xl font-medium mb-6">Living System Architecture</h2>
                
                <p class="text-gray-300 mb-6">
                    Can Algorithm operates as a living entity within your development environment. Unlike traditional CLI tools, 
                    Can exists as a persistent daemon that monitors, learns, and adapts to your project needs continuously.
                </p>
                
                <h3 class="text-xl mb-4">Persistent Monitoring</h3>
                <div class="bg-gray-900 rounded-lg p-6 mb-6">
                    <ul class="text-gray-300 space-y-2">
                        <li>• <strong>File System Watching:</strong> Detects changes in real-time and can suggest improvements</li>
                        <li>• <strong>Project Health Monitoring:</strong> Continuously analyses code quality and performance</li>
                        <li>• <strong>Dependency Tracking:</strong> Monitors for outdated packages and security vulnerabilities</li>
                        <li>• <strong>Error Detection:</strong> Automatically identifies syntax errors and potential bugs</li>
                        <li>• <strong>Performance Analysis:</strong> Tracks build times, bundle sizes, and optimization opportunities</li>
                    </ul>
                </div>
                
                <h3 class="text-xl mb-4">Asynchronous Task Processing</h3>
                <p class="text-gray-300 mb-4">
                    Can can handle complex, time-consuming tasks in the background while you continue working:
                </p>
                <div class="code-block p-4 mb-6">
                    <pre class="text-white text-sm"><code>> can proj "create complete e-commerce platform with stripe integration"
[CAN] Analysing requirements for e-commerce platform...
[CAN] This is a complex task. Estimated time: 2-3 hours
[CAN] I'll work on this in the background. Continue with your other tasks.
[CAN] Type 'can status' to check progress anytime.

[2 hours later - automatic notification]
[CAN] E-commerce platform completed! 
[CAN] Created: 156 files, 47 components, complete payment system
[CAN] Ready for testing at: http://localhost:3000</code></pre>
                </div>
                
                <h3 class="text-xl mb-4">Learning and Adaptation</h3>
                <ul class="text-gray-300 space-y-2">
                    <li>• <strong>Code Style Learning:</strong> Adapts to your indentation, naming conventions, and patterns</li>
                    <li>• <strong>Framework Preferences:</strong> Remembers your preferred libraries and tools</li>
                    <li>• <strong>Project Templates:</strong> Builds custom templates based on your recurring patterns</li>
                    <li>• <strong>Error Pattern Recognition:</strong> Learns from your common mistakes and prevents them</li>
                </ul>
            </section>

            <section id="multilingual" class="section mb-16">
                <h2 class="text-3xl font-medium mb-6">Multilingual Intelligence</h2>
                
                <p class="text-gray-300 mb-6">
                    Can Algorithm understands and responds to commands in English, French, German, Russian, and Turkish. 
                    It comprehends technical terminology and context-specific language in each supported language.
                </p>
                
                <h3 class="text-xl mb-4">Supported Languages</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                    <div class="code-block p-4">
                        <h4 class="font-medium mb-2 text-blue-400">English</h4>
                        <code class="text-white text-sm">can proj "create REST API with authentication"</code>
                    </div>
                    <div class="code-block p-4">
                        <h4 class="font-medium mb-2 text-blue-400">Français</h4>
                        <code class="text-white text-sm">can proj "crée un serveur de base esx fivem"</code>
                    </div>
                    <div class="code-block p-4">
                        <h4 class="font-medium mb-2 text-blue-400">Deutsch</h4>
                        <code class="text-white text-sm">can proj "erstelle eine e-commerce webseite"</code>
                    </div>
                    <div class="code-block p-4">
                        <h4 class="font-medium mb-2 text-blue-400">Русский</h4>
                        <code class="text-white text-sm">can proj "создай систему управления базой данных"</code>
                    </div>
                    <div class="code-block p-4">
                        <h4 class="font-medium mb-2 text-blue-400">Türkçe</h4>
                        <code class="text-white text-sm">can proj "react ile sosyal medya uygulaması yap"</code>
                    </div>
                </div>
                
                <h3 class="text-xl mb-4">Context-Aware Translation</h3>
                <p class="text-gray-300 mb-4">
                    Can understands technical terms and domain-specific language across all supported languages:
                </p>
                <ul class="text-gray-300 space-y-2 mb-6">
                    <li>• <strong>Gaming:</strong> ESX, vRP, FiveM, QBCore, resources, scripts</li>
                    <li>• <strong>Web Development:</strong> Components, hooks, middleware, API, database</li>
                    <li>• <strong>Framework Terms:</strong> Laravel, React, Vue, Angular, Express</li>
                    <li>• <strong>DevOps:</strong> Docker, CI/CD, deployment, staging, production</li>
                </ul>
            </section>

            <section id="auto-tools" class="section mb-16">
                <h2 class="text-3xl font-medium mb-6">Automatic Tool Installation</h2>
                
                <p class="text-gray-300 mb-6">
                    Can Algorithm can automatically install and configure tools needed for your projects. 
                    It requests permission before installing anything and provides detailed progress updates.
                </p>
                
                <h3 class="text-xl mb-4">Supported Package Managers</h3>
                <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-6">
                    <div class="bg-gray-900 rounded p-4 text-center">
                        <div class="font-medium mb-2">NPM/Yarn</div>
                        <div class="text-sm text-gray-400">JavaScript packages</div>
                    </div>
                    <div class="bg-gray-900 rounded p-4 text-center">
                        <div class="font-medium mb-2">Composer</div>
                        <div class="text-sm text-gray-400">PHP dependencies</div>
                    </div>
                    <div class="bg-gray-900 rounded p-4 text-center">
                        <div class="font-medium mb-2">APT/YUM</div>
                        <div class="text-sm text-gray-400">System packages</div>
                    </div>
                    <div class="bg-gray-900 rounded p-4 text-center">
                        <div class="font-medium mb-2">Git Clone</div>
                        <div class="text-sm text-gray-400">Repositories</div>
                    </div>
                </div>
                
                <h3 class="text-xl mb-4">Intelligent Installation Workflow</h3>
                <div class="code-block p-4 mb-6">
                    <pre class="text-white text-sm"><code>> can proj "create laravel app with authentication and payments"

[CAN] Analysing project requirements...
[CAN] Tools needed:
- Composer (PHP dependency manager)
- Laravel Framework
- Laravel Breeze (authentication)
- Stripe PHP SDK
- Node.js 18+ (current version 14 detected)

[CAN] Permission to install tools? (Y/N): Y
[CAN] Updating Node.js to version 18...
[CAN] Installing Laravel via Composer...
[CAN] Setting up authentication system...
[CAN] Configuring Stripe integration...
[CAN] This will take 8-12 minutes. Type 'can status' for updates</code></pre>
                </div>
                
                <h3 class="text-xl mb-4">Version Management</h3>
                <ul class="text-gray-300 space-y-2">
                    <li>• <strong>Automatic Updates:</strong> Suggests and installs tool updates when needed</li>
                    <li>• <strong>Compatibility Checking:</strong> Ensures all tools work together</li>
                    <li>• <strong>Rollback Support:</strong> Can revert tool installations if issues occur</li>
                    <li>• <strong>Environment Detection:</strong> Adapts installation commands based on OS</li>
                </ul>
            </section>

            <section id="status-command" class="section mb-16">
                <h2 class="text-3xl font-medium mb-6">can status</h2>
                
                <p class="text-gray-300 mb-6">
                    Monitor Can's background tasks, system health, and get detailed progress reports on ongoing projects.
                </p>
                
                <h3 class="text-xl mb-4">Real-Time Task Monitoring</h3>
                <div class="code-block p-4 mb-6">
                    <pre class="text-white text-sm"><code>> can status

[CAN] System Status: ✅ HEALTHY
[CAN] Active Tasks: 2

📋 Current Task: "FiveM ESX Server Setup"
   Progress: ████████████░░░░ 75%
   Phase: Installing esx_ambulancejob resources
   ETA: 8 minutes remaining
   
📋 Background Task: "Code Quality Analysis"  
   Progress: ██████████████░░ 85%
   Analysed: 234/276 files
   Found: 12 optimization opportunities
   
🔧 System Health:
   Memory Usage: 145MB / 512MB allocated
   Disk Space: 2.3GB free
   Protection Status: ✅ ACTIVE
   Last Backup: 23 minutes ago</code></pre>
                </div>
                
                <h3 class="text-xl mb-4">Detailed Progress Reports</h3>
                <div class="code-block p-4 mb-6">
                    <code class="text-white">can status --detailed</code>
                </div>
                <p class="text-gray-300 mb-4">Provides comprehensive information including:</p>
                <ul class="text-gray-300 space-y-1 mb-6">
                    <li>• Step-by-step task breakdown</li>
                    <li>• Resource usage statistics</li>
                    <li>• Error logs and warnings</li>
                    <li>• Performance metrics</li>
                    <li>• Next scheduled actions</li>
                </ul>
                
                <h3 class="text-xl mb-4">Task Management</h3>
                <div class="space-y-4">
                    <div class="code-block p-4">
                        <code class="text-white block">can status --pause</code>
                        <div class="text-gray-400 text-sm mt-2">Pause current background tasks</div>
                    </div>
                    <div class="code-block p-4">
                        <code class="text-white block">can status --resume</code>
                        <div class="text-gray-400 text-sm mt-2">Resume paused tasks</div>
                    </div>
                    <div class="code-block p-4">
                        <code class="text-white block">can status --cancel [task-id]</code>
                        <div class="text-gray-400 text-sm mt-2">Cancel a specific task</div>
                    </div>
                </div>
            </section>

            <section id="core-protection" class="section mb-16">
                <h2 class="text-3xl font-medium mb-6">Core Protection System</h2>
                
                <p class="text-gray-300 mb-6">
                    Can Algorithm implements military-grade protection mechanisms to ensure it cannot be disabled or deleted by malicious scripts, 
                    while remaining removable by legitimate user action.
                </p>
                
                <h3 class="text-xl mb-4">Multi-Layer Protection</h3>
                <div class="bg-gray-900 rounded-lg p-6 mb-6">
                    <ul class="text-gray-300 space-y-3">
                        <li>• <strong>Process Monitoring:</strong> Watchdog processes that restart Can if terminated</li>
                        <li>• <strong>File Protection:</strong> Core files set to read-only with system-level permissions</li>
                        <li>• <strong>Hidden Backups:</strong> Distributed backups in multiple hidden locations</li>
                        <li>• <strong>Integrity Verification:</strong> Continuous checksums and hash verification</li>
                        <li>• <strong>Anti-Script Protection:</strong> Blocks dangerous commands like rm -rf, del *.*, kill</li>
                        <li>• <strong>System Integration:</strong> Cron jobs and systemd services for auto-recovery</li>
                    </ul>
                </div>
                
                <h3 class="text-xl mb-4">Threat Detection</h3>
                <p class="text-gray-300 mb-4">Can monitors for various threats and responds automatically:</p>
                <ul class="text-gray-300 space-y-2 mb-6">
                    <li>• <strong>Script-based deletion attempts:</strong> Blocked and logged</li>
                    <li>• <strong>File corruption:</strong> Automatic restoration from backups</li>
                    <li>• <strong>Process termination:</strong> Immediate restart with investigation</li>
                    <li>• <strong>Configuration tampering:</strong> Reverted with security alerts</li>
                    <li>• <strong>Unauthorized access attempts:</strong> Password challenges and lockouts</li>
                </ul>
                
                <h3 class="text-xl mb-4">Legitimate Removal Process</h3>
                <p class="text-gray-300 mb-4">Users can remove Can Algorithm through official channels:</p>
                <div class="code-block p-4 mb-6">
                    <pre class="text-white text-sm"><code>> can uninstall
[CAN] This will completely remove Can Algorithm from your system.
[CAN] Enter your master password: ************
[CAN] Are you absolutely sure? (type 'CONFIRM REMOVAL'): CONFIRM REMOVAL
[CAN] Disabling protection systems...
[CAN] Removing system integrations...
[CAN] Cleaning up files and configurations...
[CAN] Can Algorithm has been successfully removed.</code></pre>
                </div>
            </section>

            <section id="password-system" class="section mb-16">
                <h2 class="text-3xl font-medium mb-6">Password Protection System</h2>
                
                <p class="text-gray-300 mb-6">
                    Can Algorithm implements a robust password system with 12-character minimum requirements to protect 
                    sensitive operations and prevent unauthorized access to powerful commands.
                </p>
                
                <h3 class="text-xl mb-4">Password Requirements</h3>
                <div class="bg-gray-900 rounded-lg p-6 mb-6">
                    <ul class="text-gray-300 space-y-2">
                        <li>• <strong>Minimum Length:</strong> 12 characters (recommended for security)</li>
                        <li>• <strong>Complexity:</strong> Mix of uppercase, lowercase, numbers, and symbols</li>
                        <li>• <strong>Encryption:</strong> Stored using SHA-256 with salt</li>
                        <li>• <strong>Session Timeout:</strong> Re-authentication required after inactivity</li>
                    </ul>
                </div>
                
                <h3 class="text-xl mb-4">Protected Commands</h3>
                <p class="text-gray-300 mb-4">The following commands require password authentication:</p>
                <div class="space-y-4 mb-6">
                    <div class="code-block p-4">
                        <code class="text-white block">can proj [complex-request]</code>
                        <div class="text-gray-400 text-sm mt-2">Large-scale project modifications</div>
                    </div>
                    <div class="code-block p-4">
                        <code class="text-white block">can crypt [file]</code>
                        <div class="text-gray-400 text-sm mt-2">Encryption and obfuscation operations</div>
                    </div>
                    <div class="code-block p-4">
                        <code class="text-white block">can custom [dangerous-operations]</code>
                        <div class="text-gray-400 text-sm mt-2">System-level custom commands</div>
                    </div>
                    <div class="code-block p-4">
                        <code class="text-white block">can uninstall</code>
                        <div class="text-gray-400 text-sm mt-2">Complete system removal</div>
                    </div>
                </div>
                
                <h3 class="text-xl mb-4">Security Features</h3>
                <ul class="text-gray-300 space-y-2">
                    <li>• <strong>Brute Force Protection:</strong> Account lockout after failed attempts</li>
                    <li>• <strong>Session Management:</strong> Automatic logout after inactivity</li>
                    <li>• <strong>Password Recovery:</strong> Secure recovery process via license key</li>
                    <li>• <strong>Audit Logging:</strong> All authentication attempts logged securely</li>
                </ul>
            </section>

            <section id="self-recovery" class="section mb-16">
                <h2 class="text-3xl font-medium mb-6">Self-Recovery System</h2>
                
                <p class="text-gray-300 mb-6">
                    Can Algorithm can automatically detect damage, corruption, or partial deletion and restore itself 
                    to full functionality without user intervention.
                </p>
                
                <h3 class="text-xl mb-4">Recovery Mechanisms</h3>
                <div class="bg-gray-900 rounded-lg p-6 mb-6">
                    <ul class="text-gray-300 space-y-3">
                        <li>• <strong>Integrity Scanning:</strong> Continuous verification of core files</li>
                        <li>• <strong>Automatic Backup Restoration:</strong> Restores from hidden backup locations</li>
                        <li>• <strong>Dependency Reconstruction:</strong> Rebuilds missing system integrations</li>
                        <li>• <strong>Configuration Recovery:</strong> Restores encrypted configuration files</li>
                        <li>• <strong>Process Resurrection:</strong> Restarts terminated daemon processes</li>
                    </ul>
                </div>
                
                <h3 class="text-xl mb-4">Recovery Process Example</h3>
                <div class="code-block p-4 mb-6">
                    <pre class="text-white text-sm"><code>[CAN] ⚠️  INTEGRITY VIOLATION DETECTED
[CAN] Missing files: can-core.js, protection-system.js
[CAN] Corruption detected in: configuration files
[CAN] Initiating emergency recovery protocol...

[CAN] 🔄 RECOVERY IN PROGRESS
[CAN] Restoring core files from backup location 1...
[CAN] Rebuilding encrypted configurations...
[CAN] Re-establishing system monitoring...
[CAN] Verifying process integrity...

[CAN] ✅ RECOVERY COMPLETE
[CAN] All systems restored and operational
[CAN] Security enhanced to prevent future tampering
[CAN] Incident logged for analysis</code></pre>
                </div>
                
                <h3 class="text-xl mb-4">Prevention Measures</h3>
                <ul class="text-gray-300 space-y-2">
                    <li>• <strong>Distributed Backups:</strong> Multiple hidden backup locations</li>
                    <li>• <strong>Real-time Monitoring:</strong> Immediate detection of changes</li>
                    <li>• <strong>Blockchain Verification:</strong> Immutable integrity records</li>
                    <li>• <strong>Cloud Synchronization:</strong> Optional secure cloud backups</li>
                </ul>
            </section>

            <section id="plugin-architecture" class="section mb-16">
                <h2 class="text-3xl font-medium mb-6">Plugin Architecture</h2>
                
                <p class="text-gray-300 mb-6">
                    Can Algorithm features a powerful, extensible plugin system that allows developers to create 
                    specialized extensions for specific domains like FiveM, WordPress, React, and more.
                </p>
                
                <h3 class="text-xl mb-4">Plugin System Structure</h3>
                <div class="code-block p-4 mb-6">
                    <pre class="text-white text-sm"><code>can-algorithm/
├── plugins/
│   ├── core-plugins/          # Official plugins
│   │   ├── fivem-integration/
│   │   ├── wordpress-tools/
│   │   ├── react-helper/
│   │   └── laravel-assistant/
│   ├── community/             # Community plugins
│   │   ├── vue-components/
│   │   ├── docker-manager/
│   │   └── blockchain-tools/
│   └── user/                  # User-specific plugins
│       ├── my-custom-plugin/
│       └── company-tools/</code></pre>
                </div>
                
                <h3 class="text-xl mb-4">Plugin Capabilities</h3>
                <div class="bg-gray-900 rounded-lg p-6 mb-6">
                    <ul class="text-gray-300 space-y-2">
                        <li>• <strong>Custom Commands:</strong> Add new can commands with domain-specific logic</li>
                        <li>• <strong>File Watchers:</strong> Monitor specific file types and react to changes</li>
                        <li>• <strong>Code Generators:</strong> Create templates and boilerplates for frameworks</li>
                        <li>• <strong>Integration Hooks:</strong> Connect with external APIs and services</li>
                        <li>• <strong>UI Extensions:</strong> Add custom interfaces and dashboards</li>
                    </ul>
                </div>
                
                <h3 class="text-xl mb-4">Official Plugin Examples</h3>
                <div class="space-y-4">
                    <div class="bg-gray-900 rounded-lg p-4">
                        <h4 class="font-medium mb-2 text-blue-400">FiveM Integration Plugin</h4>
                        <p class="text-gray-300 text-sm mb-2">Specialized tools for FiveM server development</p>
                        <div class="code-block p-3">
                            <code class="text-white text-sm">can fivem generate resource "banking-system"</code>
                        </div>
                    </div>
                    
                    <div class="bg-gray-900 rounded-lg p-4">
                        <h4 class="font-medium mb-2 text-green-400">WordPress Tools Plugin</h4>
                        <p class="text-gray-300 text-sm mb-2">Complete WordPress development automation</p>
                        <div class="code-block p-3">
                            <code class="text-white text-sm">can wp theme "create e-commerce theme"</code>
                        </div>
                    </div>
                    
                    <div class="bg-gray-900 rounded-lg p-4">
                        <h4 class="font-medium mb-2 text-purple-400">React Helper Plugin</h4>
                        <p class="text-gray-300 text-sm mb-2">Advanced React component generation and optimization</p>
                        <div class="code-block p-3">
                            <code class="text-white text-sm">can react component "DataTable" --typescript --hooks</code>
                        </div>
                    </div>
                </div>
            </section>

            <section id="creating-plugins" class="section mb-16">
                <h2 class="text-3xl font-medium mb-6">Creating Plugins</h2>
                
                <p class="text-gray-300 mb-6">
                    Developers can create custom plugins to extend Can Algorithm's capabilities for specific frameworks, 
                    tools, or business requirements.
                </p>
                
                <h3 class="text-xl mb-4">Plugin Development Template</h3>
                <div class="code-block p-4 mb-6">
                    <pre class="text-white text-sm"><code>const CanPlugin = require('can-core/plugin');

class MyCustomPlugin extends CanPlugin {
    constructor() {
        super();
        this.name = 'my-custom-plugin';
        this.version = '1.0.0';
        this.description = 'Custom plugin for specific needs';
    }
    
    register() {
        // Register custom commands
        this.addCommand('mycmd', this.handleMyCommand.bind(this));
        
        // Register file watchers
        this.addWatcher('*.mycustom', this.handleFileChange.bind(this));
        
        // Register hooks
        this.addHook('before-scan', this.preprocessScan.bind(this));
    }
    
    async handleMyCommand(request, options) {
        // Your custom command logic
        const result = await this.processRequest(request);
        return this.formatResponse(result);
    }
    
    handleFileChange(filePath, changeType) {
        // React to file changes
        this.logger.info(`File changed: ${filePath}`);
    }
    
    preprocessScan(scanData) {
        // Modify scan behavior
        return this.enhanceScanData(scanData);
    }
}

module.exports = MyCustomPlugin;</code></pre>
                </div>
                
                <h3 class="text-xl mb-4">Plugin Lifecycle Hooks</h3>
                <div class="bg-gray-900 rounded-lg p-6 mb-6">
                    <ul class="text-gray-300 space-y-2">
                        <li>• <strong>before-scan:</strong> Modify scan parameters</li>
                        <li>• <strong>after-scan:</strong> Process scan results</li>
                        <li>• <strong>before-generation:</strong> Customize code generation</li>
                        <li>• <strong>after-generation:</strong> Post-process generated code</li>
                        <li>• <strong>command-execution:</strong> Intercept command processing</li>
                        <li>• <strong>file-change:</strong> React to file system events</li>
                    </ul>
                </div>
                
                <h3 class="text-xl mb-4">Plugin API Methods</h3>
                <div class="space-y-4">
                    <div class="code-block p-4">
                        <code class="text-white block">this.can.fileSystem</code>
                        <div class="text-gray-400 text-sm mt-2">Access to file system operations</div>
                    </div>
                    <div class="code-block p-4">
                        <code class="text-white block">this.can.codeGenerator</code>
                        <div class="text-gray-400 text-sm mt-2">Code generation and templating engine</div>
                    </div>
                    <div class="code-block p-4">
                        <code class="text-white block">this.can.projectAnalyzer</code>
                        <div class="text-gray-400 text-sm mt-2">Project structure and framework detection</div>
                    </div>
                    <div class="code-block p-4">
                        <code class="text-white block">this.can.packageManager</code>
                        <div class="text-gray-400 text-sm mt-2">NPM, Composer, and other package managers</div>
                    </div>
                </div>
            </section>

            <section id="creative-ai" class="section mb-16">
                <h2 class="text-3xl font-medium mb-6">Creative AI Capabilities</h2>
                
                <p class="text-gray-300 mb-6">
                    Can Algorithm's AI has no creative limitations. It can conceptualize, architect, and build 
                    complete applications from simple natural language descriptions, handling everything from 
                    simple websites to complex enterprise systems.
                </p>
                
                <h3 class="text-xl mb-4">Unlimited Project Scope</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                    <div class="bg-gradient-to-br from-blue-900 to-blue-800 rounded-lg p-4">
                        <h4 class="font-medium mb-2">🌐 Web Applications</h4>
                        <ul class="text-sm text-gray-300 space-y-1">
                            <li>• E-commerce platforms</li>
                            <li>• Social media networks</li>
                            <li>• Content management systems</li>
                            <li>• Real-time collaboration tools</li>
                        </ul>
                    </div>
                    <div class="bg-gradient-to-br from-green-900 to-green-800 rounded-lg p-4">
                        <h4 class="font-medium mb-2">🎮 Gaming Systems</h4>
                        <ul class="text-sm text-gray-300 space-y-1">
                            <li>• FiveM roleplay servers</li>
                            <li>• Multiplayer game engines</li>
                            <li>• Virtual reality experiences</li>
                            <li>• Blockchain gaming platforms</li>
                        </ul>
                    </div>
                    <div class="bg-gradient-to-br from-purple-900 to-purple-800 rounded-lg p-4">
                        <h4 class="font-medium mb-2">🏢 Enterprise Solutions</h4>
                        <ul class="text-sm text-gray-300 space-y-1">
                            <li>• ERP systems</li>
                            <li>• CRM platforms</li>
                            <li>• Data analytics dashboards</li>
                            <li>• AI/ML integration systems</li>
                        </ul>
                    </div>
                    <div class="bg-gradient-to-br from-red-900 to-red-800 rounded-lg p-4">
                        <h4 class="font-medium mb-2">🚀 Innovative Projects</h4>
                        <ul class="text-sm text-gray-300 space-y-1">
                            <li>• IoT management platforms</li>
                            <li>• Cryptocurrency exchanges</li>
                            <li>• AR/VR applications</li>
                            <li>• Machine learning systems</li>
                        </ul>
                    </div>
                </div>
                
                <h3 class="text-xl mb-4">Creative Examples</h3>
                <div class="space-y-4 mb-6">
                    <div class="code-block p-4">
                        <code class="text-white block">can proj "create a Netflix clone for education with VR classrooms"</code>
                        <div class="text-gray-400 text-sm mt-2">Builds streaming platform with WebXR integration, AI recommendations, and virtual learning environments</div>
                    </div>
                    
                    <div class="code-block p-4">
                        <code class="text-white block">can proj "cyberpunk fivem server with neural implant system"</code>
                        <div class="text-gray-400 text-sm mt-2">Creates futuristic roleplay server with brain-computer interfaces, memory modification, and cybernetic enhancement trees</div>
                    </div>
                    
                    <div class="code-block p-4">
                        <code class="text-white block">can proj "AI-powered trading bot with risk management"</code>
                        <div class="text-gray-400 text-sm mt-2">Develops algorithmic trading system with machine learning, portfolio optimization, and automated risk controls</div>
                    </div>
                </div>
                
                <h3 class="text-xl mb-4">Architectural Intelligence</h3>
                <ul class="text-gray-300 space-y-2">
                    <li>• <strong>Microservices Design:</strong> Automatically architects scalable distributed systems</li>
                    <li>• <strong>Database Optimization:</strong> Designs efficient schemas and indexes</li>
                    <li>• <strong>Security Implementation:</strong> Integrates authentication, encryption, and security best practices</li>
                    <li>• <strong>Performance Optimization:</strong> Implements caching, CDNs, and performance monitoring</li>
                    <li>• <strong>DevOps Integration:</strong> Sets up CI/CD pipelines, containerization, and deployment</li>
                </ul>
            </section>

            <section id="game-development" class="section mb-16">
                <h2 class="text-3xl font-medium mb-6">Game Development & FiveM</h2>
                
                <p class="text-gray-300 mb-6">
                    Can Algorithm excels at creating complex gaming environments, particularly FiveM servers with 
                    advanced roleplay systems, custom frameworks, and innovative gameplay mechanics.
                </p>
                
                <h3 class="text-xl mb-4">FiveM Server Creation</h3>
                <div class="code-block p-4 mb-6">
                    <pre class="text-white text-sm"><code>> can proj "crée un serveur fivem cyberpunk avec système neural implant"

[CAN] Analysing cyberpunk FiveM server requirements...
[CAN] Creating advanced neural implant framework...
[CAN] This is a revolutionary project. Estimated time: 4-6 hours

[CAN] Downloading dependencies:
- ESX Framework (latest)
- MySQL database system
- Custom Lua libraries
- Cyberpunk assets and models

[CAN] Generating systems:
- Neural implant inventory system
- Memory modification mechanics
- Black market implant economy
- Brain-computer interface simulation
- Cybernetic enhancement skill trees

[CAN] Creating 15,000+ lines of custom Lua code...
[CAN] Designing futuristic UI with neon aesthetics...
[CAN] Setting up complex database schemas...

[CAN] Server "CyberLife RP" ready for launch!</code></pre>
                </div>
                
                <h3 class="text-xl mb-4">Advanced Gaming Features</h3>
                <div class="bg-gray-900 rounded-lg p-6 mb-6">
                    <ul class="text-gray-300 space-y-2">
                        <li>• <strong>Custom Frameworks:</strong> ESX, QBCore, vRP, or completely custom systems</li>
                        <li>• <strong>Advanced Mechanics:</strong> Economy systems, skill progression, reputation systems</li>
                        <li>• <strong>Immersive Features:</strong> Weather systems, day/night cycles, realistic physics</li>
                        <li>• <strong>Player Management:</strong> Anti-cheat, admin tools, player statistics</li>
                        <li>• <strong>Custom Assets:</strong> Vehicle modifications, clothing, props, and maps</li>
                    </ul>
                </div>
                
                <h3 class="text-xl mb-4">Roleplay System Examples</h3>
                <div class="space-y-4">
                    <div class="bg-gray-900 rounded-lg p-4">
                        <h4 class="font-medium mb-2 text-cyan-400">Cyberpunk Theme</h4>
                        <p class="text-gray-300 text-sm">Neural implants, hacking systems, corporate warfare, underground markets</p>
                    </div>
                    
                    <div class="bg-gray-900 rounded-lg p-4">
                        <h4 class="font-medium mb-2 text-yellow-400">Medieval Fantasy</h4>
                        <p class="text-gray-300 text-sm">Magic systems, guild warfare, kingdom management, quest systems</p>
                    </div>
                    
                    <div class="bg-gray-900 rounded-lg p-4">
                        <h4 class="font-medium mb-2 text-green-400">Post-Apocalyptic</h4>
                        <p class="text-gray-300 text-sm">Survival mechanics, faction systems, resource scarcity, radiation zones</p>
                    </div>
                </div>
            </section>

            <section id="enterprise-solutions" class="section mb-16">
                <h2 class="text-3xl font-medium mb-6">Enterprise Solutions</h2>
                
                <p class="text-gray-300 mb-6">
                    Can Algorithm can architect and build complete enterprise-grade applications with 
                    advanced features like multi-tenancy, scalability, security, and integration capabilities.
                </p>
                
                <h3 class="text-xl mb-4">Enterprise Application Types</h3>
                <div class="space-y-4 mb-6">
                    <div class="code-block p-4">
                        <code class="text-white block">can proj "create SaaS platform with AI integration and multi-tenancy"</code>
                        <div class="text-gray-400 text-sm mt-2">Builds complete SaaS with tenant isolation, AI/ML pipeline, billing system, and admin dashboard</div>
                    </div>
                    
                    <div class="code-block p-4">
                        <code class="text-white block">can proj "build CRM system with advanced analytics and reporting"</code>
                        <div class="text-gray-400 text-sm mt-2">Creates customer management platform with data visualization, predictive analytics, and automated workflows</div>
                    </div>
                    
                    <div class="code-block p-4">
                        <code class="text-white block">can proj "développer un système ERP complet pour manufacture"</code>
                        <div class="text-gray-400 text-sm mt-2">Develops manufacturing ERP with inventory management, production planning, and supply chain optimization</div>
                    </div>
                </div>
                
                <h3 class="text-xl mb-4">Enterprise Features</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                    <div class="bg-gray-900 rounded-lg p-4">
                        <h4 class="font-medium mb-3 text-blue-400">Scalability & Performance</h4>
                        <ul class="text-sm text-gray-300 space-y-1">
                            <li>• Microservices architecture</li>
                            <li>• Load balancing and auto-scaling</li>
                            <li>• Database optimization and sharding</li>
                            <li>• Caching strategies (Redis, Memcached)</li>
                            <li>• CDN integration</li>
                        </ul>
                    </div>
                    
                    <div class="bg-gray-900 rounded-lg p-4">
                        <h4 class="font-medium mb-3 text-green-400">Security & Compliance</h4>
                        <ul class="text-sm text-gray-300 space-y-1">
                            <li>• OAuth 2.0 and JWT authentication</li>
                            <li>• Role-based access control (RBAC)</li>
                            <li>• Data encryption at rest and in transit</li>
                            <li>• GDPR and SOC 2 compliance</li>
                            <li>• Audit logging and monitoring</li>
                        </ul>
                    </div>
                    
                    <div class="bg-gray-900 rounded-lg p-4">
                        <h4 class="font-medium mb-3 text-purple-400">Integration & APIs</h4>
                        <ul class="text-sm text-gray-300 space-y-1">
                            <li>• RESTful and GraphQL APIs</li>
                            <li>• Third-party service integration</li>
                            <li>• Webhook systems</li>
                            <li>• Event-driven architecture</li>
                            <li>• API documentation and testing</li>
                        </ul>
                    </div>
                    
                    <div class="bg-gray-900 rounded-lg p-4">
                        <h4 class="font-medium mb-3 text-red-400">Analytics & Intelligence</h4>
                        <ul class="text-sm text-gray-300 space-y-1">
                            <li>• Real-time dashboards</li>
                            <li>• Machine learning integration</li>
                            <li>• Predictive analytics</li>
                            <li>• Business intelligence reporting</li>
                            <li>• Data warehouse solutions</li>
                        </ul>
                    </div>
                </div>
                
                <h3 class="text-xl mb-4">Deployment & DevOps</h3>
                <ul class="text-gray-300 space-y-2">
                    <li>• <strong>Containerization:</strong> Docker and Kubernetes orchestration</li>
                    <li>• <strong>CI/CD Pipelines:</strong> Automated testing, building, and deployment</li>
                    <li>• <strong>Infrastructure as Code:</strong> Terraform and CloudFormation templates</li>
                    <li>• <strong>Monitoring:</strong> Application performance monitoring and alerting</li>
                    <li>• <strong>Cloud Integration:</strong> AWS, Azure, Google Cloud Platform</li>
                </ul>
            </section>

            <section id="faq" class="section mb-16">
                <h2 class="text-3xl font-medium mb-6">Frequently Asked Questions</h2>
                
                <div class="space-y-6">
                    <div class="bg-gray-900 rounded-lg p-6">
                        <h3 class="text-lg font-medium mb-3">Is Can Algorithm safe to install?</h3>
                        <p class="text-gray-300">
                            Yes, Can Algorithm is completely safe. It operates locally on your system and never transmits 
                            source code externally. The protection systems are designed to prevent malicious removal, 
                            not to harm your system. You retain full control and can uninstall it anytime using the official process.
                        </p>
                    </div>
                    
                    <div class="bg-gray-900 rounded-lg p-6">
                        <h3 class="text-lg font-medium mb-3">Why does Can need system-level permissions?</h3>
                        <p class="text-gray-300">
                            Can requires elevated permissions to install tools (NPM, Composer, system packages), 
                            set up protection mechanisms, and create system integrations. These permissions are used 
                            solely for legitimate development automation and self-protection purposes.
                        </p>
                    </div>
                    
                    <div class="bg-gray-900 rounded-lg p-6">
                        <h3 class="text-lg font-medium mb-3">Can I use Can Algorithm in commercial projects?</h3>
                        <p class="text-gray-300">
                            Yes, Can Algorithm can be used for commercial development. The generated code belongs to you 
                            and can be used in any project. Enterprise licenses are available for teams and organizations 
                            requiring additional features and support.
                        </p>
                    </div>
                    
                    <div class="bg-gray-900 rounded-lg p-6">
                        <h3 class="text-lg font-medium mb-3">How accurate is the generated code?</h3>
                        <p class="text-gray-300">
                            Can Algorithm has a 97.2% accuracy rate for generated code (2.8% syntax error rate). 
                            It includes automatic testing and validation to ensure code quality. Complex projects 
                            are thoroughly tested before completion.
                        </p>
                    </div>
                    
                    <div class="bg-gray-900 rounded-lg p-6">
                        <h3 class="text-lg font-medium mb-3">Can I create custom plugins?</h3>
                        <p class="text-gray-300">
                            Yes, Can Algorithm features a comprehensive plugin API that allows developers to create 
                            custom extensions. The plugin system supports command registration, file watching, 
                            code generation, and integration with external services.
                        </p>
                    </div>
                    
                    <div class="bg-gray-900 rounded-lg p-6">
                        <h3 class="text-lg font-medium mb-3">What happens if I forget my master password?</h3>
                        <p class="text-gray-300">
                            You can recover your password using your license key through the secure recovery process. 
                            Contact support with your license key for assistance, or use the built-in recovery command 
                            with proper identity verification.
                        </p>
                    </div>
                </div>
            </section>

            <section id="support" class="section mb-16">
                <h2 class="text-3xl font-medium mb-6">Support & Community</h2>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
                    <div class="bg-gray-900 rounded-lg p-6">
                        <h3 class="text-lg font-medium mb-4">🌐 Official Resources</h3>
                        <ul class="space-y-2 text-gray-300">
                            <li>• <a href="https://imators.systems/can" class="text-blue-400 hover:text-blue-300">Official Website</a></li>
                            <li>• <a href="https://imators.systems/can/docs" class="text-blue-400 hover:text-blue-300">Documentation</a></li>
                            <li>• <a href="https://imators.systems/can/key" class="text-blue-400 hover:text-blue-300">License Key Generator</a></li>
                            <li>• <a href="https://github.com/imators/can-algorithm" class="text-blue-400 hover:text-blue-300">GitHub Repository</a></li>
                        </ul>
                    </div>
                    
                    <div class="bg-gray-900 rounded-lg p-6">
                        <h3 class="text-lg font-medium mb-4">💬 Community Support</h3>
                        <ul class="space-y-2 text-gray-300">
                            <li>• Discord Server (24/7 support)</li>
                            <li>• Reddit Community (r/CanAlgorithm)</li>
                            <li>• Stack Overflow (tag: can-algorithm)</li>
                            <li>• Plugin Marketplace</li>
                        </ul>
                    </div>
                </div>
                
                <div class="bg-gradient-to-r from-gray-900 to-gray-800 rounded-lg p-6 mb-8">
                    <h3 class="text-lg font-medium mb-4">🚀 Getting Help</h3>
                    <p class="text-gray-300 mb-4">
                        Can Algorithm includes built-in help and diagnostic tools:
                    </p>
                    <div class="space-y-2">
                        <div class="code-block p-3">
                            <code class="text-white">can help [command]</code>
                            <span class="text-gray-400 text-sm ml-4">Get help for specific commands</span>
                        </div>
                        <div class="code-block p-3">
                            <code class="text-white">can doctor</code>
                            <span class="text-gray-400 text-sm ml-4">Run system diagnostics and health check</span>
                        </div>
                        <div class="code-block p-3">
                            <code class="text-white">can logs</code>
                            <span class="text-gray-400 text-sm ml-4">View recent activity and error logs</span>
                        </div>
                    </div>
                </div>
                
            </section>

        </div>
    </div>

    <script>
        // Mobile menu toggle
        const hamburger = document.getElementById('hamburger');
        const sidebar = document.getElementById('sidebar');
        const mainContent = document.getElementById('mainContent');

        hamburger.addEventListener('click', function() {
            hamburger.classList.toggle('active');
            sidebar.classList.toggle('hidden');
            mainContent.classList.toggle('full-width');
        });

        // Smooth scrolling for navigation links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                    
                    // Close mobile menu after clicking
                    if (window.innerWidth <= 768) {
                        hamburger.classList.remove('active');
                        sidebar.classList.add('hidden');
                        mainContent.classList.add('full-width');
                    }
                }
            });
        });

        // Active section highlighting
        const observerOptions = {
            rootMargin: '-80px 0px -80px 0px',
            threshold: 0.1
        };

        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    // Remove active class from all links
                    document.querySelectorAll('.toc-item').forEach(link => {
                        link.classList.remove('active');
                    });
                    
                    // Add active class to current section link
                    const activeLink = document.querySelector(`a[href="#${entry.target.id}"]`);
                    if (activeLink) {
                        activeLink.classList.add('active');
                    }
                }
            });
        }, observerOptions);

        // Observe all sections
        document.querySelectorAll('.section').forEach(section => {
            observer.observe(section);
        });

        // Handle window resize
        window.addEventListener('resize', function() {
            if (window.innerWidth > 768) {
                sidebar.classList.remove('hidden');
                mainContent.classList.remove('full-width');
                hamburger.classList.remove('active');
            } else {
                sidebar.classList.add('hidden');
                mainContent.classList.add('full-width');
            }
        });
    </script>
</body>
</html>