<?php
require 'vendor/autoload.php';

$dotenv = Dotenv\Dotenv::createImmutable(__DIR__);
$dotenv->load();

// Charger les variables d'environnement
$eventDate = getenv('EVENT_DATE');
$eventAddress = getenv('EVENT_ADDRESS');
$mapkitApiKey = getenv('MAPKIT_API_KEY');
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Événement</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/mapkit-js-core/v1/mapkit.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/mapkit-js-ui/v1/mapkit-ui.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/mapkit-js-ui/v1/mapkit-ui.min.css" rel="stylesheet">
    <style>
        #map {
            height: 300px;
            border-radius: 1rem;
        }
    </style>
</head>
<body class="bg-gray-50 text-gray-900 font-sans">

    <!-- Bande en haut avec des images -->
    <div class="grid grid-cols-2 md:grid-cols-4 gap-4 p-4 bg-white shadow-md">
        <div class="bg-gray-200 h-32 w-full rounded-lg"></div>
        <div class="bg-gray-200 h-32 w-full rounded-lg"></div>
        <div class="bg-gray-200 h-32 w-full rounded-lg"></div>
        <div class="bg-gray-200 h-32 w-full rounded-lg"></div>
    </div>

    <!-- Contenu principal -->
    <div class="container mx-auto p-8">
        <div class="flex flex-col md:flex-row items-center md:items-start justify-between space-y-8 md:space-y-0 md:space-x-8">
            <!-- Titre et description -->
            <div class="md:w-2/3 text-center md:text-left">
                <h1 class="text-5xl font-bold mb-4">Titre de l'événement</h1>
                <p class="text-lg mb-6">Description de l'événement. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
                <!-- Compte à rebours -->
                <div id="countdown" class="bg-white p-6 rounded-lg shadow-md text-center md:text-left">
                    <div class="text-2xl font-semibold mb-2">Compte à rebours</div>
                    <div id="countdown-timer" class="text-3xl font-medium"></div>
                </div>
            </div>

            <!-- Carte avec l'adresse de l'événement -->
            <div class="md:w-1/3">
                <div id="map" class="shadow-md"></div>
            </div>
        </div>
    </div>

    <script>
        // Compte à rebours
        function updateCountdown() {
            const eventDate = new Date("<?php echo $eventDate; ?>").getTime();
            const now = new Date().getTime();
            const distance = eventDate - now;

            const days = Math.floor(distance / (1000 * 60 * 60 * 24));
            const hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            const seconds = Math.floor((distance % (1000 * 60)) / 1000);

            document.getElementById("countdown-timer").innerHTML = ``${{days}j}$`{hours}h `${{minutes}m}$`{seconds}s`;

            if (distance < 0) {
                clearInterval(countdownInterval);
                document.getElementById("countdown-timer").innerHTML = "Événement terminé";
            }
        }

        const countdownInterval = setInterval(updateCountdown, 1000);
        updateCountdown();

        // Carte MapKit
        mapkit.init({
            authorizationCallback: function(done) {
                done("<?php echo $mapkitApiKey; ?>");
            }
        });

        var map = new mapkit.Map("map");
        var address = "<?php echo $eventAddress; ?>";

        var search = new mapkit.Search({region: map.region});
        search.search(address, (error, data) => {
            if (error) {
                console.error(error);
                return;
            }

            var annotation = new mapkit.MarkerAnnotation(data.results[0].coordinate, {
                title: data.results[0].name,
                subtitle: data.results[0].formattedAddress
            });
            map.addAnnotation(annotation);
            map.showItems([annotation]);
        });
    </script>
</body>
</html>
