<?php
$db_host = "localhost:3306";
$db_name = "gqdcvggs_vertchasseur";
$db_user = "gqdcvggs"; 
$db_pass = "imators_onlyforcpanelmachineforallwebsite***#@&&*SECURITY";

try {
    $conn = mysqli_connect($db_host, $db_user, $db_pass, $db_name);
    
    if (!$conn) {
        throw new Exception("La connexion à la base de données a échoué : " . mysqli_connect_error());
    }
    mysqli_set_charset($conn, "utf8mb4");
} catch (Exception $e) {
    error_log("Erreur de base de données : " . $e->getMessage());
    die("Une erreur est survenue lors de la connexion à la base de données. Veuillez réessayer plus tard.");
}

ini_set('display_errors', 0);
error_reporting(E_ALL);

function clean_input($data) {
    global $conn;
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    return mysqli_real_escape_string($conn, $data);
}

class Database {
    private static $instance = null;
    private $connection;
    private $mysqli_conn;
    
    private function __construct() {
        global $conn, $db_host, $db_name, $db_user, $db_pass;
        $this->mysqli_conn = $conn;
        
        try {
            $this->connection = new PDO(
                "mysql:host=" . str_replace(':3306', '', $db_host) . ";dbname=" . $db_name . ";charset=utf8mb4",
                $db_user,
                $db_pass,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false
                ]
            );
        } catch(PDOException $e) {
            error_log("Erreur de connexion PDO : " . $e->getMessage());
            die("Erreur de connexion : " . $e->getMessage());
        }
    }
    
    public function getMysqliConnection() {
        return $this->mysqli_conn;
    }
    
    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    public function getConnection() {
        return $this->connection;
    }
    
    public function query($sql, $params = []) {
        try {
            $stmt = $this->connection->prepare($sql);
            $stmt->execute($params);
            return $stmt;
        } catch(PDOException $e) {
            error_log("Erreur SQL : " . $e->getMessage());
            error_log("SQL : " . $sql);
            error_log("Params : " . print_r($params, true));
            throw $e;
        }
    }
    
    public function fetchAll($sql, $params = []) {
        return $this->query($sql, $params)->fetchAll();
    }
    
    public function fetchOne($sql, $params = []) {
        return $this->query($sql, $params)->fetch();
    }
    
    public function insert($table, $data) {
        $fields = array_keys($data);
        $placeholders = ':' . implode(', :', $fields);
        $sql = "INSERT INTO {$table} (" . implode(', ', $fields) . ") VALUES ({$placeholders})";
        
        $params = [];
        foreach ($data as $key => $value) {
            $params[':' . $key] = $value;
        }
        
        $stmt = $this->query($sql, $params);
        return $this->connection->lastInsertId();
    }
    
    public function update($table, $data, $where, $whereParams = []) {
        $setClause = [];
        $params = [];
        
        foreach ($data as $field => $value) {
            $setClause[] = "{$field} = ?";
            $params[] = $value;
        }
        
        $sql = "UPDATE {$table} SET " . implode(', ', $setClause) . " WHERE {$where}";
        
        foreach ($whereParams as $param) {
            $params[] = $param;
        }
        
        return $this->query($sql, $params);
    }
    
    public function delete($table, $where, $whereParams = []) {
        $sql = "DELETE FROM {$table} WHERE {$where}";
        return $this->query($sql, $whereParams);
    }
    
    public function getConfig($key) {
        try {
            $result = $this->fetchOne("SELECT valeur FROM vr_config WHERE cle = ?", [$key]);
            return $result ? $result['valeur'] : null;
        } catch (Exception $e) {
            error_log("Erreur getConfig pour clé '$key': " . $e->getMessage());
            return null;
        }
    }
    
    public function setConfig($key, $value) {
        try {
            $existing = $this->getConfig($key);
            if ($existing !== null) {
                $this->query("UPDATE vr_config SET valeur = ? WHERE cle = ?", [$value, $key]);
            } else {
                $this->query("INSERT INTO vr_config (cle, valeur) VALUES (?, ?)", [$key, $value]);
            }
            return true;
        } catch (Exception $e) {
            error_log("Erreur setConfig pour clé '$key': " . $e->getMessage());
            return false;
        }
    }
    
    public function tableExists($tableName) {
        try {
            $result = $this->fetchOne("SHOW TABLES LIKE ?", [$tableName]);
            return $result !== false;
        } catch (Exception $e) {
            return false;
        }
    }
    
    public function beginTransaction() {
        return $this->connection->beginTransaction();
    }
    
    public function commit() {
        return $this->connection->commit();
    }
    
    public function rollback() {
        return $this->connection->rollback();
    }
}

function db() {
    return Database::getInstance();
}

function getStripeKeys() {
    $mode = db()->getConfig('stripe_mode') ?: 'demo';
    if ($mode === 'prod') {
        return [
            'public' => db()->getConfig('stripe_public_key_prod') ?: '',
            'secret' => db()->getConfig('stripe_secret_key_prod') ?: ''
        ];
    } else {
        return [
            'public' => db()->getConfig('stripe_public_key_demo') ?: '',
            'secret' => db()->getConfig('stripe_secret_key_demo') ?: ''
        ];
    }
}

function calculateDistance($lat1, $lon1, $lat2, $lon2) {
    $earthRadius = 6371;
    
    $lat1Rad = deg2rad($lat1);
    $lon1Rad = deg2rad($lon1);
    $lat2Rad = deg2rad($lat2);
    $lon2Rad = deg2rad($lon2);
    
    $deltaLat = $lat2Rad - $lat1Rad;
    $deltaLon = $lon2Rad - $lon1Rad;
    
    $a = sin($deltaLat/2) * sin($deltaLat/2) + cos($lat1Rad) * cos($lat2Rad) * sin($deltaLon/2) * sin($deltaLon/2);
    $c = 2 * atan2(sqrt($a), sqrt(1-$a));
    
    return $earthRadius * $c;
}

function calculateDeliveryFees($distance, $nbArticles) {
    $fraisDistance = $distance * 4.99;
    $fraisArticles = $nbArticles * 0.010;
    return round($fraisDistance + $fraisArticles, 2);
}

function isValidAddress($address) {
    $address = strtolower(trim($address));
    return (strpos($address, 'uccle') !== false || strpos($address, 'fort jaco') !== false);
}

function sanitizeInput($input) {
    return htmlspecialchars(trim($input), ENT_QUOTES, 'UTF-8');
}

function generateCSRFToken() {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    if (!isset($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }
    return $_SESSION['csrf_token'];
}

function verifyCSRFToken($token) {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    return isset($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $token);
}

function logError($message, $data = null) {
    $logMessage = "[" . date('Y-m-d H:i:s') . "] " . $message;
    if ($data) {
        $logMessage .= " - Data: " . print_r($data, true);
    }
    error_log($logMessage);
}

function createTablesIfNotExist() {
    try {
        $db = db();
        
        if (!$db->tableExists('vr_config')) {
            $sql = "
            CREATE TABLE vr_config (
                id INT AUTO_INCREMENT PRIMARY KEY,
                cle VARCHAR(100) UNIQUE NOT NULL,
                valeur TEXT NOT NULL,
                updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
            );
            
            INSERT INTO vr_config (cle, valeur) VALUES 
            ('stripe_mode', 'demo'),
            ('stripe_public_key_demo', ''),
            ('stripe_secret_key_demo', ''),
            ('stripe_public_key_prod', ''),
            ('stripe_secret_key_prod', ''),
            ('onesignal_app_id', ''),
            ('onesignal_api_key', '');
            ";
            
            $db->getConnection()->exec($sql);
            logError("Table vr_config créée avec succès");
        }
        
    } catch (Exception $e) {
        logError("Erreur création tables : " . $e->getMessage());
    }
}

createTablesIfNotExist();
?>