<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imators - Upload</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: black;
            color: white;
        }
    </style>
</head>
<body class="bg-black text-white min-h-screen">
    <div class="container mx-auto px-4 py-8">
        <h1 class="text-3xl font-light mb-8 text-center">Imators</h1>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-12">
            <div class="col-span-1 md:col-span-2">
                <form action="" method="post" enctype="multipart/form-data" class="bg-gray-900 p-6 rounded-lg shadow-lg">
                    <h2 class="text-xl font-light mb-6">Publie ton contenu</h2>
                    
                    <div class="mb-4">
                        <label class="block mb-2 font-light">Photo</label>
                        <input type="file" name="photo" accept="image/*" class="w-full bg-gray-800 p-2 rounded">
                    </div>
                    
                    <div class="mb-4">
                        <label class="block mb-2 font-light">Vidéo</label>
                        <input type="file" name="video" accept="video/*" class="w-full bg-gray-800 p-2 rounded">
                    </div>
                    
                    <div class="mt-6">
                        <button type="submit" name="submit" class="w-full bg-blue-600 hover:bg-blue-700 text-white py-2 px-4 rounded transition">Publier</button>
                    </div>
                </form>
                
                <?php
                if(isset($_POST['submit'])) {
                    // Création du dossier s'il n'existe pas
                    if(!is_dir('price')) {
                        mkdir('price', 0777, true);
                    }
                    
                    $uploadOk = false;
                    $fileType = '';
                    $newFileName = '';
                    
                    // Traitement de la photo
                    if(isset($_FILES['photo']) && $_FILES['photo']['error'] == 0) {
                        $fileType = 'image';
                        $extension = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);
                        $newFileName = 'price/img_' . time() . '.' . $extension;
                        
                        if(move_uploaded_file($_FILES['photo']['tmp_name'], $newFileName)) {
                            $uploadOk = true;
                        }
                    }
                    
                    // Traitement de la vidéo
                    if(isset($_FILES['video']) && $_FILES['video']['error'] == 0) {
                        $fileType = 'video';
                        $extension = pathinfo($_FILES['video']['name'], PATHINFO_EXTENSION);
                        $newFileName = 'price/video_' . time() . '.' . $extension;
                        
                        if(move_uploaded_file($_FILES['video']['tmp_name'], $newFileName)) {
                            $uploadOk = true;
                        }
                    }
                    
                    // Affichage du résultat
                    if($uploadOk) {
                        // Générer un prix aléatoire entre 50 et 500
                        $price = rand(50, 500);
                        
                        echo '<div class="mt-6 bg-green-900 p-4 rounded">';
                        echo '<h3 class="text-xl font-light mb-2">Publication réussie!</h3>';
                        echo '<p>Le prix de revenus estimé pour ce contenu est: <span class="text-2xl font-medium">' . $price . '€</span></p>';
                        
                        if($fileType == 'image') {
                            echo '<div class="mt-4"><img src="' . $newFileName . '" class="max-w-full h-auto rounded" alt="Image uploadée"></div>';
                        } elseif($fileType == 'video') {
                            echo '<div class="mt-4"><video controls class="max-w-full h-auto rounded"><source src="' . $newFileName . '" type="video/' . $extension . '">Votre navigateur ne supporte pas la vidéo</video></div>';
                        }
                        
                        echo '</div>';
                    } else if(isset($_POST['submit'])) {
                        echo '<div class="mt-6 bg-red-900 p-4 rounded">';
                        echo '<h3 class="text-xl font-light mb-2">Erreur</h3>';
                        echo '<p>Une erreur est survenue lors de l\'upload. Veuillez réessayer.</p>';
                        echo '</div>';
                    }
                }
                ?>
            </div>
            
            <div class="col-span-1">
                <div class="bg-gray-900 p-6 rounded-lg shadow-lg">
                    <h2 class="text-xl font-light mb-6">Exemples d'artistes</h2>
                    
                    <div class="space-y-6">
                        <div>
                            <img src="https://source.unsplash.com/random/300x500/?portrait,artist" alt="Artiste 1" class="w-full h-auto rounded-lg">
                            <p class="mt-2 text-center">Prix généré: 320€</p>
                        </div>
                        
                        <div>
                            <img src="https://source.unsplash.com/random/300x500/?portrait,creator" alt="Artiste 2" class="w-full h-auto rounded-lg">
                            <p class="mt-2 text-center">Prix généré: 175€</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>