<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imators - Upload XXX</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: black;
            color: white;
            background-image: linear-gradient(to bottom, rgba(0,0,0,0.9) 0%, rgba(20,20,20,0.8) 100%);
        }
        .neon-text {
            text-shadow: 0 0 10px #ff69b4, 0 0 20px #ff69b4, 0 0 30px #ff69b4;
        }
        .glow-border {
            box-shadow: 0 0 10px rgba(255, 105, 180, 0.5), 0 0 20px rgba(255, 105, 180, 0.3);
        }
        .upload-btn {
            background: linear-gradient(to right, #ff00cc, #333399);
        }
        .card-hover:hover {
            transform: translateY(-5px);
            box-shadow: 0 0 20px rgba(255, 105, 180, 0.7);
        }
    </style>
</head>
<body class="bg-black text-white min-h-screen">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4 sm:py-8">
        <!-- Header -->
        <header class="text-center mb-6 sm:mb-10">
            <h1 class="text-3xl sm:text-4xl font-light mb-2 neon-text">Imators<span class="text-pink-500">XXX</span></h1>
            <p class="text-gray-400 text-sm sm:text-base">Publie ton contenu et gagne</p>
        </header>
        
        <!-- Créateurs en vedette (mobile seulement - horizontal scroll) -->
        <div class="block sm:hidden mb-8">
            <h2 class="text-xl font-light mb-4">Nos Top Créateurs</h2>
            <div class="flex overflow-x-auto pb-4 space-x-4 scrollbar-hide">
                <div class="flex-shrink-0 w-48 card-hover transition-all duration-300">
                    <div class="relative">
                        <img src="https://source.unsplash.com/random/300x400/?model,sensual" alt="Créateur 1" class="w-full h-64 object-cover rounded-lg">
                        <div class="absolute bottom-0 left-0 right-0 bg-gradient-to-t from-black to-transparent p-3">
                            <p class="font-medium">Emma Rose</p>
                            <div class="flex justify-between items-center">
                                <span class="text-pink-300 text-xs">15 contenus</span>
                                <span class="bg-pink-600 text-white px-2 py-1 rounded-full text-xs">1250€/mois</span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="flex-shrink-0 w-48 card-hover transition-all duration-300">
                    <div class="relative">
                        <img src="https://source.unsplash.com/random/300x400/?model,portrait" alt="Créateur 2" class="w-full h-64 object-cover rounded-lg">
                        <div class="absolute bottom-0 left-0 right-0 bg-gradient-to-t from-black to-transparent p-3">
                            <p class="font-medium">Alex Devine</p>
                            <div class="flex justify-between items-center">
                                <span class="text-pink-300 text-xs">23 contenus</span>
                                <span class="bg-pink-600 text-white px-2 py-1 rounded-full text-xs">1850€/mois</span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="flex-shrink-0 w-48 card-hover transition-all duration-300">
                    <div class="relative">
                        <img src="https://source.unsplash.com/random/300x400/?model,glamour" alt="Créateur 3" class="w-full h-64 object-cover rounded-lg">
                        <div class="absolute bottom-0 left-0 right-0 bg-gradient-to-t from-black to-transparent p-3">
                            <p class="font-medium">Mia Chen</p>
                            <div class="flex justify-between items-center">
                                <span class="text-pink-300 text-xs">31 contenus</span>
                                <span class="bg-pink-600 text-white px-2 py-1 rounded-full text-xs">2350€/mois</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Main Content -->
        <div class="flex flex-col sm:flex-row gap-6">
            <!-- Upload Form -->
            <div class="w-full sm:w-2/3">
                <form action="" method="post" enctype="multipart/form-data" class="bg-gray-900 bg-opacity-80 p-4 sm:p-8 rounded-xl shadow-lg glow-border transition duration-300">
                    <h2 class="text-xl sm:text-2xl font-light mb-4 sm:mb-6">Fais monter la température 🔥</h2>
                    
                    <div class="mb-4 sm:mb-6">
                        <label class="block mb-2 font-light text-pink-300">Ta photo sexy</label>
                        <input type="file" name="photo" accept="image/*" class="w-full bg-gray-800 bg-opacity-70 p-2 sm:p-3 rounded border border-pink-700 focus:outline-none focus:ring-2 focus:ring-pink-500">
                        <p class="text-xs text-gray-400 mt-1">Formats acceptés: JPG, PNG (Max: 10MB)</p>
                    </div>
                    
                    <div class="mb-4 sm:mb-6">
                        <label class="block mb-2 font-light text-pink-300">Ta vidéo hot</label>
                        <input type="file" name="video" accept="video/*" class="w-full bg-gray-800 bg-opacity-70 p-2 sm:p-3 rounded border border-pink-700 focus:outline-none focus:ring-2 focus:ring-pink-500">
                        <p class="text-xs text-gray-400 mt-1">Formats acceptés: MP4, MOV (Max: 50MB)</p>
                    </div>
                    
                    <div class="mt-6 sm:mt-8">
                        <button type="submit" name="submit" class="w-full upload-btn text-white py-3 px-6 rounded-lg font-medium transition duration-300 transform hover:scale-105">PUBLIER MAINTENANT</button>
                        <p class="text-center text-gray-400 mt-2 text-xs sm:text-sm">Ton contenu sera vérifié selon nos <a href="#" class="text-pink-400 hover:underline">conditions</a></p>
                    </div>
                </form>
                
                <?php
                if(isset($_POST['submit'])) {
                    // Création du dossier s'il n'existe pas
                    if(!is_dir('price')) {
                        mkdir('price', 0777, true);
                    }
                    
                    $uploadOk = false;
                    $fileType = '';
                    $newFileName = '';
                    $fileInfo = array();
                    
                    // Traitement de la photo
                    if(isset($_FILES['photo']) && $_FILES['photo']['error'] == 0) {
                        $fileType = 'image';
                        $extension = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);
                        $newFileName = 'price/img_' . time() . '.' . $extension;
                        
                        if(move_uploaded_file($_FILES['photo']['tmp_name'], $newFileName)) {
                            $uploadOk = true;
                            $fileInfo['type'] = 'image';
                            $fileInfo['path'] = $newFileName;
                        }
                    }
                    
                    // Traitement de la vidéo
                    if(isset($_FILES['video']) && $_FILES['video']['error'] == 0) {
                        $fileType = 'video';
                        $extension = pathinfo($_FILES['video']['name'], PATHINFO_EXTENSION);
                        $newFileName = 'price/video_' . time() . '.' . $extension;
                        
                        if(move_uploaded_file($_FILES['video']['tmp_name'], $newFileName)) {
                            $uploadOk = true;
                            $fileInfo['type'] = 'video';
                            $fileInfo['path'] = $newFileName;
                            $fileInfo['extension'] = $extension;
                        }
                    }
                    
                    if($uploadOk) {
                        // Générer un prix aléatoire
                        $price = rand(100, 2000);
                        
                        // Stocker les infos dans la session
                        session_start();
                        $_SESSION['upload_info'] = array(
                            'price' => $price,
                            'file' => $fileInfo
                        );
                        
                        // Rediriger vers la page de succès
                        header('Location: success.php');
                        exit();
                    } else {
                        echo '<div class="mt-6 bg-red-900 p-4 sm:p-6 rounded-xl">';
                        echo '<h3 class="text-xl font-light mb-2">Erreur 😕</h3>';
                        echo '<p>Une erreur est survenue lors de l\'upload. Vérifie la taille et le format de ton fichier.</p>';
                        echo '</div>';
                    }
                }
                ?>
                
                <!-- Stats Section (Mobile) -->
                <div class="block sm:hidden mt-8 bg-gray-900 bg-opacity-70 p-4 rounded-xl text-center">
                    <p class="text-xl font-light mb-2">Rejoins nos <span class="text-pink-400">1 500+</span> créateurs</p>
                    <p class="text-gray-400 text-sm">Nos meilleurs créateurs gagnent plus de 5 000€ par mois</p>
                </div>
            </div>
            
            <!-- Sidebar (desktop only) -->
            <div class="hidden sm:block sm:w-1/3">
                <div class="bg-gray-900 bg-opacity-70 p-6 rounded-xl shadow-lg glow-border sticky top-4">
                    <h2 class="text-xl font-light mb-6">Nos Top Créateurs</h2>
                    
                    <div class="space-y-6">
                        <div class="card-hover transition-all duration-300">
                            <div class="relative">
                                <img src="https://source.unsplash.com/random/300x400/?model,sensual" alt="Créateur 1" class="w-full h-auto rounded-lg object-cover">
                                <div class="absolute bottom-0 left-0 right-0 bg-gradient-to-t from-black to-transparent p-4">
                                    <p class="font-medium">Emma Rose</p>
                                    <div class="flex justify-between items-center">
                                        <span class="text-pink-300 font-light">15 contenus</span>
                                        <span class="bg-pink-600 text-white px-3 py-1 rounded-full text-sm">1250€/mois</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="card-hover transition-all duration-300">
                            <div class="relative">
                                <img src="https://source.unsplash.com/random/300x400/?model,portrait" alt="Créateur 2" class="w-full h-auto rounded-lg object-cover">
                                <div class="absolute bottom-0 left-0 right-0 bg-gradient-to-t from-black to-transparent p-4">
                                    <p class="font-medium">Alex Devine</p>
                                    <div class="flex justify-between items-center">
                                        <span class="text-pink-300 font-light">23 contenus</span>
                                        <span class="bg-pink-600 text-white px-3 py-1 rounded-full text-sm">1850€/mois</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mt-8 text-center">
                        <p class="text-xl font-light mb-2">Rejoins nos <span class="text-pink-400">1 500+</span> créateurs</p>
                        <p class="text-gray-400 text-sm">Nos meilleurs créateurs gagnent plus de 5 000€ par mois</p>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Footer -->
        <footer class="text-center text-gray-500 text-xs sm:text-sm mt-8 sm:mt-12 pb-6">
            <p>&copy; 2025 Imators XXX - Tous droits réservés</p>
            <p class="mt-2">En utilisant ce site, tu acceptes nos <a href="#" class="text-pink-400 hover:underline">conditions d'utilisation</a> et notre <a href="#" class="text-pink-400 hover:underline">politique de confidentialité</a></p>
        </footer>
    </div>
</body>
</html>