<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imators Support</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600&display=swap" rel="stylesheet">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <style type="text/css">
        @import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap');
        body {
            font-family: 'Space Grotesk', sans-serif;
            background-color: #000;
            color: #f5f5f5;
        }
        
        .card-container {
            perspective: 1500px;
            height: 100%;
        }
        
        .card {
            position: relative;
            height: 100%;
            width: 100%;
            transform-style: preserve-3d;
            transition: transform 0.8s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        }
        
        .card.flipped {
            transform: rotateY(180deg);
        }
        
        .card-front, .card-back {
            position: absolute;
            width: 100%;
            height: 100%;
            backface-visibility: hidden;
            border-radius: 1rem;
            overflow: hidden;
            display: flex;
            flex-direction: column;
        }
        
        .card-front {
            background: rgba(15, 15, 15, 0.8);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        .card-back {
            background: rgba(15, 15, 15, 0.9);
            transform: rotateY(180deg);
            border: 1px solid rgba(59, 130, 246, 0.3);
        }
        
        .card-btn {
            cursor: pointer;
            border: none;
            transition: all 0.3s ease;
        }
        
        .card-btn:hover {
            transform: translateY(-2px);
        }
        
        .card-content {
            flex-grow: 1;
        }
        
        @media (max-width: 640px) {
            .support-grid {
                grid-template-columns: 1fr;
            }
        }
        
        @media (min-width: 641px) and (max-width: 1024px) {
            .support-grid {
                grid-template-columns: repeat(2, 1fr);
            }
        }
        
        @media (min-width: 1025px) {
            .support-grid {
                grid-template-columns: repeat(4, 1fr);
            }
        }
        
        .faq-item {
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            overflow: hidden;
        }
        
        .faq-question {
            cursor: pointer;
            width: 100%;
            text-align: left;
            transition: all 0.3s ease;
        }
        
        .faq-answer {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.3s ease, padding 0.3s ease, opacity 0.3s ease;
            opacity: 0;
        }
        
        .faq-answer.active {
            max-height: 500px;
            opacity: 1;
            padding-bottom: 1.5rem;
        }
        
        .rotate-icon {
            transition: transform 0.3s ease;
        }
        
        .rotate-icon.active {
            transform: rotate(180deg);
        }
    </style>
</head>
<body class="min-h-screen">
    <?php include 'src/header.php'; ?>

    <main class="container mx-auto px-4 py-12 relative">
        <div class="max-w-6xl mx-auto">
            <!-- Hero Section -->
            <section class="text-center mb-16" data-aos="fade-up">
                <h1 class="text-5xl md:text-6xl font-light mb-6 text-white">Support</h1>
                <p class="text-xl text-gray-300 max-w-3xl mx-auto">
                    Our support team is available to assist you with any inquiries. Please explore our support options below.
                </p>
            </section>
            
            <!-- Support Categories -->
            <section class="grid support-grid gap-6 mb-16">
                <!-- Card 1 - Client Support -->
                <div class="h-80 card-container" data-aos="fade-up" data-aos-delay="100">
                    <div class="card">
                        <div class="card-front p-6 border-t-4 border-blue-500">
                            <div class="card-content">
                                <div class="h-12 w-12 bg-blue-500 rounded-lg flex items-center justify-center mb-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8h2a2 2 0 012 2v6a2 2 0 01-2 2h-2v4l-4-4H9a1.994 1.994 0 01-1.414-.586m0 0L11 14h4a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2v4l.586-.586z" />
                                    </svg>
                                </div>
                                <h2 class="text-2xl font-medium text-white mb-3">Client Support</h2>
                                <p class="text-gray-300 mb-4">
                                    Dedicated assistance for existing Imators account holders.
                                </p>
                            </div>
                            <button class="card-btn w-full bg-white text-black py-4 rounded-lg font-medium hover:bg-gray-100 transition-colors">
                                Learn More
                            </button>
                        </div>
                        <div class="card-back p-6">
                            <div class="card-content overflow-y-auto">
                                <h2 class="text-2xl font-medium text-white mb-4">Client Support</h2>
                                <p class="text-gray-300 mb-4">
                                    Our client support team is available to assist you with:
                                </p>
                                <ul class="space-y-2 mb-4">
                                    <li class="flex items-start">
                                        <span class="text-blue-400 mr-2">•</span>
                                        <span>Technical issues and troubleshooting</span>
                                    </li>
                                    <li class="flex items-start">
                                        <span class="text-blue-400 mr-2">•</span>
                                        <span>Account and billing enquiries</span>
                                    </li>
                                    <li class="flex items-start">
                                        <span class="text-blue-400 mr-2">•</span>
                                        <span>Product assistance and guidance</span>
                                    </li>
                                </ul>
                                <a href="https://idsma.imators.com" class="inline-block text-blue-400 hover:text-blue-300 underline mb-4">
                                    Access your ticket portal
                                </a>
                            </div>
                            <button class="card-btn w-full bg-blue-600 text-white py-4 rounded-lg font-medium hover:bg-blue-500 transition-colors">
                                Back
                            </button>
                        </div>
                    </div>
                </div>
                
                <!-- Card 2 - Commercial Support -->
                <div class="h-80 card-container" data-aos="fade-up" data-aos-delay="150">
                    <div class="card">
                        <div class="card-front p-6 border-t-4 border-purple-500">
                            <div class="card-content">
                                <div class="h-12 w-12 bg-purple-500 rounded-lg flex items-center justify-center mb-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2" />
                                    </svg>
                                </div>
                                <h2 class="text-2xl font-medium text-white mb-3">Commercial Support</h2>
                                <p class="text-gray-300 mb-4">
                                    For business enquiries, partnerships, and commercial opportunities.
                                </p>
                            </div>
                            <button class="card-btn w-full bg-white text-black py-4 rounded-lg font-medium hover:bg-gray-100 transition-colors">
                                Learn More
                            </button>
                        </div>
                        <div class="card-back p-6">
                            <div class="card-content overflow-y-auto">
                                <h2 class="text-2xl font-medium text-white mb-4">Commercial Support</h2>
                                <p class="text-gray-300 mb-4">
                                    Our commercial team is available for:
                                </p>
                                <ul class="space-y-2 mb-4">
                                    <li class="flex items-start">
                                        <span class="text-purple-400 mr-2">•</span>
                                        <span>Bespoke business solutions</span>
                                    </li>
                                    <li class="flex items-start">
                                        <span class="text-purple-400 mr-2">•</span>
                                        <span>Strategic partnerships</span>
                                    </li>
                                    <li class="flex items-start">
                                        <span class="text-purple-400 mr-2">•</span>
                                        <span>Custom quotes and enterprise offerings</span>
                                    </li>
                                </ul>
                                <p class="text-gray-300">
                                    Contact us at 
                                    <a href="mailto:contact@imators.com" class="text-purple-400 hover:text-purple-300">
                                        contact@imators.com
                                    </a>
                                </p>
                            </div>
                            <button class="card-btn w-full bg-purple-600 text-white py-4 rounded-lg font-medium hover:bg-purple-500 transition-colors">
                                Back
                            </button>
                        </div>
                    </div>
                </div>
                
                <!-- Card 3 - Non-Account Support -->
                <div class="h-80 card-container" data-aos="fade-up" data-aos-delay="200">
                    <div class="card">
                        <div class="card-front p-6 border-t-4 border-green-500">
                            <div class="card-content">
                                <div class="h-12 w-12 bg-green-500 rounded-lg flex items-center justify-center mb-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                    </svg>
                                </div>
                                <h2 class="text-2xl font-medium text-white mb-3">Non-Account Support</h2>
                                <p class="text-gray-300 mb-4">
                                    Assistance for visitors and potential clients without an Imators account.
                                </p>
                            </div>
                            <button class="card-btn w-full bg-white text-black py-4 rounded-lg font-medium hover:bg-gray-100 transition-colors">
                                Learn More
                            </button>
                        </div>
                        <div class="card-back p-6">
                            <div class="card-content overflow-y-auto">
                                <h2 class="text-2xl font-medium text-white mb-4">Non-Account Support</h2>
                                <p class="text-gray-300 mb-4">
                                    Don't have an account yet? We can still help with:
                                </p>
                                <ul class="space-y-2 mb-4">
                                    <li class="flex items-start">
                                        <span class="text-green-400 mr-2">•</span>
                                        <span>General product information</span>
                                    </li>
                                    <li class="flex items-start">
                                        <span class="text-green-400 mr-2">•</span>
                                        <span>Account creation assistance</span>
                                    </li>
                                    <li class="flex items-start">
                                        <span class="text-green-400 mr-2">•</span>
                                        <span>Pre-sales questions</span>
                                    </li>
                                </ul>
                                <p class="text-gray-300">
                                    <a href="mailto:info@imators.com" class="text-green-400 hover:text-green-300">
                                        info@imators.com
                                    </a>
                                </p>
                            </div>
                            <button class="card-btn w-full bg-green-600 text-white py-4 rounded-lg font-medium hover:bg-green-500 transition-colors">
                                Back
                            </button>
                        </div>
                    </div>
                </div>
                
                <!-- Card 4 - FAQ -->
                <div class="h-80 card-container" data-aos="fade-up" data-aos-delay="250">
                    <div class="card">
                        <div class="card-front p-6 border-t-4 border-yellow-500">
                            <div class="card-content">
                                <div class="h-12 w-12 bg-yellow-500 rounded-lg flex items-center justify-center mb-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.228 9c.549-1.165 2.03-2 3.772-2 2.21 0 4 1.343 4 3 0 1.4-1.278 2.575-3.006 2.907-.542.104-.994.54-.994 1.093m0 3h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                </div>
                                <h2 class="text-2xl font-medium text-white mb-3">FAQ</h2>
                                <p class="text-gray-300 mb-4">
                                    Find answers to frequently asked questions about our services.
                                </p>
                            </div>
                            <button class="card-btn w-full bg-white text-black py-4 rounded-lg font-medium hover:bg-gray-100 transition-colors">
                                View FAQs
                            </button>
                        </div>
                        <div class="card-back p-6">
                            <div class="card-content overflow-y-auto">
                                <h2 class="text-2xl font-medium text-white mb-4">Quick FAQs</h2>
                                <div class="space-y-4">
                                    <div>
                                        <h3 class="text-white font-medium">How do I create an account?</h3>
                                        <p class="text-gray-300">Visit our registration page and follow the step-by-step instructions to set up your account.</p>
                                    </div>
                                    <div>
                                        <h3 class="text-white font-medium">What is the support response time?</h3>
                                        <p class="text-gray-300">We typically respond to all support requests within 24 business hours.</p>
                                    </div>
                                </div>
                                <a href="#faq-section" class="inline-block text-yellow-400 hover:text-yellow-300 underline mt-4 card-btn-link">
                                    View all FAQs
                                </a>
                            </div>
                            <button class="card-btn w-full bg-yellow-600 text-white py-4 rounded-lg font-medium hover:bg-yellow-500 transition-colors">
                                Back
                            </button>
                        </div>
                    </div>
                </div>
            </section>
            
            <!-- FAQ Section -->
            <section id="faq-section" class="mb-16" data-aos="fade-up">
                <h2 class="text-3xl font-light text-white mb-8 text-center">Frequently Asked Questions</h2>
                
                <div class="max-w-3xl mx-auto bg-gray-900/50 rounded-xl p-6">
                    <!-- FAQ Item 1 -->
                    <div class="faq-item py-2">
                        <button class="faq-question flex justify-between items-center w-full py-4 px-2">
                            <span class="text-xl text-white font-light">How do I create an account?</span>
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400 rotate-icon" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                            </svg>
                        </button>
                        <div class="faq-answer px-2">
                            <p class="text-gray-300">
                                To create an account, please visit our registration page and follow the step-by-step instructions. You'll need to provide a valid email address, create a strong password, and complete the verification process before accessing your new account.
                            </p>
                        </div>
                    </div>
                    
                    <!-- FAQ Item 2 -->
                    <div class="faq-item py-2">
                        <button class="faq-question flex justify-between items-center w-full py-4 px-2">
                            <span class="text-xl text-white font-light">How do I reset my password?</span>
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400 rotate-icon" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                            </svg>
                        </button>
                        <div class="faq-answer px-2">
                            <p class="text-gray-300">
                                To reset your password, click on the "Forgot Password" link on the login page. You'll receive a password reset link at your registered email address. Follow the instructions in the email to create a new password.
                            </p>
                        </div>
                    </div>
                    
                    <!-- FAQ Item 3 -->
                    <div class="faq-item py-2">
                        <button class="faq-question flex justify-between items-center w-full py-4 px-2">
                            <span class="text-xl text-white font-light">What is your support response time?</span>
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400 rotate-icon" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                            </svg>
                        </button>
                        <div class="faq-answer px-2">
                            <p class="text-gray-300">
                                We typically respond to all support requests within 24 business hours. For urgent matters, premium account holders receive priority support with faster response times.
                            </p>
                        </div>
                    </div>
                    
                    <!-- FAQ Item 4 -->
                    <div class="faq-item py-2">
                        <button class="faq-question flex justify-between items-center w-full py-4 px-2">
                            <span class="text-xl text-white font-light">How can I upgrade my account?</span>
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400 rotate-icon" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                            </svg>
                        </button>
                        <div class="faq-answer px-2">
                            <p class="text-gray-300">
                                To upgrade your account, log in to your dashboard and navigate to the "Account Settings" page. Click on the "Upgrade" button and select your preferred plan. Follow the on-screen instructions to complete the upgrade process.
                            </p>
                        </div>
                    </div>
                    
                    <!-- FAQ Item 5 -->
                    <div class="faq-item py-2">
                        <button class="faq-question flex justify-between items-center w-full py-4 px-2">
                            <span class="text-xl text-white font-light">Do you offer refunds?</span>
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400 rotate-icon" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                            </svg>
                        </button>
                        <div class="faq-answer px-2">
                            <p class="text-gray-300">
                                Yes, we offer a 14-day money-back guarantee on all new subscriptions. If you're not satisfied with our services within the first 14 days, you can request a full refund. Please note that certain conditions may apply. For detailed information, please refer to our Refund Policy.
                            </p>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </main>

    <footer class="bg-black text-white">
        <div class="max-w-6xl mx-auto px-4 py-10 flex flex-wrap justify-between">
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Follow Us</h5>
                <div class="flex items-center space-x-4">
                    <a href="https://instagram.com/this.is.imators" class="text-sm font-medium duration-700 hover:text-gray-100 flex items-center">
                        <img src="https://uxwing.com/wp-content/themes/uxwing/download/brands-and-social-media/instagram-white-icon.png" alt="Instagram" class="w-6 h-6 mr-2">
                        <span>Instagram</span>
                    </a>
                </div>
            </div>
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Discover</h5>
                <a href="/privacy" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
                    Privacy Policy
                </a>
                <a href="/terms-of-use" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
                    Terms of Use
                </a>
                <a href="/" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
                    Home
                </a>
                <a href="/about-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
                    About Us
                </a>
                <a href="/contact-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
                    Contact Us
                </a>
            </div>
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Because it's possible</h5>
                <p class="text-sm">
                    All images, videos, and content on this site are the property of Imators.
                </p>
            </div>
        </div>

        <div class="text-center py-4 border-t border-gray-800">
            <p class="text-sm mb-2">
                &copy; 2025 Imators. All rights reserved.
            </p>
            <p class="text-xs">
                Imators is a registered LLC (Limited Liability Company). All our products, whether technologically physical or simply online, are subject to our rules, which you can access.
            </p>
        </div>
    </footer>

    <script>
        // Initialise AOS (Animate On Scroll)
        AOS.init({
            duration: 800,
            once: true,
            offset: 100
        });
        
        // Script for flip cards
        document.addEventListener('DOMContentLoaded', function() {
            const cards = document.querySelectorAll('.card-container');
            
            cards.forEach(container => {
                const card = container.querySelector('.card');
                const frontBtn = container.querySelector('.card-front .card-btn');
                const backBtn = container.querySelector('.card-back .card-btn');
                const cardBtnLink = container.querySelector('.card-btn-link');
                
                if (frontBtn) {
                    frontBtn.addEventListener('click', () => {
                        card.classList.add('flipped');
                    });
                }
                
                if (backBtn) {
                    backBtn.addEventListener('click', () => {
                        card.classList.remove('flipped');
                    });
                }
                
                if (cardBtnLink) {
                    cardBtnLink.addEventListener('click', () => {
                        card.classList.remove('flipped');
                    });
                }
            });
            
            // FAQ accordion functionality
            const faqQuestions = document.querySelectorAll('.faq-question');
            
            faqQuestions.forEach(question => {
                question.addEventListener('click', () => {
                    const answer = question.nextElementSibling;
                    const icon = question.querySelector('.rotate-icon');
                    
                    // Toggle the active class
                    answer.classList.toggle('active');
                    icon.classList.toggle('active');
                    
                    // Close other FAQs
                    faqQuestions.forEach(otherQuestion => {
                        if (otherQuestion !== question) {
                            const otherAnswer = otherQuestion.nextElementSibling;
                            const otherIcon = otherQuestion.querySelector('.rotate-icon');
                            
                            otherAnswer.classList.remove('active');
                            otherIcon.classList.remove('active');
                        }
                    });
                });
            });
        });
    </script>
</body>
</html>