<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Support - Imators</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.1.2/dist/tailwind.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap');
        body {
            font-family: 'Space Grotesk', sans-serif;
            background-color: #000000;
            color: #FFFFFF;
        }
        
        header {
            background-color: rgba(0, 0, 0, 0.8);
        }
        
        .separator {
            height: 1px;
            background-color: #333;
            width: 100%;
            margin: 30px 0;
        }
        
        a.text-link {
            position: relative;
            color: #FFFFFF;
            text-decoration: none;
            padding-bottom: 2px;
        }
        
        a.text-link::after {
            content: '';
            position: absolute;
            width: 100%;
            height: 1px;
            bottom: 0;
            left: 0;
            background-color: #FFFFFF;
            transform: scaleX(0);
            transform-origin: bottom right;
            transition: transform 0.3s;
        }
        
        a.text-link:hover::after {
            transform: scaleX(1);
            transform-origin: bottom left;
        }
    </style>
</head>
<body>
    <?php include 'src/header.php'; ?>

    <div class="w-full h-64 md:h-80 lg:h-96 overflow-hidden">
        <img src="banner_color.png" alt="Support Banner" class="w-full h-full object-cover">
    </div>
    
    <div class="container px-4 mx-auto py-12">
        <h1 class="text-4xl font-light mb-6">Support.</h1>
        <p class="text-xl text-gray-400 mb-12">This page contains everything you need to contact us at the right address.</p>
        
        <div class="separator"></div>
        
        <div class="py-6 flex flex-wrap items-center">
            <div class="w-full md:w-1/4 mb-4 md:mb-0">
                <h3 class="text-xl font-light">Hardware Support</h3>
            </div>
            <div class="w-full md:w-2/4 mb-4 md:mb-0">
                <p class="text-gray-400">Technical issues with any of our products purchased from a Cergies Store.</p>
                <p class="text-sm text-gray-500 mt-2">Account required</p>
            </div>
            <div class="w-full md:w-1/4 text-right">
                <a href="https://idsma.imators.com" class="text-link">Access Support Portal →</a>
            </div>
        </div>
        
        <div class="separator"></div>
        
        <div class="py-6 flex flex-wrap items-center">
            <div class="w-full md:w-1/4 mb-4 md:mb-0">
                <h3 class="text-xl font-light">Press Inquiries</h3>
            </div>
            <div class="w-full md:w-2/4 mb-4 md:mb-0">
                <p class="text-gray-400">For interview requests or article placement.</p>
                <p class="text-sm text-gray-500 mt-2">press@imators.com</p>
            </div>
            <div class="w-full md:w-1/4 text-right">
                <a href="mailto:press@imators.com" class="text-link">Contact Press Team →</a>
            </div>
        </div>
        
        <div class="separator"></div>
        
        <div class="py-6 flex flex-wrap items-center">
            <div class="w-full md:w-1/4 mb-4 md:mb-0">
                <h3 class="text-xl font-light">Technical Support</h3>
            </div>
            <div class="w-full md:w-2/4 mb-4 md:mb-0">
                <p class="text-gray-400">For network issues or service unavailability.</p>
                <p class="text-sm text-gray-500 mt-2">Account required</p>
            </div>
            <div class="w-full md:w-1/4 text-right">
                <a href="https://idsma.imators.com" class="text-link">Access Support Portal →</a>
            </div>
        </div>
        
        <div class="separator"></div>
        
        <div class="py-6 flex flex-wrap items-center">
            <div class="w-full md:w-1/4 mb-4 md:mb-0">
                <h3 class="text-xl font-light">Community Forum</h3>
            </div>
            <div class="w-full md:w-2/4 mb-4 md:mb-0">
                <p class="text-gray-400">Join our community to find answers and share experiences.</p>
            </div>
            <div class="w-full md:w-1/4 text-right">
                <a href="/forum" class="text-link">Visit Forum →</a>
            </div>
        </div>
        
        <div class="separator"></div>
        
        <div class="py-10">
            <h2 class="text-2xl font-light mb-8">Need Quick Help?</h2>
            
            <div class="flex flex-wrap">
                <div class="w-full md:w-1/2 mb-8 md:mb-0">
                    <h3 class="text-lg font-light mb-2">Knowledge Base</h3>
                    <p class="text-gray-400 mb-2">Browse guides and solutions to common issues.</p>
                    <a href="/kb" class="text-link">Explore Knowledge Base →</a>
                </div>
                
                <div class="w-full md:w-1/2">
                    <h3 class="text-lg font-light mb-2">Downloads</h3>
                    <p class="text-gray-400 mb-2">Access manuals, updates, and drivers.</p>
                    <a href="/downloads" class="text-link">Go to Downloads →</a>
                </div>
            </div>
            
            <div class="mt-10">
                <p class="text-gray-400 mb-4">Still can't find what you're looking for?</p>
                <a href="/contact" class="text-link">Contact Us →</a>
            </div>
        </div>
        
        <div class="separator"></div>
        
        <div class="py-6">
            <h2 class="text-2xl font-light mb-6">Support Hours</h2>
            <p>Everyday : 9:00 AM - 6:00 PM GMT</p>
            <p class="text-gray-400 text-sm mt-2">For urgent issues outside these hours, please use our ticket system.</p>
        </div>
    </div>

    <footer class="bg-black text-white border-t border-gray-800">
        <div class="container px-4 mx-auto py-10">
            <div class="flex flex-wrap">
                <div class="w-full md:w-1/3 mb-8 md:mb-0">
                    <h5 class="text-xs uppercase mb-4">Follow Us</h5>
                    <a href="https://instagram.com/itsimators" class="text-link">Instagram</a>
                </div>
                
                <div class="w-full md:w-1/3 mb-8 md:mb-0">
                    <h5 class="text-xs uppercase mb-4">Discover</h5>
                    <ul class="space-y-2">
                        <li><a href="/privacy" class="text-link">Privacy Policy</a></li>
                        <li><a href="/terms-of-use" class="text-link">Terms of Use</a></li>
                        <li><a href="/" class="text-link">Home</a></li>
                        <li><a href="/about-us" class="text-link">About Us</a></li>
                        <li><a href="/contact-us" class="text-link">Contact Us</a></li>
                    </ul>
                </div>
                
                <div class="w-full md:w-1/3">
                    <h5 class="text-xs uppercase mb-4">Possible reality</h5>
                    <p class="text-sm">All images, videos, and content on this site are the property of Imators.</p>
                </div>
            </div>
            
            <div class="separator"></div>
            
            <div>
                <p class="text-sm mb-2">&copy; 2025 Imators. All rights reserved.</p>
                <p class="text-xs">Imators is a registered LLC (Limited Liability Company).</p>
            </div>
        </div>
    </footer>

    <script>
        document.getElementById('mobile-menu-button')?.addEventListener('click', function() {
            document.getElementById('mobile-menu')?.classList.remove('hidden');
        });
        
        document.getElementById('mobile-menu-close')?.addEventListener('click', function() {
            document.getElementById('mobile-menu')?.classList.add('hidden');
        });
    </script>
</body>
</html>