<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

$envFile = __DIR__ . './.env';
if (file_exists($envFile)) {
    $lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (strpos($line, '=') !== false && strpos($line, '#') !== 0) {
            list($key, $value) = explode('=', $line, 2);
            $_ENV[trim($key)] = trim($value, '"');
        }
    }
}

try {
    $apiKey = $_ENV['WEATHER_API_KEY'];
    $city = 'Uccle,Belgium';
    
    $url = "http://api.weatherapi.com/v1/current.json?key=$apiKey&q=$city&aqi=no";
    
    $response = file_get_contents($url);
    $data = json_decode($response, true);
    
    if ($data && isset($data['current']['temp_c'])) {
        $temperature = round($data['current']['temp_c']);
        echo json_encode(['success' => true, 'temperature' => $temperature]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Données météo non trouvées']);
    }
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>