<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

require_once __DIR__ . '/../vendor/autoload.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

$envFile = __DIR__ . '/../.env';
if (file_exists($envFile)) {
    $lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (strpos($line, '=') !== false && strpos($line, '#') !== 0) {
            list($key, $value) = explode('=', $line, 2);
            $value = trim($value, '"');
            $_ENV[$key] = $value;
        }
    }
}

function generateJWT($teamId, $serviceId, $keyId, $privateKey) {
    $header = [
        'alg' => 'ES256',
        'kid' => $keyId,
        'id' => "$teamId.$serviceId"
    ];
    
    $payload = [
        'iss' => $teamId,
        'iat' => time(),
        'exp' => time() + 3600,
        'sub' => $serviceId
    ];
    
    $key = openssl_pkey_get_private($privateKey);
    return JWT::encode($payload, $key, 'ES256', null, $header);
}

try {
    if (!isset($_ENV['APPLE_TEAM_ID']) || !isset($_ENV['APPLE_SERVICE_ID']) || 
        !isset($_ENV['APPLE_KEY_ID']) || !isset($_ENV['APPLE_PRIVATE_KEY'])) {
        throw new Exception('Variables d\'environnement manquantes');
    }
    
    $jwt = generateJWT($_ENV['APPLE_TEAM_ID'], $_ENV['APPLE_SERVICE_ID'], $_ENV['APPLE_KEY_ID'], $_ENV['APPLE_PRIVATE_KEY']);
    
    $latitude = 50.7976;
    $longitude = 4.3447;
    $url = "https://weatherkit.apple.com/api/v1/weather/fr/$latitude/$longitude?dataSets=currentWeather&timezone=Europe/Brussels";
    
    $options = [
        'http' => [
            'method' => 'GET',
            'header' => [
                "Authorization: Bearer $jwt",
                'Content-Type: application/json',
                'User-Agent: VertChasseur/1.0'
            ],
            'timeout' => 10
        ]
    ];
    
    $context = stream_context_create($options);
    $response = file_get_contents($url, false, $context);
    
    if ($response === false) {
        $error = error_get_last();
        throw new Exception('Erreur requête API: ' . $error['message']);
    }
    
    $data = json_decode($response, true);
    
    if ($data && isset($data['currentWeather']['temperature'])) {
        $temperature = round($data['currentWeather']['temperature']);
        echo json_encode(['success' => true, 'temperature' => $temperature]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Structure de données inattendue', 'response' => $data]);
    }
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>