<?php
require_once '../client/guest/db.php';

if (!isset($_GET['id'])) {
    header('Location: ../client/dashboard.php');
    exit;
}

$shareId = $_GET['id'];
$db2 = getDB2Connection();
$stmt = $db2->prepare("SELECT * FROM shares WHERE share_id = ? AND expiry_date > NOW()");
$stmt->execute([$shareId]);
$share = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$share) {
    header('Location: ../client/dashboard.php?error=expired');
    exit;
}

$files = json_decode($share['files'], true);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Download Files - Imators Systems</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    fontFamily: {
                        'poppins': ['Poppins', 'sans-serif'],
                    },
                }
            }
        }
    </script>
</head>
<body class="bg-white dark:bg-black text-black dark:text-white min-h-screen transition-colors duration-200 p-4 md:p-6 lg:p-8">
    <div class="max-w-[1400px] mx-auto">
        <div class="max-w-2xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
            <div class="flex items-center justify-between mb-8">
                <div class="flex items-center space-x-4">
                    <img src="https://cdn.imators.com/logo.png" alt="Logo" class="h-10 w-auto">
                    <div>
                        <h1 class="text-2xl font-bold">Download Files</h1>
                        <p class="text-sm text-gray-600 dark:text-gray-400">
                            Available until <?= date('F j, Y', strtotime($share['expiry_date'])) ?>
                        </p>
                    </div>
                </div>
                <button id="theme-toggle" class="p-2 rounded-lg bg-gray-100 dark:bg-gray-800">
                    <i class="fas fa-sun dark:hidden"></i>
                    <i class="fas fa-moon hidden dark:block"></i>
                </button>
            </div>

            <div class="bg-gray-100 dark:bg-gray-800 rounded-lg p-6">
                <div class="mb-4">
                    <h2 class="text-xl font-medium flex items-center space-x-2">
                        <i class="fas fa-cloud-download-alt text-gray-600 dark:text-gray-400"></i>
                        <span>Shared Files</span>
                    </h2>
                    <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">
                        Click on each file to download
                    </p>
                </div>

                <div class="space-y-2">
                    <?php foreach($files as $file): ?>
                    <a href="download_file.php?file=<?= urlencode(basename($file)) ?>&share=<?= urlencode($shareId) ?>" 
                       class="flex items-center