<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Projects - Izhak</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://api.fontshare.com/v2/css?f[]=cabinet-grotesk@400,500,700,800&display=swap" rel="stylesheet">
    <style>
        :root {
            --bg-light: #ffffff;
            --bg-dark: #121212;
            --text-light: #121212;
            --text-dark: #f5f5f5;
            --border-light: rgba(0, 0, 0, 0.1);
            --border-dark: rgba(255, 255, 255, 0.1);
            --folder-light: #f5f5f5;
            --folder-dark: #2a2a2a;
            --folder-hover-light: #e0e0e0;
            --folder-hover-dark: #3a3a3a;
        }

        @media (prefers-color-scheme: dark) {
            body {
                background-color: var(--bg-dark);
                color: var(--text-dark);
            }
            .header-border {
                border-top: 1px solid var(--text-dark);
                border-bottom: 1px solid var(--text-dark);
                background-color: rgba(18, 18, 18, 0.8);
            }
            .border-custom {
                border-color: var(--border-dark);
            }
            .folder {
                background-color: var(--folder-dark);
                border: 1px solid var(--border-dark);
            }
            .folder:hover {
                background-color: var(--folder-hover-dark);
            }
            .project-details {
                background-color: rgba(18, 18, 18, 0.95);
                border: 1px solid var(--border-dark);
            }
            .close-btn {
                color: var(--text-dark);
                background-color: rgba(255, 255, 255, 0.1);
            }
            .close-btn:hover {
                background-color: rgba(255, 255, 255, 0.2);
            }
        }

        @media (prefers-color-scheme: light) {
            body {
                background-color: var(--bg-light);
                color: var(--text-light);
            }
            .header-border {
                border-top: 1px solid var(--text-light);
                border-bottom: 1px solid var(--text-light);
                background-color: rgba(255, 255, 255, 0.8);
            }
            .border-custom {
                border-color: var(--border-light);
            }
            .folder {
                background-color: var(--folder-light);
                border: 1px solid var(--border-light);
            }
            .folder:hover {
                background-color: var(--folder-hover-light);
            }
            .project-details {
                background-color: rgba(255, 255, 255, 0.95);
                border: 1px solid var(--border-light);
            }
            .close-btn {
                color: var(--text-light);
                background-color: rgba(0, 0, 0, 0.1);
            }
            .close-btn:hover {
                background-color: rgba(0, 0, 0, 0.2);
            }
        }

        body {
            font-family: 'Cabinet Grotesk', sans-serif;
            transition: background-color 0.3s ease, color 0.3s ease;
        }

        .header-border {
            backdrop-filter: blur(10px);
        }

        .main-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 1rem;
        }

        .folder {
            transition: all 0.2s ease;
            cursor: pointer;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        .folder:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 15px rgba(0, 0, 0, 0.1);
        }

        .folder-icon {
            width: 64px;
            height: 64px;
            margin: 0 auto 10px;
        }

        .project-details {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) scale(0.9);
            width: 90%;
            max-width: 800px;
            max-height: 80vh;
            overflow-y: auto;
            z-index: 1000;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
        }

        .project-details.show {
            opacity: 1;
            visibility: visible;
            transform: translate(-50%, -50%) scale(1);
        }

        .overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 999;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }

        .overlay.show {
            opacity: 1;
            visibility: visible;
        }

        .close-btn {
            position: absolute;
            top: 15px;
            right: 15px;
            width: 30px;
            height: 30px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: background-color 0.2s ease;
        }

        .tag {
            display: inline-block;
            padding: 3px 8px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 500;
            margin-right: 6px;
            margin-bottom: 6px;
        }

        .tag-web { background-color: #e34c26; color: white; }
        .tag-app { background-color: #03bafc; color: white; }
        .tag-design { background-color: #fc5a03; color: white; }
        .tag-backend { background-color: #777bb3; color: white; }
    </style>
</head>
<body class="min-h-screen">
    <header class="header-border py-8 mb-16 sticky top-0 z-50">
        <div class="main-container">
            <div class="flex justify-between items-center">
                <h1 class="text-6xl md:text-7xl font-light italic tracking-tight">
                    Izhak
                </h1>
                <a href="index.html" class="text-sm hover:underline hover:font-semibold font-light max-w-xs text-right leading-relaxed">
                    <- MENU
                </a>
            </div>
        </div>
    </header>

    <main class="main-container">
        <section id="intro" class="mb-16">
            <div class="max-w-2xl">
                <span class="inline-block text-sm font-light tracking-wide mb-4">
                    My projects
                </span>
                <h2 class="text-4xl md:text-5xl font-light tracking-tight mb-6">
                    Double-click to explore
                </h2>
                <p class="text-lg font-light leading-relaxed mb-12">
                    Each folder represents a project I've worked on. Double-click on a folder to discover more about the project and see details.
                </p>
            </div>
        </section>

        <section id="projects" class="mb-16">
            <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 gap-6">
                <!-- Folder 1 -->
                <div class="folder rounded-lg p-4 text-center" onclick="toggleProject('project1')">
                    <svg class="folder-icon" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M22 19C22 19.5304 21.7893 20.0391 21.4142 20.4142C21.0391 20.7893 20.5304 21 20 21H4C3.46957 21 2.96086 20.7893 2.58579 20.4142C2.21071 20.0391 2 19.5304 2 19V5C2 4.46957 2.21071 3.96086 2.58579 3.58579C2.96086 3.21071 3.46957 3 4 3H9L11 6H20C20.5304 6 21.0391 6.21071 21.4142 6.58579C21.7893 6.96086 22 7.46957 22 8V19Z" fill="#e34c26"/>
                    </svg>
                    <h3 class="text-lg font-medium">ForChange</h3>
                    <p class="text-sm font-light opacity-75">Web Platform</p>
                </div>

                <!-- Folder 2 -->
                <div class="folder rounded-lg p-4 text-center" onclick="toggleProject('project2')">
                    <svg class="folder-icon" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M22 19C22 19.5304 21.7893 20.0391 21.4142 20.4142C21.0391 20.7893 20.5304 21 20 21H4C3.46957 21 2.96086 20.7893 2.58579 20.4142C2.21071 20.0391 2 19.5304 2 19V5C2 4.46957 2.21071 3.96086 2.58579 3.58579C2.96086 3.21071 3.46957 3 4 3H9L11 6H20C20.5304 6 21.0391 6.21071 21.4142 6.58579C21.7893 6.96086 22 7.46957 22 8V19Z" fill="#03bafc"/>
                    </svg>
                    <h3 class="text-lg font-medium">SmileyDay</h3>
                    <p class="text-sm font-light opacity-75">Mobile App</p>
                </div>

                <!-- Folder 3 -->
                <div class="folder rounded-lg p-4 text-center" onclick="toggleProject('project3')">
                    <svg class="folder-icon" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M22 19C22 19.5304 21.7893 20.0391 21.4142 20.4142C21.0391 20.7893 20.5304 21 20 21H4C3.46957 21 2.96086 20.7893 2.58579 20.4142C2.21071 20.0391 2 19.5304 2 19V5C2 4.46957 2.21071 3.96086 2.58579 3.58579C2.96086 3.21071 3.46957 3 4 3H9L11 6H20C20.5304 6 21.0391 6.21071 21.4142 6.58579C21.7893 6.96086 22 7.46957 22 8V19Z" fill="#777bb3"/>
                    </svg>
                    <h3 class="text-lg font-medium">Imators Dashboard</h3>
                    <p class="text-sm font-light opacity-75">Admin Panel</p>
                </div>

                <!-- Folder 4 -->
                <div class="folder rounded-lg p-4 text-center" onclick="toggleProject('project4')">
                    <svg class="folder-icon" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M22 19C22 19.5304 21.7893 20.0391 21.4142 20.4142C21.0391 20.7893 20.5304 21 20 21H4C3.46957 21 2.96086 20.7893 2.58579 20.4142C2.21071 20.0391 2 19.5304 2 19V5C2 4.46957 2.21071 3.96086 2.58579 3.58579C2.96086 3.21071 3.46957 3 4 3H9L11 6H20C20.5304 6 21.0391 6.21071 21.4142 6.58579C21.7893 6.96086 22 7.46957 22 8V19Z" fill="#fc5a03"/>
                    </svg>
                    <h3 class="text-lg font-medium">Aktascorp</h3>
                    <p class="text-sm font-light opacity-75">Website</p>
                </div>

                <!-- Folder 5 -->
                <div class="folder rounded-lg p-4 text-center" onclick="toggleProject('project5')">
                    <svg class="folder-icon" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M22 19C22 19.5304 21.7893 20.0391 21.4142 20.4142C21.0391 20.7893 20.5304 21 20 21H4C3.46957 21 2.96086 20.7893 2.58579 20.4142C2.21071 20.0391 2 19.5304 2 19V5C2 4.46957 2.21071 3.96086 2.58579 3.58579C2.96086 3.21071 3.46957 3 4 3H9L11 6H20C20.5304 6 21.0391 6.21071 21.4142 6.58579C21.7893 6.96086 22 7.46957 22 8V19Z" fill="#fce803"/>
                    </svg>
                    <h3 class="text-lg font-medium">CodeJoy</h3>
                    <p class="text-sm font-light opacity-75">Learning Platform</p>
                </div>

                <!-- Folder 6 -->
                <div class="folder rounded-lg p-4 text-center" onclick="toggleProject('project6')">
                    <svg class="folder-icon" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M22 19C22 19.5304 21.7893 20.0391 21.4142 20.4142C21.0391 20.7893 20.5304 21 20 21H4C3.46957 21 2.96086 20.7893 2.58579 20.4142C2.21071 20.0391 2 19.5304 2 19V5C2 4.46957 2.21071 3.96086 2.58579 3.58579C2.96086 3.21071 3.46957 3 4 3H9L11 6H20C20.5304 6 21.0391 6.21071 21.4142 6.58579C21.7893 6.96086 22 7.46957 22 8V19Z" fill="#03bafa"/>
                    </svg>
                    <h3 class="text-lg font-medium">DevPortal</h3>
                    <p class="text-sm font-light opacity-75">Documentation</p>
                </div>

                <!-- Folder 7 -->
                <div class="folder rounded-lg p-4 text-center" onclick="toggleProject('project7')">
                    <svg class="folder-icon" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M22 19C22 19.5304 21.7893 20.0391 21.4142 20.4142C21.0391 20.7893 20.5304 21 20 21H4C3.46957 21 2.96086 20.7893 2.58579 20.4142C2.21071 20.0391 2 19.5304 2 19V5C2 4.46957 2.21071 3.96086 2.58579 3.58579C2.96086 3.21071 3.46957 3 4 3H9L11 6H20C20.5304 6 21.0391 6.21071 21.4142 6.58579C21.7893 6.96086 22 7.46957 22 8V19Z" fill="#e34c26"/>
                    </svg>
                    <h3 class="text-lg font-medium">TeamCollab</h3>
                    <p class="text-sm font-light opacity-75">Collaboration Tool</p>
                </div>

                <!-- Folder 8 -->
                <div class="folder rounded-lg p-4 text-center" onclick="toggleProject('project8')">
                    <svg class="folder-icon" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M22 19C22 19.5304 21.7893 20.0391 21.4142 20.4142C21.0391 20.7893 20.5304 21 20 21H4C3.46957 21 2.96086 20.7893 2.58579 20.4142C2.21071 20.0391 2 19.5304 2 19V5C2 4.46957 2.21071 3.96086 2.58579 3.58579C2.96086 3.21071 3.46957 3 4 3H9L11 6H20C20.5304 6 21.0391 6.21071 21.4142 6.58579C21.7893 6.96086 22 7.46957 22 8V19Z" fill="#fc5a03"/>
                    </svg>
                    <h3 class="text-lg font-medium">Shopping App</h3>
                    <p class="text-sm font-light opacity-75">E-commerce</p>
                </div>

                <!-- Add a folder for a new project -->
                <div class="folder rounded-lg p-4 text-center" onclick="toggleProject('new-project')">
                    <svg class="folder-icon" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M22 19C22 19.5304 21.7893 20.0391 21.4142 20.4142C21.0391 20.7893 20.5304 21 20 21H4C3.46957 21 2.96086 20.7893 2.58579 20.4142C2.21071 20.0391 2 19.5304 2 19V5C2 4.46957 2.21071 3.96086 2.58579 3.58579C2.96086 3.21071 3.46957 3 4 3H9L11 6H20C20.5304 6 21.0391 6.21071 21.4142 6.58579C21.7893 6.96086 22 7.46957 22 8V19Z" fill="#777bb3"/>
                    </svg>
                    <h3 class="text-lg font-medium">+ New Project</h3>
                    <p class="text-sm font-light opacity-75">Coming Soon</p>
                </div>
            </div>
        </section>
    </main>

    <!-- Overlay -->
    <div class="overlay" id="overlay" onclick="closeAllProjects()"></div>

    <!-- Project Details -->
    <!-- Project 1 -->
    <div class="project-details rounded-lg p-8" id="project1">
        <div class="close-btn" onclick="closeAllProjects()">✕</div>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8 items-start">
            <div>
                <img src="https://images.unsplash.com/photo-1551288049-bebda4e38f71?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80" 
                     class="w-full rounded-lg shadow-lg" alt="ForChange Platform">
            </div>
            <div>
                <h2 class="text-3xl font-light mb-4">ForChange Platform</h2>
                <div class="flex flex-wrap mb-4">
                    <span class="tag tag-web">Web Development</span>
                    <span class="tag tag-backend">PHP Backend</span>
                    <span class="tag tag-design">UI/UX Design</span>
                </div>
                <p class="text-lg font-light mb-4">
                    A comprehensive platform created to connect communities and enable positive social change. This project combines modern design principles with robust backend functionality.
                </p>
                <p class="text-lg font-light mb-4">
                    The platform includes user authentication, community forums, event management, and real-time notifications to create a seamless experience for users committed to making a difference.
                </p>
                <div class="mt-6">
                    <h3 class="text-xl font-light mb-2">Technologies Used:</h3>
                    <ul class="list-disc list-inside space-y-1 font-light">
                        <li>HTML5 & CSS3 with Tailwind CSS</li>
                        <li>PHP for backend development</li>
                        <li>MySQL database</li>
                        <li>JavaScript for interactive elements</li>
                    </ul>
                </div>
                <div class="mt-6">
                    <a href="https://forchange.me" class="px-8 py-3 rounded-full text-sm font-light tracking-wide hover:opacity-90 transition-opacity inline-block bg-black text-white">
                        Visit Project
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Project 2 -->
    <div class="project-details rounded-lg p-8" id="project2">
        <div class="close-btn" onclick="closeAllProjects()">✕</div>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8 items-start">
            <div>
                <img src="https://images.unsplash.com/photo-1526498460520-4c246339dccb?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80" 
                     class="w-full rounded-lg shadow-lg" alt="SmileyDay App">
            </div>
            <div>
                <h2 class="text-3xl font-light mb-4">SmileyDay App</h2>
                <div class="flex flex-wrap mb-4">
                    <span class="tag tag-app">Mobile App</span>
                    <span class="tag tag-design">UI Design</span>
                </div>
                <p class="text-lg font-light mb-4">
                    A wellness application focused on promoting daily happiness through simple activities and mindfulness exercises.
                </p>
                <p class="text-lg font-light mb-4">
                    The app sends users daily reminders to smile, practice gratitude, and engage in small positive actions. It includes a mood tracker, journal, and community features.
                </p>
                <div class="mt-6">
                    <h3 class="text-xl font-light mb-2">Technologies Used:</h3>
                    <ul class="list-disc list-inside space-y-1 font-light">
                        <li>Swift for iOS development</li>
                        <li>Java for Android development</li>
                        <li>Firebase for backend services</li>
                        <li>Figma for UI/UX design</li>
                    </ul>
                </div>
                <div class="mt-6">
                    <a href="#" class="px-8 py-3 rounded-full text-sm font-light tracking-wide hover:opacity-90 transition-opacity inline-block bg-black text-white">
                        App Store
                    </a>
                    <a href="#" class="px-8 py-3 rounded-full text-sm font-light tracking-wide hover:opacity-90 transition-opacity inline-block ml-4 border border-black">
                        Google Play
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Additional project details would be added here for projects 3-8 -->

    <footer class="py-8 text-center text-sm font-light">
        <p>Designed with a smile.</p>
        <p>This website is protected by the <a href="https://aktascorp.com" class="underline">aktascorp group</a></p>
        <p>All projects shown are the property of Imators. All rights reserved.</p>
    </footer>

    <script>
        function toggleProject(projectId) {
            // Close any open projects first
            closeAllProjects();
            
            // Show the overlay
            document.getElementById('overlay').classList.add('show');
            
            // Show the selected project
            document.getElementById(projectId).classList.add('show');
        }
        
        function closeAllProjects() {
            // Hide the overlay
            document.getElementById('overlay').classList.remove('show');
            
            // Hide all projects
            const projects = document.querySelectorAll('.project-details');
            projects.forEach(project => {
                project.classList.remove('show');
            });
        }
        
        // Double-click handling for folders
        document.querySelectorAll('.folder').forEach(folder => {
            let clickCount = 0;
            let singleClickTimer;
            
            folder.addEventListener('click', function(e) {
                clickCount++;
                
                if (clickCount === 1) {
                    singleClickTimer = setTimeout(function() {
                        clickCount = 0;
                        // Single click action (can be left empty)
                    }, 300);
                } else if (clickCount === 2) {
                    clearTimeout(singleClickTimer);
                    clickCount = 0;
                    // Double click action - get the onclick attribute value
                    const projectId = this.getAttribute('onclick').match(/'([^']+)'/)[1];
                    toggleProject(projectId);
                }
            });
        });
    </script>
</body>
</html>