<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Projects - Izhak</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="icon" href="icon.png" type="image/png">
    <link href="https://api.fontshare.com/v2/css?f[]=cabinet-grotesk@400,500,700,800&display=swap" rel="stylesheet">
    <style>
        :root {
            --bg-light: #ffffff;
            --bg-dark: #121212;
            --text-light: #121212;
            --text-dark: #f5f5f5;
            --border-light: rgba(0, 0, 0, 0.1);
            --border-dark: rgba(255, 255, 255, 0.1);
        }

        @media (prefers-color-scheme: dark) {
            body {
                background-color: var(--bg-dark);
                color: var(--text-dark);
            }
            .header-border {
                border-top: 1px solid var(--text-dark);
                border-bottom: 1px solid var(--text-dark);
                background-color: rgba(18, 18, 18, 0.8);
            }
            .border-custom {
                border-color: var(--border-dark);
            }
            .project-item {
                border-bottom: 1px solid var(--border-dark);
            }
        }

        @media (prefers-color-scheme: light) {
            body {
                background-color: var(--bg-light);
                color: var(--text-light);
            }
            .header-border {
                border-top: 1px solid var(--text-light);
                border-bottom: 1px solid var(--text-light);
                background-color: rgba(255, 255, 255, 0.8);
            }
            .border-custom {
                border-color: var(--border-light);
            }
            .project-item {
                border-bottom: 1px solid var(--border-light);
            }
        }

        body {
            font-family: 'Cabinet Grotesk', sans-serif;
            transition: background-color 0.3s ease, color 0.3s ease;
        }

        .header-border {
            backdrop-filter: blur(10px);
        }

        .main-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 1rem;
        }

        .language {
            font-size: 12px;
            opacity: 0.7;
            font-weight: 400;
            letter-spacing: 0.05em;
        }
    </style>
</head>
<body class="min-h-screen">
    <header class="header-border py-8 mb-16 sticky top-0 z-50">
        <div class="main-container">
            <div class="flex justify-between items-center">
                <h1 class="text-6xl md:text-7xl font-light italic tracking-tight">
                    Izhak
                </h1>
                <a href="index.html" class="text-sm hover:underline hover:font-semibold font-light max-w-xs text-right leading-relaxed">
                    <- MENU
                </a>
            </div>
        </div>
    </header>

    <main class="main-container">
        <section id="intro" class="mb-16">
            <div class="max-w-2xl">
                <span class="inline-block text-sm font-light tracking-wide mb-4">
                    My work
                </span>
                <h2 class="text-4xl md:text-5xl font-light tracking-tight mb-6">
                    Projects
                </h2>
                <p class="text-lg font-light leading-relaxed mb-12">
                    A collection of websites, applications, and tools I've developed. Each project represents a unique challenge and solution.
                </p>
            </div>
        </section>

        <section id="projects" class="mb-16">
            <h2 class="text-4xl font-light mb-12 border-b border-custom pb-4">PROJECT LIST</h2>
            
            <div class="project-list">
                <!-- Project 1 -->
                <div class="project-item py-8">
                    <div class="flex flex-col md:flex-row justify-between md:items-center">
                        <h3 class="text-2xl font-light mb-2 md:mb-0">Imators</h3>
                        <div class="language">HTML / CSS / PHP / JS / SQL / </div>
                    </div>
                    <p class="text-lg font-light leading-relaxed mt-4">
                            I created my company's website and developed its protection system
                    </p>
                    <a href="https://imators.com" class="text-sm hover:underline mt-4 inline-block">Visit Website</a>
                </div>
                
                <!-- Project 2 -->
                <div class="project-item py-8">
                    <div class="flex flex-col md:flex-row justify-between md:items-center">
                        <h3 class="text-2xl font-light mb-2 md:mb-0">TrafficLight</h3>
                        <div class="language">HTML / PHP / JS</div>
                    </div>
                    <p class="text-lg font-light leading-relaxed mt-4">
                    I created a web application all on my own to compete with Waze! I was able to create the whole system in the space of a month
                    </p>
                    <div class="mt-4">
                        <a href="httsps://imators.com/traffic" class="text-sm hover:underline inline-block">Download</a>
                    </div>
                </div>
                
                <!-- Project 3 -->
                <div class="project-item py-8">
                    <div class="flex flex-col md:flex-row justify-between md:items-center">
                        <h3 class="text-2xl font-light mb-2 md:mb-0">Vert Chasseur</h3>
                        <div class="language">HTML / CSS / PHP / MySQL</div>
                    </div>
                    <p class="text-lg font-light leading-relaxed mt-4">
                    A site I created for an upmarket district of Brussels! I really enjoyed putting time into it
                    </p>
                    <a href="https://vertchasseur.com" class="text-sm hover:underline mt-4 inline-block">Go to the website</a>
                </div>
                
                <!-- Project 4 -->
                <div class="project-item py-8">
                    <div class="flex flex-col md:flex-row justify-between md:items-center">
                        <h3 class="text-2xl font-light mb-2 md:mb-0">Peerkinton</h3>
                        <div class="language">Made with Wordpress</div>
                    </div>
                    <p class="text-lg font-light leading-relaxed mt-4">
                        A website dedicated to a private neighbourhood protection agency!
                    </p>
                    <a href="https://peerkinton.com" class="text-sm hover:underline mt-4 inline-block">Visit Website →</a>
                </div>
            </div>
        </section>

        <section id="contact" class="mb-16">
            <div class="max-w-2xl mx-auto text-center">
                <h2 class="text-4xl font-light mb-6">Have a project in mind?</h2>
                <p class="text-lg font-light leading-relaxed mb-8">
                    I'm always looking for interesting challenges and new opportunities. Let's create something amazing together!
                </p>
                <a href="mailto:msg@izhak.me" class="px-8 py-3 rounded-full text-sm font-light tracking-wide hover:opacity-90 transition-opacity inline-block border border-current">
                    Get in touch
                </a>
            </div>
        </section>
    </main>

    <footer class="py-8 text-center text-sm font-light">
        <p>Designed with a smile.</p>
        <p>This website is protected by the <a href="https://aktascorp.com" class="underline">aktascorp group</a></p>
    </footer>
</body>
</html>