<?php
require_once '../client/guest/db.php';

if (!isset($_GET['file']) || !isset($_GET['share'])) {
    header('Location: ../client/dashboard.php');
    exit;
}

$filename = basename($_GET['file']);
$shareId = $_GET['share'];

$db2 = getDB2Connection();
$stmt = $db2->prepare("SELECT * FROM shares WHERE share_id = ? AND expiry_date > NOW()");
$stmt->execute([$shareId]);
$share = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$share) {
    header('Location: ../client/dashboard.php?error=expired');
    exit;
}

$files = json_decode($share['files'], true);
$filePath = null;

foreach ($files as $file) {
    if (basename($file) === $filename) {
        $filePath = $file;
        break;
    }
}

if (!$filePath || !file_exists($filePath)) {
    header('Location: ../client/dashboard.php?error=notfound');
    exit;
}

$finfo = finfo_open(FILEINFO_MIME_TYPE);
$mimeType = finfo_file($finfo, $filePath);
finfo_close($finfo);

header('Content-Type: ' . $mimeType);
header('Content-Disposition: attachment; filename="' . $filename . '"');
header('Content-Length: ' . filesize($filePath));
header('Cache-Control: no-cache, must-revalidate');
header('Pragma: public');

readfile($filePath);
exit;
?>