<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Peerkinton</title>
    <link rel="icon" type="image/png" href="logo.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
        }
    </style>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'sans': ['Poppins', 'sans-serif'],
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-white text-gray-900">
    <header class="w-full px-4 sm:px-6 py-4">
        <div class="max-w-5xl mx-auto flex justify-between items-center">
            <img src="logo.png" alt="Peerkinton Logo" class="h-6 sm:h-8">
            <a href="/login" class="bg-black text-white px-6 py-2 font-medium rounded-full text-sm uppercase tracking-wider rounded hover:bg-gray-800 transition-colors">
                Compte citoyen
            </a>
        </div>
    </header>

    <div class="max-w-5xl mx-auto px-4 sm:px-6 py-8 sm:py-12">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8 md:gap-16 items-center mb-16">
            <div class="order-2 md:order-1">
                <h1 class="text-3xl sm:text-4xl font-medium mb-3 sm:mb-4">#LovePeerkinton</h1>
                <p class="text-gray-600 mb-6 sm:mb-10 font-light">Une ville roleplay remplis de surprise et d'aventure élégante dans un pays extrêmement grands.</p>
                 <a href="http://88.151.197.15:8222/#world:-186:0:-912:3138:-1.56:0:0:0:perspective" class="text-gray-600 mb-6 sm:mb-10 font-bold">Accéder a la carte en ligne</a>
                 <p></p>
                 <a href="https://wiki.peerkinton.com" class="mt-2 text-gray-600 mb-6 sm:mb-10 font-bold">Accéder au wiki</a>               
            </div>
            
            <div class="order-1 md:order-2 mb-6 md:mb-0">
                <img src="IMG_8871.png" alt="Peerkinton City View" class="w-full h-auto rounded">
            </div>
        </div>

        <section class="py-16 border-t border-gray-100">
            <div class="text-center mb-12">
                <h2 class="text-3xl sm:text-4xl font-medium mb-4">Le Royaume de Peerkinton</h2>
                <p class="text-gray-600 text-lg max-w-2xl mx-auto">Découvrez l'histoire fascinante et les mystères de notre royaume légendaire</p>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-start">
                <div>
                    <h3 class="text-2xl font-medium mb-6">Notre Histoire</h3>
                    <div class="space-y-4 text-gray-600">
                        <p>Fondé il y a plus de trois siècles par le Roi Merian, le Royaume de Peerkinton est né de la vision d'un monarque éclairé qui souhaitait créer une société où l'aventure et l'élégance se mélangent harmonieusement.</p>
                        
                        <p>Au fil des décennies, Peerkinton a développé et donné naissance à sa première ville qui est maintenant sa capitale, appelée Folium. Les villes ouvrières et citoyennes se sont développées par la suite.</p>
                        
                        <p>Les rues de Folium, grandes et qui font découvrir une capitale harmonieuse et vaste, résonnent des histoires de chevaliers, de marchands, d'artisans et d'explorateurs qui façonnent quotidiennement l'identité unique de notre terre.</p>
                    </div>
                </div>

                <div>
                    <h3 class="text-2xl font-medium mb-6">Culture & Traditions</h3>
                    <div class="space-y-4 text-gray-600">
                        <p>Le Royaume de Peerkinton est réputé pour sa culture raffinée où l'art atteint des sommets d'excellence. Nos habitants cultivent l'art de la narration, transformant chaque interaction en une aventure mémorable.</p>
                        
                        <p>Les traditions ancestrales se mélangent aux innovations modernes, créant un environnement unique où le passé et le présent coexistent en parfaite harmonie. Les festivals saisonniers, les tournois et les marchés artisanaux rythment la vie quotidienne.</p>
                        
                        <p>L'hospitalité peerkintonaise est légendaire. Que tu sois noble ou roturier, aventurier ou commerçant, le royaume t'accueille avec la promesse d'expériences inoubliables et de rencontres qui marqueront ton destin.</p>
                    </div>
                </div>
            </div>

            <div class="mt-12 bg-gray-50 rounded-lg p-8">
                <h3 class="text-2xl font-medium mb-4 text-center">Prêt pour l'Aventure ?</h3>
                <p class="text-gray-600 text-center max-w-3xl mx-auto">
                    Le 7 juillet marquera le début d'une nouvelle ère pour le Royaume de Peerkinton. Le gouvernement a promis agrandissement, et modernisation du pays.
                </p>
            </div>
        </section>
    </div>
</body>
</html>