<?php
$lang = isset($_GET['lang']) ? $_GET['lang'] : 'en';

$content = [
    'en' => [
        'title' => 'Your invitation to appear in an Imators advertisement.',
        'promo_title' => 'Your invitation to appear in an Imators advertisement.',
        'form_title' => 'Apply Now',
        'age_label' => 'Age Range',
        'age_13_16' => '13-16 years',
        'age_16_18' => '16-18 years',
        'parent_email' => 'Parent/Guardian Email',
        'email_note' => 'Documents will be sent to this address',
        'rep_name' => 'Imators Representative',
        'rep_placeholder' => 'Name of the representative you met',
        'notice_label' => 'Additional Information',
        'notice_placeholder' => 'Share any additional details',
        'submit' => 'Submit',
        'form_success' => 'Application submitted successfully',
        'form_error' => 'Please check your information',
        'download_docs' => 'Download Documents',
        'photo_title' => 'Photography',
        'photo_desc' => 'Our sessions are held in open and not closed or risky places. All photos taken during the session are shown to your children, and sent to you before selection.',
        'security_title' => 'Security',
        'security_desc' => 'We hold ourselves responsible in case of accidents on site, even though these are extremely rare.',
        'confidentiality_title' => 'Confidentiality',
        'confidentiality_desc' => 'By virtue of the European and international laws imposed on us as well as out of respect for our ethics, your child\'s photos will in no case be used for illegal purposes or to harm them.',
        'email_subject' => 'New Application to Imators Casting',
        'email_title' => 'We received your application to the Imators casting with the following details:',
        'email_age' => 'Age Range',
        'email_rep' => 'Imators Representative',
        'email_note' => 'Additional Information',
        'email_time' => 'Time',
        'email_secure' => 'Please print and sign the attached documents.',
        'email_button' => 'Download Required Documents',
        'email_support' => 'If you believe there has been a mistake, please contact our support team immediately.'
    ],
    'fr' => [
        'title' => 'Votre invitation à apparaître dans une publicité Imators.',
        'promo_title' => 'Votre invitation à apparaître dans une publicité Imators.',
        'form_title' => 'Postuler',
        'age_label' => 'Âge',
        'age_13_16' => '13-16 ans',
        'age_16_18' => '16-18 ans',
        'parent_email' => 'Email du parent/tuteur',
        'email_note' => 'Les documents seront envoyés à cette adresse',
        'rep_name' => 'Représentant Imators',
        'rep_placeholder' => 'Nom du représentant rencontré',
        'notice_label' => 'Informations Supplémentaires',
        'notice_placeholder' => 'Partage des détails additionnels',
        'submit' => 'Envoyer',
        'form_success' => 'Candidature envoyée avec succès',
        'form_error' => 'Vérifie tes informations',
        'download_docs' => 'Télécharger les Documents',
        'photo_title' => 'Photographie',
        'photo_desc' => 'Nos sessions sont tenues dans des lieux ouvert et non fermés ou à risque. Toute photos prises pendant la sessions sont montrée à vos enfants, et vont sont envoyer avant la sélection.',
        'security_title' => 'Sécurité',
        'security_desc' => 'Nous nous tenons responsable en cas d\'accident sur place, même si ces derniers sont extrêmement rare.',
        'confidentiality_title' => 'Confidentialité',
        'confidentiality_desc' => 'En vertu des lois Européennes et internationales qui nous sont imposés ainsi que par respect de notre éthique, les photos de votre enfant ne seront en aucun cas utilisé pour un buts illégal ou pour leur nuire.',
        'email_subject' => 'Nouvelle Candidature au Casting Imators',
        'email_title' => 'Nous avons reçu votre candidature au casting Imators avec les détails suivants :',
        'email_age' => 'Tranche d\'âge',
        'email_rep' => 'Représentant Imators',
        'email_note' => 'Informations Supplémentaires',
        'email_time' => 'Heure',
        'email_secure' => 'Veuillez imprimer et signer les documents joints.',
        'email_button' => 'Télécharger les Documents Requis',
        'email_support' => 'Si vous pensez qu\'il y a eu une erreur, veuillez contacter notre équipe de support immédiatement.'
    ]
];

$formSubmitted = false;
$formSuccess = false;
$formError = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $formSubmitted = true;
    
    $ageRange = isset($_POST['age_range']) ? $_POST['age_range'] : '';
    $parentEmail = isset($_POST['parent_email']) ? $_POST['parent_email'] : '';
    $repName = isset($_POST['rep_name']) ? $_POST['rep_name'] : '';
    $notice = isset($_POST['notice']) ? $_POST['notice'] : '';
    
    if ($parentEmail) {
        $to = $parentEmail;
        $subject = $content[$lang]['email_subject'];
        
        $headers = [
            'From' => 'no-reply@imators.systems',
            'Reply-To' => 'contact@imators.systems',
            'MIME-Version' => '1.0',
            'Content-Type' => 'text/html; charset=UTF-8'
        ];
        
        $emailBody = '
        <div style="font-family: \'Poppins\', sans-serif; max-width: 600px; margin: 0 auto;">
            <div style="background: #1a1a1a; padding: 30px; border-radius: 10px; color: white;">                        
                <h1 style="margin-bottom: 20px;">' . $content[$lang]['email_title'] . '</h1>
                <ul style="margin-bottom: 20px; list-style: none; padding: 0;">
                    <li style="margin-bottom: 5px;">' . $content[$lang]['email_age'] . ': ' . $ageRange . '</li>
                    <li style="margin-bottom: 5px;">' . $content[$lang]['email_rep'] . ': ' . $repName . '</li>
                    ' . ($notice ? '<li style="margin-bottom: 5px;">' . $content[$lang]['email_note'] . ': ' . $notice . '</li>' : '') . '
                    <li style="margin-bottom: 5px;">' . $content[$lang]['email_time'] . ': ' . date('F j, Y g:i A') . '</li>
                </ul>
                <p style="margin-bottom: 30px;">' . $content[$lang]['email_secure'] . '</p>
                <a href="https://imators.systems/docs/casting-documents.pdf" style="display: inline-block; background-color: #00ff00; color: black; padding: 10px 20px; text-decoration: none; border-radius: 5px;">
                    ' . $content[$lang]['email_button'] . '
                </a>
                <p style="margin-top: 20px; font-size: 12px; color: #888;">
                    ' . $content[$lang]['email_support'] . '
                </p>
            </div>
        </div>';
        
        $emailSent = mail($to, $subject, $emailBody, $headers);
        
        if ($emailSent) {
            $formSuccess = true;
            
            $adminNotificationSubject = ($lang === 'en') ? 'New Casting Application' : 'Nouvelle candidature au casting';
            $adminNotificationFrom = 'From: no-reply@imators.systems';
            
            $adminNotification = "";
            if ($lang === 'en') {
                $adminNotification .= "New casting application\n\n";
                $adminNotification .= "Age Range: " . $ageRange . "\n";
                $adminNotification .= "Parent/Guardian Email: " . $parentEmail . "\n";
                $adminNotification .= "Imators Representative: " . $repName . "\n";
                $adminNotification .= "Additional Information: " . $notice . "\n";
            } else {
                $adminNotification .= "Nouvelle candidature au casting\n\n";
                $adminNotification .= "Tranche d'âge: " . $ageRange . "\n";
                $adminNotification .= "Email du parent/tuteur: " . $parentEmail . "\n";
                $adminNotification .= "Représentant Imators: " . $repName . "\n";
                $adminNotification .= "Informations supplémentaires: " . $notice . "\n";
            }
            
            mail('casting@imators.systems', $adminNotificationSubject, $adminNotification, $adminNotificationFrom);
        } else {
            $formError = true;
        }
    } else {
        $formError = true;
    }
}
?>
<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $content[$lang]['title']; ?></title>
    
    <meta property="og:title" content="<?php echo $content[$lang]['title']; ?>">
    <meta property="og:description" content="Imators Casting">
    <meta property="og:image" content="https://imators.systems/images/og-casting.jpg">
    <meta property="og:url" content="https://imators.systems/casting">
    <meta property="og:type" content="website">
    
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #000;
            color: #fff;
        }
        
        .gradient-bg {
            background: linear-gradient(135deg, #111 0%, #000 100%);
        }
        
        .form-input {
            background-color: rgba(30, 30, 30, 0.6);
            border: 1px solid #333;
            color: white;
            transition: all 0.3s;
        }
        
        .form-input:focus {
            outline: none;
            border-color: #00ff00;
            box-shadow: 0 0 0 1px rgba(0, 255, 0, 0.1);
        }
        
        .info-box {
            background-color: rgba(20, 20, 20, 0.7);
            border-radius: 8px;
            backdrop-filter: blur(10px);
            transition: transform 0.3s, box-shadow 0.3s;
        }
        
        .info-box:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.3);
        }
        
        .submit-btn {
            background-color: #00ff00;
            color: black;
            transition: all 0.3s;
        }
        
        .submit-btn:hover {
            background-color: #00cc00;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 255, 0, 0.2);
        }
        
        .download-btn {
            border: 1px solid #00ff00;
            color: #00ff00;
            transition: all 0.3s;
        }
        
        .download-btn:hover {
            background-color: #00ff00;
            color: black;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 255, 0, 0.2);
        }
        
        .lang-btn {
            opacity: 0.7;
            transition: all 0.3s;
        }
        
        .lang-btn:hover, .lang-btn.active {
            opacity: 1;
        }
        
        .radio-btn {
            transition: all 0.3s;
        }
        
        .radio-btn:hover {
            border-color: #00ff00;
        }
        
        .radio-btn.selected {
            border-color: #00ff00;
            background-color: rgba(0, 255, 0, 0.05);
        }
    </style>
</head>
<body class="min-h-screen bg-black text-white" x-data="formManager()">
    <!-- Header placeholder - Uses a safe include method -->
    <?php if (file_exists('src/header.php')) { include 'src/header.php'; } ?>
    
    <div class="gradient-bg min-h-screen pt-16 pb-12 px-4 sm:px-6 lg:px-8">
        <div class="max-w-6xl mx-auto">
            <!-- Logo and Title -->
            <div class="text-center mb-16">
                <img src="https://cdn.imators.com/logo.png" alt="Imators" class="h-16 mx-auto mb-6">
                <h1 class="text-4xl font-light mb-4 text-white"><?php echo $content[$lang]['promo_title']; ?></h1>
            </div>
            
            <!-- Main content -->
            <div class="lg:flex lg:gap-12 items-start">
                <!-- Left column: Form -->
                <div class="lg:w-1/2 mb-12 lg:mb-0 order-2 lg:order-1">
                    <div class="bg-black bg-opacity-60 backdrop-blur border border-gray-800 rounded-xl p-8 shadow-xl">
                        <h2 class="text-2xl font-light mb-8 text-center text-green-400"><?php echo $content[$lang]['form_title']; ?></h2>
                        
                        <?php if($formSubmitted && $formSuccess): ?>
                            <div class="bg-green-900 bg-opacity-20 border border-green-500 text-green-400 p-4 rounded-lg text-center mb-6">
                                <?php echo $content[$lang]['form_success']; ?>
                            </div>
                        <?php elseif($formSubmitted && $formError): ?>
                            <div class="bg-red-900 bg-opacity-20 border border-red-500 text-red-400 p-4 rounded-lg text-center mb-6">
                                <?php echo $content[$lang]['form_error']; ?>
                            </div>
                        <?php endif; ?>
                        
                        <form method="POST" class="space-y-6" x-on:submit.prevent="submitForm">
                            <div>
                                <label class="block text-sm font-medium mb-2"><?php echo $content[$lang]['age_label']; ?></label>
                                <div class="grid grid-cols-2 gap-4">
                                    <label class="radio-btn flex items-center bg-opacity-60 border border-gray-700 p-3 rounded-lg cursor-pointer" :class="{'selected': age_range === '13-16'}">
                                        <input type="radio" name="age_range" value="13-16" class="sr-only" required x-model="age_range">
                                        <span class="w-4 h-4 border border-gray-500 rounded-full mr-3 flex items-center justify-center" :class="{'border-green-400': age_range === '13-16'}">
                                            <span class="w-2 h-2 bg-green-400 rounded-full" x-show="age_range === '13-16'"></span>
                                        </span>
                                        <span><?php echo $content[$lang]['age_13_16']; ?></span>
                                    </label>
                                    <label class="radio-btn flex items-center bg-opacity-60 border border-gray-700 p-3 rounded-lg cursor-pointer" :class="{'selected': age_range === '16-18'}">
                                        <input type="radio" name="age_range" value="16-18" class="sr-only" required x-model="age_range">
                                        <span class="w-4 h-4 border border-gray-500 rounded-full mr-3 flex items-center justify-center" :class="{'border-green-400': age_range === '16-18'}">
                                            <span class="w-2 h-2 bg-green-400 rounded-full" x-show="age_range === '16-18'"></span>
                                        </span>
                                        <span><?php echo $content[$lang]['age_16_18']; ?></span>
                                    </label>
                                </div>
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium mb-2" for="parent_email"><?php echo $content[$lang]['parent_email']; ?></label>
                                <input 
                                    type="email" 
                                    id="parent_email" 
                                    name="parent_email" 
                                    x-model="email"
                                    class="form-input w-full px-4 py-3 rounded-lg"
                                    required
                                >
                                <p class="text-xs text-gray-400 mt-1"><?php echo $content[$lang]['email_note']; ?></p>
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium mb-2" for="rep_name"><?php echo $content[$lang]['rep_name']; ?></label>
                                <input 
                                    type="text" 
                                    id="rep_name" 
                                    name="rep_name" 
                                    placeholder="<?php echo $content[$lang]['rep_placeholder']; ?>" 
                                    x-model="rep_name"
                                    class="form-input w-full px-4 py-3 rounded-lg"
                                    required
                                >
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium mb-2" for="notice"><?php echo $content[$lang]['notice_label']; ?></label>
                                <textarea 
                                    id="notice" 
                                    name="notice" 
                                    rows="4" 
                                    placeholder="<?php echo $content[$lang]['notice_placeholder']; ?>" 
                                    x-model="notice"
                                    class="form-input w-full px-4 py-3 rounded-lg"
                                ></textarea>
                            </div>
                            
                            <div class="pt-4">
                                <button 
                                    type="submit" 
                                    class="submit-btn w-full py-3 rounded-lg font-medium text-sm"
                                >
                                    <?php echo $content[$lang]['submit']; ?>
                                </button>
                            </div>
                        </form>
                    </div>
                    
                    <!-- Download button for mobile -->
                    <div class="lg:hidden text-center mt-8">
                        <a href="/docs/casting-documents.pdf" class="download-btn inline-block px-6 py-3 rounded-lg text-sm">
                            <i class="fa fa-download mr-2"></i> <?php echo $content[$lang]['download_docs']; ?>
                        </a>
                    </div>
                </div>
                
                <!-- Right column: Info -->
                <div class="lg:w-1/2 order-1 lg:order-2">
                    <div class="space-y-6">
                        <!-- Photography -->
                        <div class="info-box p-6">
                            <div class="flex items-start mb-3">
                                <div class="bg-green-400 bg-opacity-20 p-3 rounded-full mr-4">
                                    <i class="fa fa-camera text-green-400 text-xl"></i>
                                </div>
                                <div>
                                    <h2 class="text-xl font-light mb-2 text-green-400"><?php echo $content[$lang]['photo_title']; ?></h2>
                                    <p class="text-gray-300 text-sm"><?php echo $content[$lang]['photo_desc']; ?></p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Security -->
                        <div class="info-box p-6">
                            <div class="flex items-start mb-3">
                                <div class="bg-green-400 bg-opacity-20 p-3 rounded-full mr-4">
                                    <i class="fa fa-shield-alt text-green-400 text-xl"></i>
                                </div>
                                <div>
                                    <h2 class="text-xl font-light mb-2 text-green-400"><?php echo $content[$lang]['security_title']; ?></h2>
                                    <p class="text-gray-300 text-sm"><?php echo $content[$lang]['security_desc']; ?></p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Confidentiality -->
                        <div class="info-box p-6">
                            <div class="flex items-start mb-3">
                                <div class="bg-green-400 bg-opacity-20 p-3 rounded-full mr-4">
                                    <i class="fa fa-lock text-green-400 text-xl"></i>
                                </div>
                                <div>
                                    <h2 class="text-xl font-light mb-2 text-green-400"><?php echo $content[$lang]['confidentiality_title']; ?></h2>
                                    <p class="text-gray-300 text-sm"><?php echo $content[$lang]['confidentiality_desc']; ?></p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Download button for desktop -->
                        <div class="hidden lg:block text-center mt-10">
                            <a href="/docs/casting-documents.pdf" class="download-btn inline-block px-8 py-4 rounded-lg text-sm shadow-lg">
                                <i class="fa fa-download mr-2"></i> <?php echo $content[$lang]['download_docs']; ?>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Language switcher -->
    <div class="fixed bottom-6 right-6 flex space-x-3 z-50">
        <a href="?lang=en" class="lang-btn px-3 py-1 rounded-lg <?php echo $lang === 'en' ? 'bg-green-400 text-black active' : 'bg-black bg-opacity-70 text-white border border-gray-700'; ?>">
            EN
        </a>
        <a href="?lang=fr" class="lang-btn px-3 py-1 rounded-lg <?php echo $lang === 'fr' ? 'bg-green-400 text-black active' : 'bg-black bg-opacity-70 text-white border border-gray-700'; ?>">
            FR
        </a>
    </div>
    
    <script>
    function formManager() {
        return {
            email: '',
            age_range: '',
            rep_name: '',
            notice: '',
            submitForm() {
                if (!this.email || !this.age_range || !this.rep_name) {
                    return;
                }
                
                document.querySelector('form').submit();
            }
        };
    }
    </script>
</body>
</html>