
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="logo_new.png">
    <title>Vert Chasseur</title>    
    <meta name="description" content="Vert Chasseur est un quartier à Uccle où vous trouverez de la joie et un havre de paix accueillant. Découvrez les commerces partenaire du quartier et les événements qui pourrait vous intéresser.">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Princess+Sofia&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Urbanist:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
        <script defer src="https://cloud.umami.is/script.js" data-website-id="6ec552ef-4a61-4f71-a55f-4464703af623"></script>
    <style>
        body {
            font-family: "Urbanist", sans-serif;
            letter-spacing: -0.01em;
        }
        .card-hover {
            transition: transform 0.3s ease;
        }
        .card-hover:hover {
            transform: translateY(-4px);
        }
        .arrow-hover {
            transition: transform 0.3s ease;
        }
        .card-hover:hover .arrow-hover {
            transform: translateX(8px);
        }
        
        .txt-chasseur {
            font-family: "Princess Sofia", serif;
            font-weight: 400;
            font-style: normal;
        }
    </style>
</head>
<header id="header" class="fixed w-full top-0 z-50 transition-all duration-300 bg-transparent dark:text-white">
    <div class="container mx-auto px-4 py-3">
        <div class="flex justify-between items-center">
            <div class="flex items-center space-x-4">
                <a href="/" class="flex items-center">
                    <img src="icon.png" alt="Vert Chasseur" class="h-12 block">
                </a>
                <div id="weatherDesktop" class="hidden md:block text-sm font-medium">
                    <span id="tempDesktop">--°</span>
                </div>
            </div>
            <div class="flex items-center space-x-6">
                <nav class="hidden md:flex space-x-6">
                    <a href="/media" class="hover:text-gray-600 dark:hover:text-gray-300 text-sm font-medium">Actualité</a>
                    <a href="/shop" class="hover:text-gray-600 dark:hover:text-gray-300 text-sm font-medium">Commerce</a>
                    <a href="https://imators.com/support" class="hover:text-gray-600 dark:hover:text-gray-300 text-sm font-medium">Contact</a>
                </nav>
                <div class="flex items-center space-x-4">
                    <div id="weatherMobile" class="md:hidden text-sm font-medium">
                        <span id="tempMobile">--°</span>
                    </div>
                    <button id="menuBtn" class="md:hidden w-6 h-6">
                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4 6h16M4 12h16M4 18h16"/></svg>
                    </button>
                </div>
            </div>
        </div>
    </div>
    <div id="mobileMenu" class="fixed inset-0 bg-white dark:bg-black transform translate-x-full transition-transform duration-300 md:hidden">
        <div class="flex justify-end p-4">
            <button id="closeBtn" class="w-6 h-6 text-black dark:text-white">
                <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M6 18L18 6M6 6l12 12"/></svg>
            </button>
        </div>
        <div class="flex justify-center my-4">
            <img src="icon.png" alt="Waterloo" class="h-12 block">
        </div>
        <nav class="mt-8 p-4">
            <ul class="space-y-6 text-center">
                <li><a href="/media" class="block text-lg text-black dark:text-white">Actualité</a></li>
                <li><a href="/shop" class="block text-lg text-black dark:text-white">Commerce</a></li>
                <li><a href="https://imators.com/support" class="block text-lg text-black dark:text-white">Contact</a></li>
            </ul>
        </nav>
    </div>
</header>

<script>
    const header = document.getElementById('header');
    const menuBtn = document.getElementById('menuBtn');
    const closeBtn = document.getElementById('closeBtn');
    const mobileMenu = document.getElementById('mobileMenu');

    window.addEventListener('scroll', () => {
        if (window.scrollY > 50) {
            header.classList.add('bg-white', 'dark:bg-black', 'shadow-sm', 'dark:shadow-gray-800');
        } else {
            header.classList.remove('bg-white', 'dark:bg-black', 'shadow-sm', 'dark:shadow-gray-800');
        }
    });

    menuBtn.addEventListener('click', () => mobileMenu.classList.remove('translate-x-full'));
    closeBtn.addEventListener('click', () => mobileMenu.classList.add('translate-x-full'));

    async function fetchWeather() {
        try {
            const apiKey = 'fa1a36a37c3f4e7ab7e233043252305';
            const city = 'Waterloo,Belgium';
            const url = `https://api.weatherapi.com/v1/current.json?key=${apiKey}&q=${city}&aqi=no`;
            
            const response = await fetch(url);
            
            if (!response.ok) {
                throw new Error('Erreur API Weather');
            }

            const data = await response.json();
            
            if (data && data.current && data.current.temp_c) {
                const temperature = Math.round(data.current.temp_c);
                document.getElementById('tempDesktop').textContent = `${temperature}°C`;
                document.getElementById('tempMobile').textContent = `${temperature}°C`;
            } else {
                throw new Error('Données météo non trouvées');
            }
        } catch (error) {
            console.error('Erreur météo:', error);
            document.getElementById('tempDesktop').textContent = '--°C';
            document.getElementById('tempMobile').textContent = '--°C';
        }
    }

    fetchWeather();
    setInterval(fetchWeather, 5000);
</script>
</body>
</html>