const fs = require('fs');
const path = require('path');

function copyFiles(sourceDir, destDir) {
  if (!fs.existsSync(destDir)) {
    fs.mkdirSync(destDir, { recursive: true });
  }

  const files = fs.readdirSync(sourceDir);

  files.forEach(file => {
    const sourcePath = path.join(sourceDir, file);
    const destPath = path.join(destDir, file);

    if (fs.lstatSync(sourcePath).isDirectory()) {
      copyFiles(sourcePath, destPath);
    } else {
      fs.copyFileSync(sourcePath, destPath);
      console.log(`Fichier copié: ${sourcePath} -> ${destPath}`);
    }
  });
}

function main() {
  const sourceDir = process.argv[2];
  const destDir = process.argv[3];

  if (!sourceDir || !destDir) {
    console.error('Usage: node copy_files.js <source_directory> <destination_directory>');
    process.exit(1);
  }

  console.log('=== Copie des fichiers ===');
  console.log(`Dossier source: ${sourceDir}`);
  console.log(`Dossier de destination: ${destDir}`);
  console.log('=========================');

  copyFiles(sourceDir, destDir);

  console.log('=== Copie terminée ===');
}

main();