<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hizhat</title>
    <link href="https://fonts.googleapis.com/css2?family=Lexend+Tera:wght@100;200;300;400;500;600;700&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        * {
            font-family: 'Lexend Tera', sans-serif;
        }

        .hero {
            height: 100vh;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }

        .line {
            height: 1px;
            background: #dedede;
        }

        .strike {
            position: relative;
        }

        .strike::after {
            content: '';
            position: absolute;
            left: 0;
            top: 50%;
            width: 0;
            height: 1px;
            background: #000;
            transition: width 2s ease;
        }

        .strike.active::after {
            width: 100%;
        }

        .positive {
            display: inline-block;
            opacity: 0;
            transition: opacity 2s ease;
        }

        .positive.show {
            opacity: 1;
        }
    </style>
</head>
<body>
    <div class="hero p-8">
        <header>
            <div class="flex items-center justify-center gap-6">
                <div class="line flex-1"></div>
                <h1 class="text-2xl font-light px-6">Hizhat</h1>
                <div class="line flex-1"></div>
            </div>
        </header>

        <main class="flex flex-col items-center justify-center gap-12">
            <div class="w-64 h-64 md:w-72 md:h-72">
                <img src="cover.jpg" alt="placeholder" class="w-full h-full object-cover rounded-md"/>
            </div>

            <div class="min-h-[100px] flex items-center">
                <h2 class="text-xl md:text-2xl font-light text-center">
                    <span class="strike">Why choose stress when</span> you can be
                    <span class="positive">
                        <span class="bg-yellow-100 px-1">totally</span>
                        <span class="bg-orange-100 px-1">at</span>
                        <span class="bg-blue-100 px-1">peace</span>
                        <span>!</span>
                    </span>
                </h2>
            </div>

            <p class="text-gray-600 text-sm font-light text-center">
                Book all your holidays in just five minutes.          
                </p>

            <a href="#" class="bg-gray-900 text-white px-8 py-3 rounded-full text-sm hover:bg-gray-800 transition-all duration-300">
                Book my vacation
            </a>
        </main>

        <footer>
            <div class="flex items-center justify-center gap-6">
                <div class="line flex-1"></div>
                <h1 class="text-2xl font-light px-6">Hizhat</h1>
                <div class="line flex-1"></div>
            </div>
        </footer>
    </div>

    <script>
        window.addEventListener('load', () => {
            setTimeout(() => {
                document.querySelector('.strike').classList.add('active');
            }, 0500);

            setTimeout(() => {
                document.querySelector('.positive').classList.add('show');
            }, 0700);
        });
    </script>
<footer class="bg-white font-['Poppins'] px-8">
        <div class="max-w-5xl mx-auto px-4 py-8 flex flex-wrap justify-between">
            <div class="w-full md:w-1/2 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Legal</h5>
                <a href="https://imators.com/privacy" class="my-3 block hover:text-gray-600 text-sm font-medium duration-700">Privacy Policy</a>
                <a href="https://imators.com/terms-of-use" class="my-3 block hover:text-gray-600 text-sm font-medium duration-700">Terms of Use</a>
            </div>
            <div class="w-full md:w-1/2 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">About</h5>
                <p class="text-sm">Hizhat is a member of Imators Group.</p>
            </div>
        </div>
        <div class="text-center py-4 border-t border-gray-200">
            <p class="text-sm mb-2">&copy; 2025 Imators. All rights reserved.</p>
            <p class="text-xs">Imators is a registered LLC (Limited Liability Company). All our products are subject to our rules.</p>
        </div>
    </footer>


</body>
</html>