<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Components AktasCorp</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Raleway:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Raleway', sans-serif;
            background-color: #f9f0e6;
        }
    </style>
</head>
<body class="text-gray-800 p-8">

    <div class="max-w-4xl mx-auto space-y-16">
        
        <div class="border-2 border-gray-300 p-8 rounded">
            <h2 class="text-xl mb-4 font-light">Card simple</h2>
            <div class="bg-white rounded-lg p-8 shadow-sm">
                <h3 class="text-2xl font-light mb-4">titre</h3>
                <p class="text-gray-600 leading-relaxed">Description ou contenu de la carte avec un style minimaliste qui respecte l'esthétique globale.</p>
            </div>
        </div>

        <div class="border-2 border-gray-300 p-8 rounded">
            <h2 class="text-xl mb-4 font-light">Card avec icône</h2>
            <div class="bg-white rounded-lg p-8 shadow-sm">
                <div class="flex items-start space-x-4">
                    <div class="w-8 h-8 bg-gray-800 rounded-full flex items-center justify-center flex-shrink-0">
                        <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                        </svg>
                    </div>
                    <div>
                        <h3 class="text-2xl font-light mb-4">innovation</h3>
                        <p class="text-gray-600 leading-relaxed">Nous développons des solutions modernes et innovantes pour répondre aux besoins d'aujourd'hui.</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="border-2 border-gray-300 p-8 rounded">
            <h2 class="text-xl mb-4 font-light">Boutons</h2>
            <div class="space-y-4">
                <button class="bg-gray-800 text-white px-8 py-3 rounded-lg font-light hover:bg-gray-700 transition-colors">
                    action principale
                </button>
                <button class="border border-gray-800 text-gray-800 px-8 py-3 rounded-lg font-light hover:bg-gray-800 hover:text-white transition-colors">
                    action secondaire
                </button>
                <button class="text-gray-800 px-8 py-3 font-light hover:text-gray-600 transition-colors">
                    lien simple
                </button>
            </div>
        </div>

        <div class="border-2 border-gray-300 p-8 rounded">
            <h2 class="text-xl mb-4 font-light">Liste de liens</h2>
            <div class="space-y-3">
                <a href="#" class="block text-gray-800 hover:text-gray-600 font-light border-b border-gray-200 pb-2">
                    première option
                </a>
                <a href="#" class="block text-gray-800 hover:text-gray-600 font-light border-b border-gray-200 pb-2">
                    deuxième option
                </a>
                <a href="#" class="block text-gray-800 hover:text-gray-600 font-light">
                    troisième option
                </a>
            </div>
        </div>

        <div class="border-2 border-gray-300 p-8 rounded">
            <h2 class="text-xl mb-4 font-light">Stats</h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <div class="text-center">
                    <div class="text-3xl font-light text-gray-800 mb-2">15+</div>
                    <div class="text-gray-600">années d'expérience</div>
                </div>
                <div class="text-center">
                    <div class="text-3xl font-light text-gray-800 mb-2">50+</div>
                    <div class="text-gray-600">projets réalisés</div>
                </div>
                <div class="text-center">
                    <div class="text-3xl font-light text-gray-800 mb-2">3</div>
                    <div class="text-gray-600">entreprises membres</div>
                </div>
            </div>
        </div>

        <div class="border-2 border-gray-300 p-8 rounded">
            <h2 class="text-xl mb-4 font-light">Citation</h2>
            <blockquote class="border-l-4 border-gray-300 pl-6 py-4">
                <p class="text-xl font-light text-gray-700 mb-4">
                    "La simplicité est la sophistication suprême."
                </p>
                <cite class="text-gray-500 text-sm">— Léonard de Vinci</cite>
            </blockquote>
        </div>

        <div class="border-2 border-gray-300 p-8 rounded">
            <h2 class="text-xl mb-4 font-light">Section avec séparateur</h2>
            <div class="space-y-8">
                <div>
                    <h3 class="text-2xl font-light mb-4">première section</h3>
                    <p class="text-gray-600">Contenu de la première section avec un style cohérent.</p>
                </div>
                <div class="border-t border-gray-300 pt-8">
                    <h3 class="text-2xl font-light mb-4">deuxième section</h3>
                    <p class="text-gray-600">Contenu de la deuxième section après le séparateur.</p>
                </div>
            </div>
        </div>

        <div class="border-2 border-gray-300 p-8 rounded">
            <h2 class="text-xl mb-4 font-light">Contact simple</h2>
            <div class="bg-white rounded-lg p-8 shadow-sm">
                <h3 class="text-2xl font-light mb-6">nous contacter</h3>
                <div class="space-y-4">
                    <div>
                        <span class="text-gray-500 text-sm">email</span>
                        <p class="font-light">contact@aktascorp.com</p>
                    </div>
                    <div>
                        <span class="text-gray-500 text-sm">adresse</span>
                        <p class="font-light">New York, États-Unis</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="border-2 border-gray-300 p-8 rounded">
            <h2 class="text-xl mb-4 font-light">Grid de cartes</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div class="bg-white rounded-lg p-6 shadow-sm">
                    <h4 class="text-lg font-light mb-3">imators</h4>
                    <p class="text-gray-600 text-sm">Entreprise technologique moderne offrant des solutions innovantes.</p>
                </div>
                <div class="bg-white rounded-lg p-6 shadow-sm">
                    <h4 class="text-lg font-light mb-3">vert chasseur</h4>
                    <p class="text-gray-600 text-sm">Quartier résidentiel de qualité avec des services premium.</p>
                </div>
                <div class="bg-white rounded-lg p-6 shadow-sm">
                    <h4 class="text-lg font-light mb-3">peerkinton</h4>
                    <p class="text-gray-600 text-sm">Solutions privées pour quartiers haut de gamme dans le monde.</p>
                </div>
                <div class="bg-white rounded-lg p-6 shadow-sm">
                    <h4 class="text-lg font-light mb-3">nouveau projet</h4>
                    <p class="text-gray-600 text-sm">Prochaine entreprise membre du groupe AktasCorp.</p>
                </div>
            </div>
        </div>

    </div>

</body>
</html>