<?php
$transparent_header = isset($transparent_header) ? $transparent_header : false;
?>
<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imators</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap');

        body {
            font-family: 'Poppins', sans-serif;
            color: #fff;
            background: #000;
        }

        .header {
            background: rgba(0, 0, 0, 0.9);
            position: fixed;
            top: 0;
            width: 100%;
            height: 70px;
            z-index: 1000;
            transition: all 0.3s;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        @media (min-width: 1024px) {
            .header {
                height: 90px;
            }
        }

        .header-transparent {
            background: transparent;
            border-bottom: none;
        }

        .header-transparent.scrolled {
            background: rgba(0, 0, 0, 0.9);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .desktop-menu {
            display: none;
        }

        @media (min-width: 1024px) {
            .desktop-menu {
                display: flex;
                gap: 40px;
            }

            .menu-item {
                position: relative;
            }

            .menu-link {
                color: #fff;
                font-weight: 400;
                transition: all 0.2s;
            }

            .menu-link:hover {
                opacity: 0.7;
            }

            .dropdown {
                position: absolute;
                top: calc(100% + 20px);
                left: 50%;
                transform: translateX(-50%);
                background: #121212;
                border-radius: 12px;
                width: 240px;
                padding: 16px;
                visibility: hidden;
                opacity: 0;
                transition: all 0.2s;
                border: 1px solid rgba(255, 255, 255, 0.1);
                box-shadow: 0 10px 25px rgba(0, 0, 0, 0.3);
            }

            .menu-item:hover .dropdown {
                visibility: visible;
                opacity: 1;
                top: calc(100% + 10px);
            }

            .dropdown-link {
                display: block;
                padding: 10px 12px;
                color: #fff;
                border-radius: 8px;
                margin-bottom: 4px;
                transition: all 0.2s;
            }

            .dropdown-link:hover {
                background: rgba(255, 255, 255, 0.1);
            }
        }

        .hamburger {
            width: 40px;
            height: 40px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.2s;
        }

        @media (min-width: 1024px) {
            .hamburger {
                display: none;
            }
        }

        .hamburger span {
            display: block;
            width: 20px;
            height: 2px;
            background: #fff;
            position: relative;
            transition: all 0.3s;
        }

        .hamburger span:before,
        .hamburger span:after {
            content: '';
            position: absolute;
            width: 100%;
            height: 100%;
            background: #fff;
            transition: all 0.3s;
        }

        .hamburger span:before {
            top: -6px;
        }

        .hamburger span:after {
            top: 6px;
        }

        .hamburger.active span {
            background: transparent;
        }

        .hamburger.active span:before {
            transform: rotate(45deg);
            top: 0;
        }

        .hamburger.active span:after {
            transform: rotate(-45deg);
            top: 0;
        }

        .mobile-menu {
            position: fixed;
            top: 70px;
            left: 0;
            width: 100%;
            height: calc(100vh - 70px);
            background: #000;
            padding: 20px;
            transform: translateX(-100%);
            transition: all 0.3s;
            z-index: 999;
            overflow-y: auto;
        }

        .mobile-menu.active {
            transform: translateX(0);
        }

        .mobile-section {
            margin-bottom: 30px;
        }

        .mobile-title {
            font-size: 0.8rem;
            text-transform: uppercase;
            opacity: 0.5;
            margin-bottom: 15px;
            letter-spacing: 1px;
        }

        .mobile-links a {
            display: block;
            padding: 12px 0;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .mobile-links a:last-child {
            border-bottom: none;
        }

        .stories {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 10px;
            margin-bottom: 30px;
        }

        .story {
            aspect-ratio: 1/1;
            border-radius: 12px;
            overflow: hidden;
            position: relative;
        }

        .story-bg {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
        }

        .story-content {
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            padding: 15px;
            background: linear-gradient(transparent, rgba(0, 0, 0, 0.8));
        }

        .story-title {
            font-weight: 500;
            margin-bottom: 3px;
        }

        .story-subtitle {
            font-size: 0.8rem;
            opacity: 0.7;
        }

        .account-btn {
            background: #fff;
            color: #000;
            padding: 8px 16px;
            border-radius: 8px;
            font-weight: 500;
            display: none;
        }

        @media (min-width: 1024px) {
            .account-btn {
                display: block;
            }
        }
    </style>
</head>
<body class="h-full">
    <header class="header <?php echo $transparent_header ? 'header-transparent' : ''; ?>">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 h-full flex items-center justify-between">
            <a href="/" class="flex items-center">
                <img src="https://cdn.imators.com/logo.png" alt="Imators" class="h-7 lg:h-9">
            </a>

            <nav class="desktop-menu">
                <div class="menu-item">
                    <a href="#" class="menu-link">Products</a>
                    <div class="dropdown">
                        <a href="https://academ.my" class="dropdown-link">Academ</a>
                        <a href="/progm" class="dropdown-link">Progm</a>
                        <a href="https://ohmypanel.com" class="dropdown-link">OhMyPanel</a>
                        <a href="https://owtfitt.com" class="dropdown-link">Owtfitt</a>
                        <a href="https://imators.systems/traffic" class="dropdown-link">TrafficLight</a>
                    </div>
                </div>
                <div class="menu-item">
                    <a href="#" class="menu-link">Developer Tools</a>
                    <div class="dropdown">
                        <a href="https://imators.systems" class="dropdown-link">Imators Systems</a>
                        <a href="https://developer.imators.com" class="dropdown-link">Imators Developer</a>
                        <a href="https://imators.systems/traffic" class="dropdown-link">TrafficLight</a>
                    </div>
                </div>
                <div class="menu-item">
                    <a href="#" class="menu-link">Company</a>
                    <div class="dropdown">
                        <a href="/support" class="dropdown-link">Support</a>
                        <a href="/contact-us" class="dropdown-link">Contact us</a>
                        <a href="/about-us" class="dropdown-link">About Imators</a>
                    </div>
                </div>
            </nav>

            <div class="flex items-center gap-4">
                <a href="https://idsma.imators.com" class="account-btn">Imators Account</a>
                <div class="hamburger">
                    <span></span>
                </div>
            </div>
        </div>
    </header>

    <div class="mobile-menu">
        <div class="stories">
            <div class="story" style="background: linear-gradient(45deg, #8B5CF6, #C4B5FD);">
                <div class="story-content">
                    <div class="story-title">Academ</div>
                    <div class="story-subtitle">Education simplified</div>
                </div>
            </div>
            <div class="story" style="background: linear-gradient(45deg, #FBBF24, #FEF3C7);">
                <div class="story-content">
                    <div class="story-title">OhMyPanel</div>
                    <div class="story-subtitle">Easy shopping</div>
                </div>
            </div>
            <div class="story" style="background: linear-gradient(45deg, #3B82F6, #93C5FD);">
                <div class="story-content">
                    <div class="story-title">TrafficLight</div>
                    <div class="story-subtitle">Traffic management</div>
                </div>
            </div>
            <div class="story" style="background: linear-gradient(45deg, #000000, #404040);">
                <div class="story-content">
                    <div class="story-title">Account</div>
                    <div class="story-subtitle">Global benefits</div>
                </div>
            </div>
        </div>

        <div class="mobile-section">
            <div class="mobile-title">Products</div>
            <div class="mobile-links">
                <a href="https://academ.my">Academ</a>
                <a href="/progm">Progm</a>
                <a href="https://ohmypanel.com">OhMyPanel</a>
                <a href="https://owtfitt.com">Owtfitt</a>
                <a href="https://imators.systems/traffic">TrafficLight</a>
            </div>
        </div>

        <div class="mobile-section">
            <div class="mobile-title">Developer Tools</div>
            <div class="mobile-links">
                <a href="https://imators.systems">Imators Systems</a>
                <a href="https://developer.imators.com">Imators Developer</a>
                <a href="https://imators.systems/traffic">TrafficLight</a>
            </div>
        </div>

        <div class="mobile-section">
            <div class="mobile-title">Company</div>
            <div class="mobile-links">
                <a href="/support">Support</a>
                <a href="/contact-us">Contact us</a>
                <a href="/about-us">About Imators</a>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const hamburger = document.querySelector('.hamburger');
            const mobileMenu = document.querySelector('.mobile-menu');
            const header = document.querySelector('.header');
            const stories = document.querySelectorAll('.story');
            
            let lastScrollY = 0;

            hamburger.addEventListener('click', function() {
                this.classList.toggle('active');
                mobileMenu.classList.toggle('active');
                if (mobileMenu.classList.contains('active')) {
                    document.body.style.overflow = 'hidden';
                } else {
                    document.body.style.overflow = '';
                }
            });

            window.addEventListener('scroll', function() {
                const scrollY = window.scrollY;
                
                if (header.classList.contains('header-transparent')) {
                    if (scrollY > 0) {
                        header.classList.add('scrolled');
                    } else {
                        header.classList.remove('scrolled');
                    }
                }
                
                lastScrollY = scrollY;
            });

            stories.forEach(story => {
                story.addEventListener('click', function() {
                    const title = this.querySelector('.story-title').textContent;
                    switch(title) {
                        case 'Academ':
                            window.location.href = 'https://academ.my';
                            break;
                        case 'OhMyPanel':
                            window.location.href = 'https://ohmypanel.com';
                            break;
                        case 'TrafficLight':
                            window.location.href = 'https://imators.systems/traffic';
                            break;
                        case 'Account':
                            window.location.href = 'https://idsma.imators.com';
                            break;
                    }
                });
            });
        });
    </script>
</body>
</html>