<?php
require_once 'config.php';

// Handle like/dislike
if(isset($_POST['action']) && isset($_SESSION['user_id'])) {
    $action = $_POST['action'];
    $video_id = $_POST['video_id'];
    
    // Remove existing like/dislike
    $stmt = $pdo->prepare("DELETE FROM interactions WHERE content_id = ? AND user_id = ? AND type IN ('like', 'dislike')");
    $stmt->execute([$video_id, $_SESSION['user_id']]);
    
    // Add new interaction
    if($action !== 'remove') {
        $stmt = $pdo->prepare("INSERT INTO interactions (content_id, user_id, type) VALUES (?, ?, ?)");
        $stmt->execute([$video_id, $_SESSION['user_id'], $action]);
    }
    exit;
}

// Handle comment
if(isset($_POST['comment']) && isset($_SESSION['user_id'])) {
    $comment = $_POST['comment'];
    $video_id = $_POST['video_id'];
    
    $stmt = $pdo->prepare("INSERT INTO interactions (content_id, user_id, type, comment_text) VALUES (?, ?, 'comment', ?)");
    $stmt->execute([$video_id, $_SESSION['user_id'], $comment]);
    exit;
}

if(isset($_GET['id'])) {
    $id = (int)$_GET['id'];
    
    // Add view
    if(isset($_SESSION['user_id'])) {
        $stmt = $pdo->prepare("INSERT INTO interactions (content_id, user_id, type) VALUES (?, ?, 'view')");
        $stmt->execute([$id, $_SESSION['user_id']]);
    }

    // Get video info with counts
    $stmt = $pdo->prepare("
        SELECT 
            c.*, 
            u.username as author_name,
            COUNT(DISTINCT CASE WHEN i.type = 'view' THEN i.id END) as view_count,
            COUNT(DISTINCT CASE WHEN i.type = 'like' THEN i.id END) as like_count,
            COUNT(DISTINCT CASE WHEN i.type = 'dislike' THEN i.id END) as dislike_count
        FROM content c
        LEFT JOIN users u ON c.author_id = u.id
        LEFT JOIN interactions i ON c.id = i.content_id
        WHERE c.id = ?
        GROUP BY c.id
    ");
    $stmt->execute([$id]);
    $video = $stmt->fetch(PDO::FETCH_ASSOC);

    if($video) {
        // Get user's interaction
        $userInteraction = null;
        if(isset($_SESSION['user_id'])) {
            $stmt = $pdo->prepare("SELECT type FROM interactions WHERE content_id = ? AND user_id = ? AND type IN ('like', 'dislike') LIMIT 1");
            $stmt->execute([$id, $_SESSION['user_id']]);
            $userInteraction = $stmt->fetchColumn();
        }

        // Video player with controls
        echo '<video src="' . htmlspecialchars($video['url_video']) . '" controls class="w-full">
            Your browser does not support the video tag.
        </video>';
        
        // Video information
        echo '<div class="mt-4">';
        echo '<h2 class="text-2xl font-bold">' . htmlspecialchars($video['name']) . '</h2>';
        echo '<p class="text-gray-400 mt-2">' . nl2br(htmlspecialchars($video['description'])) . '</p>';
        echo '<p class="text-gray-400 mt-2">By: ' . htmlspecialchars($video['author_name']) . '</p>';
        
        // Likes/Dislikes
        echo '<div class="flex items-center space-x-4 mt-4">';
        echo '<span>' . $video['view_count'] . ' views</span>';
        
        $likeClass = ($userInteraction === 'like') ? 'bg-blue-500' : 'bg-gray-700';
        $dislikeClass = ($userInteraction === 'dislike') ? 'bg-blue-500' : 'bg-gray-700';
        
        if(isset($_SESSION['user_id'])) {
            echo "<button onclick=\"handleInteraction('like', {$video['id']})\" class=\"{$likeClass} px-4 py-2 rounded\">";
            echo $video['like_count'] . ' Likes</button>';
            
            echo "<button onclick=\"handleInteraction('dislike', {$video['id']})\" class=\"{$dislikeClass} px-4 py-2 rounded\">";
            echo $video['dislike_count'] . ' Dislikes</button>';
        } else {
            echo '<span class="text-gray-400">' . $video['like_count'] . ' Likes</span>';
            echo '<span class="text-gray-400">' . $video['dislike_count'] . ' Dislikes</span>';
        }
        echo '</div>';

        // Comments section
        echo '<div class="mt-8">';
        echo '<h3 class="text-xl font-bold mb-4">Comments</h3>';
        
        if(isset($_SESSION['user_id'])) {
            echo '<form onsubmit="handleComment(event, ' . $video['id'] . ')" class="mb-6">';
            echo '<textarea id="commentText" class="w-full bg-gray-700 rounded p-2" rows="2"></textarea>';
            echo '<button type="submit" class="mt-2 bg-blue-500 hover:bg-blue-700 px-4 py-2 rounded">Post Comment</button>';
            echo '</form>';
        }
        
        // Display comments
        $stmt = $pdo->prepare("
            SELECT i.*, u.username 
            FROM interactions i 
            JOIN users u ON i.user_id = u.id 
            WHERE i.content_id = ? AND i.type = 'comment' 
            ORDER BY i.created_at DESC
        ");
        $stmt->execute([$id]);
        $comments = $stmt->fetchAll();
        
        foreach($comments as $comment) {
            echo '<div class="bg-gray-700 rounded p-4 mb-4">';
            echo '<div class="flex justify-between">';
            echo '<span class="font-bold">' . htmlspecialchars($comment['username']) . '</span>';
            echo '<span class="text-gray-400">' . $comment['created_at'] . '</span>';
            echo '</div>';
            echo '<p class="mt-2">' . nl2br(htmlspecialchars($comment['comment_text'])) . '</p>';
            echo '</div>';
        }
        
        echo '</div>'; // End comments section
        echo '</div>'; // End video info

        // JavaScript for interactions
        echo '<script>
        function handleInteraction(action, videoId) {
            const formData = new FormData();
            formData.append("action", action);
            formData.append("video_id", videoId);
            
            fetch("get_video.php", {
                method: "POST",
                body: formData
            }).then(() => {
                // Refresh video content
                openModal(videoId);
            });
        }

        function handleComment(event, videoId) {
            event.preventDefault();
            const comment = document.getElementById("commentText").value;
            if(!comment.trim()) return;
            
            const formData = new FormData();
            formData.append("comment", comment);
            formData.append("video_id", videoId);
            
            fetch("get_video.php", {
                method: "POST",
                body: formData
            }).then(() => {
                document.getElementById("commentText").value = "";
                openModal(videoId);
            });
        }
        </script>';
    }
}
?>