<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>The Peerkinton Village</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Underdog&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/feather-icons/dist/feather.min.js"></script>
</head>
<body class="bg-black text-white font-sans">
    <nav class="fixed top-0 left-0 w-full bg-black/80 z-50">
        <div class="container mx-auto px-4 py-3 flex items-center justify-between">
            <a href="#" class="text-3xl font-['Underdog'] flex items-center">
                <span class="mr-2">Peerkinton</span>
            </a>
            <div class="md:flex hidden space-x-6">
                <a href="#accueil" class="hover:text-gray-300 transition duration-300">Accueil</a>
                <a href="#reserver" class="hover:text-gray-300 transition duration-300">Réserver</a>
                <a href="#regles" class="hover:text-gray-300 transition duration-300">Règles</a>
                <a href="#information" class="hover:text-gray-300 transition duration-300">Information</a>
            </div>
            <div class="md:hidden">
                <button id="mobile-menu-toggle" class="text-white">
                    <i data-feather="menu"></i>
                </button>
            </div>
        </div>
        <div id="mobile-menu" class="md:hidden hidden bg-black/90 absolute top-full left-0 w-full">
            <div class="flex flex-col items-center space-y-4 py-4">
                <a href="#accueil" class="hover:text-gray-300 transition duration-300">Accueil</a>
                <a href="#reserver" class="hover:text-gray-300 transition duration-300">Réserver</a>
                <a href="#regles" class="hover:text-gray-300 transition duration-300">Règles</a>
                <a href="#information" class="hover:text-gray-300 transition duration-300">Information</a>
            </div>
        </div>
    </nav>

    <main>
        <section id="accueil" class="relative h-screen flex items-center justify-center text-center">
            <div class="absolute inset-0 bg-black opacity-50 z-10"></div>
            <div class="relative z-20 container mx-auto px-4">
                <h1 class="text-6xl md:text-8xl font-['Underdog'] mb-6 animate-fade-in">
                    The Peerkinton Village
                </h1>
                <p class="text-xl md:text-2xl max-w-3xl mx-auto mb-8 animate-fade-in delay-300">
                    Vivez une expérience immersive dans un village du 19ème siècle, où chaque moment est une plongée dans l'histoire.
                </p>
                <div class="animate-fade-in delay-500">
                    <a href="#reserver" class="bg-white text-black px-6 py-3 rounded-full hover:bg-gray-200 transition duration-300 inline-block">
                        Commencez votre voyage
                    </a>
                </div>
            </div>
        </section>

        <section id="reserver" class="min-h-screen flex items-center justify-center bg-gray-900 py-20">
            <div class="container mx-auto px-4">
                <h2 class="text-4xl md:text-5xl text-center mb-12">Réserver une Session</h2>
                <div class="max-w-md mx-auto bg-black/70 p-8 rounded-xl shadow-lg">
                    <form class="space-y-6">
                        <input type="text" placeholder="Nom" class="w-full p-3 bg-gray-800 text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-white">
                        <input type="email" placeholder="Email" class="w-full p-3 bg-gray-800 text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-white">
                        <select class="w-full p-3 bg-gray-800 text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-white">
                            <option>Choisissez une session</option>
                            <option>Session Journée</option>
                            <option>Session Week-end</option>
                            <option>Session Semaine Complète</option>
                        </select>
                        <button type="submit" class="w-full bg-white text-black p-3 rounded-lg hover:bg-gray-200 transition duration-300">
                            Réserver
                        </button>
                    </form>
                </div>
            </div>
        </section>

        <section id="regles" class="min-h-screen flex items-center justify-center bg-gray-800 py-20">
            <div class="container mx-auto px-4">
                <h2 class="text-4xl md:text-5xl text-center mb-12">Règles du Village</h2>
                <div class="max-w-2xl mx-auto">
                    <ul class="space-y-6 text-xl text-center">
                        <li class="bg-black/50 p-4 rounded-lg">Restez dans le personnage en permanence</li>
                        <li class="bg-black/50 p-4 rounded-lg">Respectez l'authenticité historique</li>
                        <li class="bg-black/50 p-4 rounded-lg">Utilisez uniquement des objets et des langages de l'époque</li>
                        <li class="bg-black/50 p-4 rounded-lg">Aucun appareil moderne n'est autorisé pendant l'expérience</li>
                        <li class="bg-black/50 p-4 rounded-lg">La courtoisie et le respect mutuel sont essentiels</li>
                    </ul>
                </div>
            </div>
        </section>

        <section id="information" class="min-h-screen flex items-center justify-center bg-gray-900 py-20">
            <div class="container mx-auto px-4">
                <h2 class="text-4xl md:text-5xl text-center mb-12">Informations</h2>
                <div class="max-w-2xl mx-auto space-y-6 text-center">
                    <p class="text-xl">
                        The Peerkinton Village est situé dans un domaine privé de 50 hectares, entièrement reconstruit pour reproduire l'atmosphère des années 1800.
                    </p>
                    <p class="text-xl">
                        Nos sessions sont encadrées par des historiens et des experts en reconstitution historique pour garantir une expérience authentique.
                    </p>
                    <p class="text-xl">
                        Tarifs, réservations et détails complémentaires disponibles sur demande.
                    </p>
                </div>
            </div>
        </section>
    </main>

    <footer class="bg-black text-center py-6">
        <p>&copy; 2025 The Peerkinton Village. Tous droits réservés.</p>
    </footer>

    <script>
        // Mobile menu toggle
        const mobileMenuToggle = document.getElementById('mobile-menu-toggle');
        const mobileMenu = document.getElementById('mobile-menu');

        mobileMenuToggle.addEventListener('click', () => {
            mobileMenu.classList.toggle('hidden');
        });

        // Feather Icons
        feather.replace();

        // Smooth scrolling
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                document.querySelector(this.getAttribute('href')).scrollIntoView({
                    behavior: 'smooth'
                });
            });
        });
    </script>

    <style>
        @keyframes fade-in {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .animate-fade-in {
            animation: fade-in 1s ease-out forwards;
            opacity: 0;
        }
        .delay-300 { animation-delay: 0.3s; }
        .delay-500 { animation-delay: 0.5s; }
    </style>
</body>
</html>