<?php
$lang = isset($_GET['lang']) ? $_GET['lang'] : 'en';

$content = [
    'en' => [
        'title' => 'Your invitation to appear in an Imators advertisement.',
        'promo_title' => 'Your invitation to appear in an Imators advertisement.',
        'photo_title' => 'Photography',
        'photo_desc' => 'Our sessions are held in open and not closed or risky places. All photos taken during the session are shown to your children, and sent to you before selection.',
        'security_title' => 'Security',
        'security_desc' => 'We hold ourselves responsible in case of accidents on site, even though these are extremely rare.',
        'confidentiality_title' => 'Confidentiality',
        'confidentiality_desc' => 'By virtue of the European and international laws imposed on us as well as out of respect for our ethics, your child\'s photos will in no case be used for illegal purposes or to harm them.',
        'download_docs' => 'Download Documents',
        'steps_title' => 'Next Steps',
        'step1_title' => 'Download & Print',
        'step1_desc' => 'Download the documents and print them on A4 paper.',
        'step2_title' => 'Fill & Sign',
        'step2_desc' => 'Fill in all required fields and sign the documents. Parent or guardian signature is mandatory.',
        'step3_title' => 'Return Documents',
        'step3_desc' => 'Return the signed documents to your Imators representative or send scanned copies to casting@imators.systems.',
        'contact_info' => 'For any questions, please contact us at contact@imators.systems'
    ],
    'fr' => [
        'title' => 'Votre invitation à apparaître dans une publicité Imators.',
        'promo_title' => 'Votre invitation à apparaître dans une publicité Imators.',
        'photo_title' => 'Photographie',
        'photo_desc' => 'Nos sessions sont tenues dans des lieux ouvert et non fermés ou à risque. Toute photos prises pendant la sessions sont montrée à vos enfants, et vont sont envoyer avant la sélection.',
        'security_title' => 'Sécurité',
        'security_desc' => 'Nous nous tenons responsable en cas d\'accident sur place, même si ces derniers sont extrêmement rare.',
        'confidentiality_title' => 'Confidentialité',
        'confidentiality_desc' => 'En vertu des lois Européennes et internationales qui nous sont imposés ainsi que par respect de notre éthique, les photos de votre enfant ne seront en aucun cas utilisé pour un buts illégal ou pour leur nuire.',
        'download_docs' => 'Télécharger les Documents',
        'steps_title' => 'Prochaines Étapes',
        'step1_title' => 'Télécharger & Imprimer',
        'step1_desc' => 'Téléchargez les documents et imprimez-les sur du papier A4.',
        'step2_title' => 'Remplir & Signer',
        'step2_desc' => 'Remplissez tous les champs requis et signez les documents. La signature du parent ou tuteur est obligatoire.',
        'step3_title' => 'Retourner les Documents',
        'step3_desc' => 'Retournez les documents signés à votre représentant Imators ou envoyez des copies numérisées à casting@imators.systems.',
        'contact_info' => 'Pour toute question, veuillez nous contacter à contact@imators.systems'
    ]
];
?>
<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $content[$lang]['title']; ?></title>
    
    <meta property="og:title" content="<?php echo $content[$lang]['title']; ?>">
    <meta property="og:description" content="Imators Casting">
    <meta property="og:image" content="https://imators.systems/images/og-casting.jpg">
    <meta property="og:url" content="https://imators.systems/casting">
    <meta property="og:type" content="website">
    
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #000;
            color: #fff;
        }
        
        .info-box {
            border-left: 2px solid white;
        }
        
        .info-box:hover {
            background-color: rgba(255, 255, 255, 0.05);
        }
        
        .step-card {
            background-color: #111;
            border: 1px solid #333;
            transition: transform 0.3s ease;
        }
        
        .step-card:hover {
            transform: translateY(-5px);
        }
    </style>
</head>
<body class="min-h-screen bg-black text-white">
    <?php if (file_exists('src/header.php')) { include 'src/header.php'; } ?>
    
    <div class="max-w-4xl mx-auto px-4 py-12">
        <!-- Title -->
        <h1 class="mt-24 text-4xl font-light text-center mb-12"><?php echo $content[$lang]['promo_title']; ?></h1>
        
        <!-- Main content -->
        <div class="space-y-8">
            <!-- Info Boxes -->
            <div class="grid md:grid-cols-3 gap-6">
                <!-- Photography -->
                <div class="info-box pl-6 pr-4 py-6">
                    <h2 class="text-xl font-light mb-3"><?php echo $content[$lang]['photo_title']; ?></h2>
                    <p class="text-gray-300 text-sm"><?php echo $content[$lang]['photo_desc']; ?></p>
                </div>
                
                <!-- Security -->
                <div class="info-box pl-6 pr-4 py-6">
                    <h2 class="text-xl font-light mb-3"><?php echo $content[$lang]['security_title']; ?></h2>
                    <p class="text-gray-300 text-sm"><?php echo $content[$lang]['security_desc']; ?></p>
                </div>
                
                <!-- Confidentiality -->
                <div class="info-box pl-6 pr-4 py-6">
                    <h2 class="text-xl font-light mb-3"><?php echo $content[$lang]['confidentiality_title']; ?></h2>
                    <p class="text-gray-300 text-sm"><?php echo $content[$lang]['confidentiality_desc']; ?></p>
                </div>
            </div>
            
            <!-- Download section -->
            <div class="text-center py-8">
                <a href="/docs/casting-documents.pdf" class="inline-flex items-center border border-white text-white px-8 py-4 rounded-full text-lg hover:bg-white hover:text-black transition duration-300">
                    <i class="fa fa-download mr-3"></i> <?php echo $content[$lang]['download_docs']; ?>
                </a>
            </div>
            
            <!-- Steps section -->
            <div class="py-8">
                <h2 class="text-2xl font-light text-center mb-8"><?php echo $content[$lang]['steps_title']; ?></h2>
                
                <div class="grid md:grid-cols-3 gap-6">
                    <!-- Step 1 -->
                    <div class="step-card p-6 rounded-lg">
                        <div class="flex items-center mb-4">
                            <div class="bg-white text-black rounded-full w-8 h-8 flex items-center justify-center mr-3">1</div>
                            <h3 class="text-lg font-light"><?php echo $content[$lang]['step1_title']; ?></h3>
                        </div>
                        <p class="text-gray-300 text-sm"><?php echo $content[$lang]['step1_desc']; ?></p>
                    </div>
                    
                    <!-- Step 2 -->
                    <div class="step-card p-6 rounded-lg">
                        <div class="flex items-center mb-4">
                            <div class="bg-white text-black rounded-full w-8 h-8 flex items-center justify-center mr-3">2</div>
                            <h3 class="text-lg font-light"><?php echo $content[$lang]['step2_title']; ?></h3>
                        </div>
                        <p class="text-gray-300 text-sm"><?php echo $content[$lang]['step2_desc']; ?></p>
                    </div>
                    
                    <!-- Step 3 -->
                    <div class="step-card p-6 rounded-lg">
                        <div class="flex items-center mb-4">
                            <div class="bg-white text-black rounded-full w-8 h-8 flex items-center justify-center mr-3">3</div>
                            <h3 class="text-lg font-light"><?php echo $content[$lang]['step3_title']; ?></h3>
                        </div>
                        <p class="text-gray-300 text-sm"><?php echo $content[$lang]['step3_desc']; ?></p>
                    </div>
                </div>
            </div>
            
            <!-- Contact info -->
            <div class="text-center text-sm text-gray-400 py-4">
                <?php echo $content[$lang]['contact_info']; ?>
            </div>
        </div>
    </div>
    
    <!-- Language switcher -->
    <div class="fixed bottom-6 right-6 flex space-x-2">
        <a href="?lang=en" class="px-3 py-1 rounded <?php echo $lang === 'en' ? 'bg-white text-black' : 'bg-black text-white border border-gray-700'; ?>">
            EN
        </a>
        <a href="?lang=fr" class="px-3 py-1 rounded <?php echo $lang === 'fr' ? 'bg-white text-black' : 'bg-black text-white border border-gray-700'; ?>">
            FR
        </a>
    </div>
</body>
</html>