<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>عن Imators</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.1.2/dist/tailwind.min.css">
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css" />
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@2.8.0/dist/alpine.min.js" defer></script>
</head>
    <style>
@import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap');
    body {
        font-family: 'Space Grotesk', sans-serif;
    }
    
    .gradient-background {
        background: rgb(34,193,195);
        background: linear-gradient(0deg, rgba(34,193,195,1) 0%, rgba(167,45,253,1) 100%);
        color: #FFFFFF;
    }

    header {
        background-color: rgba(0, 0, 0, 0.8); 
        transition: background-color 0.5s;
    }
    .menu-link {
        transition: color 0.3s ease-in-out;
        color: #FFF !important; 
    }
    .footer, .mobile-menu {
        background-color: #111827;
        color: #FFF;
    }

    .coc {
        background-color: #111827;
    }

    .timeline {
        position: relative;
    }
    .timeline::before {
        content: '';
        position: absolute;
        left: 50%;
        transform: translateX(-50%);
        top: 0;
        bottom: 0;
        width: 2px;
        background: #D1D5DB;
    }
    .timeline-item {
        position: relative;
        width: 100%;
        padding: 10px 40px;
        margin-bottom: 20px;
    }
    .timeline-marker {
        position: absolute;
        top: 15px;
        left: 50%;
        transform: translateX(-50%);
        height: 20px;
        width: 20px;
        border-radius: 50%;
        background: #3B82F6;
    }
    .timeline-content {
        max-width: 40%;
        padding: 20px;
        background: #F9FAFB;
        border-radius: 8px;
    }
    .timeline-item:nth-child(even) .timeline-content {
        margin-left: auto;
        background: #EFF6FF;
    }

    .parallax-container {
        perspective: 2px;
    }
    .parallax-background {
        transform: translateZ(-1px) scale(2);
        min-height: 100vh;
        background-size: cover;
        background-position: center;
    }
    .content {
        position: relative;
    }
    
    .fade-in-section {
        transition: opacity 0.6s ease-out, transform 1s ease-out;
        opacity: 0;
        transform: translateY(20px);
        visibility: hidden;
    }
    .fade-in-section.is-visible {
        opacity: 1;
        transform: none;
        visibility: visible;
    }

    @keyframes gradient {
        0% {
            background-position: 0% 50%;
        }
        50% {
            background-position: 100% 50%;
        }
        100% {
            background-position: 0% 50%;
        }
    }

    .gradient-bg {
        background: linear-gradient(-45deg, #6b1839, #1c4b82, #076b3b);
        background-size: 400% 400%;
        animation: gradient 15s ease infinite;
    }

    /* Style pour les images arrondies */
    .rounded-image {
        border-radius: 1rem; /* Arrondi des images */
        overflow: hidden;
    }
</style>
