<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="logo_new.png">
    <title>Vert Chasseur</title>
    <meta name="description" content="Vert Chasseur est un quartier à Uccle où vous trouverez de la joie et un havre de paix accueillant.">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {}
            }
        }

        .police-sandro {
            font-family: "Archivo Black", sans-serif;
            font-weight: 400;
            font-style: normal;
            }

    </script>
    <script defer src="https://cloud.umami.is/script.js" data-website-id="6ec552ef-4a61-4f71-a55f-4464703af623"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Princess+Sofia&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Abril+Fatface&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Archivo+Black&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            letter-spacing: -0.01em;
        }
        .card-hover {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        .card-hover:hover {
            transform: translateY(-4px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
        }
        .dark .card-hover:hover {
            box-shadow: 0 5px 15px rgba(255,255,255,0.05);
        }
        .txt-chasseur {
            font-family: "Princess Sofia", serif;
            font-weight: 400;
            font-style: normal;
        }
        .txt-ad-title {
            font-family: "Abril Fatface", serif;
            font-weight: 400;
        }
        .deli-gradient {
            background: linear-gradient(90deg, 
                #a9d7d0 0%, 
                #a9d7d0 25%, 
                #ef6f56 25%, 
                #ef6f56 50%, 
                #bbbae3 50%, 
                #bbbae3 75%, 
                #ffe076 75%, 
                #ffe076 100%);
        }
        .pub-image-bg {
            background-image: url('pics_aceclub.jpg');
            background-size: cover;
            background-position: center;
        }
        .artisan-image-bg {
            background-image: url('https://edge.disstg.commercecloud.salesforce.com/dw/image/v2/BCMW_STG/on/demandware.static/-/Library-Sites-Sandro-Shared/default/dw46d6cb8a/LP/LOOKBOOK%20SS25/07%20copie.jpg');
            background-size: cover;
            background-position: center;
        }
        
        @media (min-width: 768px) {
            .story-card {
                aspect-ratio: 9/16;
                max-height: 600px;
            }
        }
    </style>
</head>
<body class="bg-white dark:bg-black transition-colors duration-300">
    <script>
        if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
            document.documentElement.classList.add('dark');
        }
        window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', e => {
            if (e.matches) {
                document.documentElement.classList.add('dark');
            } else {
                document.documentElement.classList.remove('dark');
            }
        });
        
        document.addEventListener('DOMContentLoaded', function() {
            const pubContainer = document.getElementById('pub-container');
            
            let visitCount = localStorage.getItem('visitCount');
            
            if (!visitCount) {
                visitCount = 1;
            } else {
                visitCount = parseInt(visitCount) + 1;
            }
            
            localStorage.setItem('visitCount', visitCount);
            
            if (visitCount % 3 === 1) {
                pubContainer.href = "https://vertchasseur.com/shop-details?id=3";
                pubContainer.classList.add('deli-gradient');
                pubContainer.classList.remove('pub-image-bg', 'artisan-image-bg');
                pubContainer.innerHTML = `
                    <div class="absolute inset-0 flex flex-col justify-end md:justify-start p-6 bg-gradient-to-t md:bg-gradient-to-b from-black/60 to-transparent">
                        <div class="absolute top-4 right-4 bg-white dark:bg-gray-900 text-black dark:text-white text-xs px-2 py-1 rounded-full">Publicité</div>
                        <h2 class="text-white text-2xl font-medium mb-2 md:mt-8">Delitraiteur,<br> le coin de douceur<br> de Vert Chasseur</h2>
                        <p class="text-white/80 text-sm">Smile and quality, with simplicity.</p>
                        <button class="mt-4 px-4 py-2 bg-white/20 backdrop-blur-sm text-white text-sm rounded-full hover:bg-white/30 transition-colors">Découvrir</button>
                    </div>
                `;
            } else if (visitCount % 3 === 2) {
                pubContainer.href = "https://theaceclubparis.com/en-be";
                pubContainer.classList.remove('deli-gradient', 'artisan-image-bg');
                pubContainer.classList.add('pub-image-bg');
                pubContainer.innerHTML = `
                    <div class="absolute inset-0 flex flex-col justify-end md:justify-start p-6 bg-gradient-to-t md:bg-gradient-to-b from-black/60 to-transparent">
                        <div class="absolute top-4 right-4 bg-white dark:bg-gray-900 text-black dark:text-white text-xs px-2 py-1 rounded-full">Publicité</div>
                        <h2 class="text-white text-2xl font-medium mb-2 md:mt-8">Discover<br> The Ace Club, and preserve the legacy.</h2>
                        <p class="text-white/80 text-sm">Marque de vêtements de sport et de style de vie haut de gamme</p>
                        <button class="mt-4 px-4 py-2 bg-white/20 backdrop-blur-sm text-white text-sm rounded-full hover:bg-white/30 transition-colors">Explorer</button>
                    </div>
                `;
            } else {
                pubContainer.href = "https://vertchasseur.com/shop-details?id=7";
                pubContainer.classList.remove('deli-gradient', 'pub-image-bg');
                pubContainer.classList.add('artisan-image-bg');
                pubContainer.innerHTML = `
                    <div class="absolute inset-0 flex flex-col justify-end md:justify-start p-6 bg-gradient-to-t md:bg-gradient-to-b from-black/60 to-transparent">
                        <div class="absolute top-4 right-4 bg-white dark:bg-gray-900 text-black dark:text-white text-xs px-2 py-1 rounded-full">Publicité</div>
                        <h2 class="txt-ad-title text-white text-2xl mb-2 md:mt-8 police-sandro">Sandro,<br>Springs 25'</h2>
                        <p class="text-white/80 text-sm">Découvrez notre collection de produits artisanaux locaux</p>
                        <button class="mt-4 px-4 py-2 bg-white/20 backdrop-blur-sm text-white text-sm rounded-full hover:bg-white/30 transition-colors">Visiter</button>
                    </div>
                `;
            }
        });
    </script>

    <?php include 'header.php'; ?>

    <main class="min-h-screen flex flex-col items-center justify-center px-4 py-10">
        <div class="mt-16 text-center max-w-xl mx-auto mb-16">
            <p class="text-gray-400 dark:text-gray-500 text-sm tracking-wider uppercase mb-3">Uccle · Bruxelles</p>
            <h1 class="text-4xl md:text-6xl font-light mb-6 text-gray-800 dark:text-white">Bienvenue à <span class="txt-chasseur font-normal">Vert Chasseur</span></h1>
            <p class="text-lg text-gray-500 dark:text-gray-400 leading-relaxed max-w-md mx-auto">
                Un havre de paix, qui ne s'arretera jamais.
            </p>
        </div>

        <div class="w-full max-w-6xl mx-auto grid md:grid-cols-2 lg:grid-cols-3 gap-8 px-4">
            <a id="pub-container" class="card-hover story-card group block aspect-square md:aspect-auto rounded-xl overflow-hidden relative">
            </a>
            
            <a href="https://vertchasseur.com/shop" class="card-hover story-card group block rounded-xl p-6 bg-white dark:bg-gray-900 border border-gray-100 dark:border-gray-800 overflow-hidden">
                <div class="h-full flex flex-col justify-between">
                    <div>
                        <h2 class="text-2xl font-medium mb-4 text-gray-800 dark:text-white">Commerces & Restaurants</h2>
                        <p class="text-gray-500 dark:text-gray-400 leading-relaxed">Découvrez les établissements qui font la richesse de notre quartier avec une qualité irréprochable dans la majorité.</p>
                    </div>
                    <div class="flex items-center text-gray-800 dark:text-white mt-6 group-hover:translate-x-1 transition-transform">
                        <span class="mr-2 text-sm font-medium">Explorer</span>
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
                        </svg>
                    </div>
                </div>
            </a>

            <div class="card-hover story-card block rounded-xl p-6 bg-white dark:bg-gray-900 border border-gray-100 dark:border-gray-800 overflow-hidden">
                <div class="h-full flex flex-col justify-between">
                    <div>
                        <h2 class="text-2xl font-medium mb-4 text-gray-800 dark:text-white"><span class="txt-chasseur">Le poème du jour</span></h2>
                        <p class="text-gray-500 dark:text-gray-400 leading-relaxed">
                            Dans le silence d'un matin pur,<br>
                            La brise chante, douce et sûre.<br>
                            Les arbres dansent, pleins de lumière,<br>
                            Offrant leur paix à l'univers.
                        </p>
                    </div>
                    <p class="text-right text-gray-400 dark:text-gray-500 text-sm italic mt-6">Par Alois Passareiro</p>
                </div>
            </div>
        </div>
    </main>

    <footer class="w-full py-6 mt-10 border-t border-gray-100 dark:border-gray-800">
        <p class="text-xs text-gray-400 dark:text-gray-500 text-center">© 2025 Vert Chasseur · A <a href="https://aktascorp.com" class="underline hover:text-gray-600 dark:hover:text-gray-300">aktascorp</a> member · <a href="https://aktascorp.com/privacy" class="hover:text-gray-600 dark:hover:text-gray-300">Confidentialité</a></p>
    </footer>
</body>
</html>