<?php
$db_host = 'localhost';
$db_name = 'family_hub';
$db_user = 'db_user';
$db_pass = 'db_password';

try {
    $db = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $db->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

$cdn_url = 'https://cdn.imators.com';

function detectFamily($db) {
    $host = $_SERVER['HTTP_HOST'];
    $path = trim(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH), '/');
    $path_parts = explode('/', $path);
    
    if (strpos($host, '.andweare.com') !== false) {
        // C'est un sous-domaine
        $family_slug = explode('.', $host)[0];
        $site_type = 'subdomain';
    } else if ($path_parts[0] && $host === 'andweare.com') {
        // C'est un dossier
        $family_slug = $path_parts[0];
        $site_type = 'directory';
    } else {
        die("No family found at this URL");
    }
    
    $stmt = $db->prepare("SELECT * FROM family_sites WHERE family_slug = ?");
    $stmt->execute([$family_slug]);
    $family = $stmt->fetch();
    
    if (!$family) {
        die("Family not found");
    }
    
    return $family;
}

$family = detectFamily($db);
$family_id = $family['id'];
$site_url = $family['site_url'];

function getMembers($db, $family_id) {
    $stmt = $db->prepare("SELECT u.id, u.username, u.email, fm.role FROM family_members fm JOIN utilisateurs u ON fm.user_id = u.id WHERE fm.family_site_id = ?");
    $stmt->execute([$family_id]);
    return $stmt->fetchAll();
}

$members = getMembers($db, $family_id);