<?php 
require_once 'config.php';

$query = $pdo->query("
    SELECT 
        c.*,
        u.username as author_name,
        COUNT(DISTINCT CASE WHEN i.type = 'view' THEN i.id END) as view_count,
        COUNT(DISTINCT CASE WHEN i.type = 'like' THEN i.id END) as like_count,
        COUNT(DISTINCT CASE WHEN i.type = 'dislike' THEN i.id END) as dislike_count,
        COUNT(DISTINCT CASE WHEN i.type = 'comment' THEN i.id END) as comment_count
    FROM content c
    LEFT JOIN users u ON c.author_id = u.id
    LEFT JOIN interactions i ON c.id = i.content_id
    GROUP BY c.id
    ORDER BY c.created_at DESC
");

$videos = $query->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ForMore</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Titillium+Web:wght@200;300;400;600;700;900&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Titillium Web', sans-serif;
        }
        .formore {
            font-weight: 900;
            background: linear-gradient(to right, #3b82f6, #1d4ed8);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        .video-card {
            opacity: 0;
            transform: translateY(20px);
            animation: fadeInUp 0.6s ease forwards;
        }
        @keyframes fadeInUp {
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        .menu {
            transition: transform 0.3s ease-in-out;
        }
        .menu.active {
            transform: translateX(0);
        }
        @media (max-width: 768px) {
            .menu {
                transform: translateX(100%);
            }
        }
        .hamburger span {
            transition: all 0.3s ease-in-out;
        }
        .hamburger.active span:nth-child(1) {
            transform: rotate(45deg) translate(5px, 5px);
        }
        .hamburger.active span:nth-child(2) {
            opacity: 0;
        }
        .hamburger.active span:nth-child(3) {
            transform: rotate(-45deg) translate(5px, -5px);
        }
    </style>
</head>
<body class="bg-gradient-to-br from-black to-blue-900 min-h-screen text-white">
    <!-- Header -->
    <header class="fixed top-0 left-0 right-0 bg-black/50 backdrop-blur-sm z-40">
        <div class="max-w-7xl mx-auto px-4 py-4">
            <nav class="flex justify-between items-center">
                <!-- Logo -->
                <a href="index.php" class="text-4xl formore z-50">ForMore</a>

                <!-- Mobile Menu Button -->
                <button class="hamburger lg:hidden flex flex-col gap-1.5 z-50" onclick="toggleMenu()">
                    <span class="block w-8 h-0.5 bg-white"></span>
                    <span class="block w-8 h-0.5 bg-white"></span>
                    <span class="block w-8 h-0.5 bg-white"></span>
                </button>

                <!-- Desktop/Mobile Menu -->
                <div class="menu fixed lg:relative top-0 right-0 h-screen lg:h-auto w-3/4 lg:w-auto 
                           bg-black/90 lg:bg-transparent backdrop-blur-sm lg:backdrop-blur-none
                           flex flex-col lg:flex-row items-center justify-center lg:justify-end gap-8 lg:gap-6
                           lg:translate-x-0">
                    <?php if(isset($_SESSION['user_id'])): ?>
                        <a href="profile.php" class="text-gray-300 hover:text-white transition-colors">
                            <?= htmlspecialchars($_SESSION['username']) ?>
                        </a>
                        <a href="upload.php" class="bg-blue-600 hover:bg-blue-700 px-6 py-2 rounded-xl transition-all">
                            Upload
                        </a>
                        <a href="logout.php" class="text-red-400 hover:text-red-300 transition-colors">
                            Logout
                        </a>
                    <?php else: ?>
                        <a href="login.php" class="text-blue-400 hover:text-blue-300 transition-colors">
                            Login
                        </a>
                        <a href="signup.php" class="bg-blue-600 hover:bg-blue-700 px-6 py-2 rounded-xl transition-all">
                            Sign Up
                        </a>
                    <?php endif; ?>
                </div>
            </nav>
        </div>
    </header>