<?php
header('Content-Type: application/json');
require_once 'db.php';

// Vérifier si l'ID est fourni
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    echo json_encode([
        'success' => false,
        'message' => 'ID de transaction non valide ou manquant'
    ]);
    exit;
}

$transactionId = (int)$_GET['id'];

try {
    $db = getDB2Connection();
    
    // Récupérer les détails de la transaction
    $stmt = $db->prepare("
        SELECT id, type, amount, category, date, description, created_at, updated_at
        FROM finance_transactions
        WHERE id = :id
    ");
    
    $stmt->bindParam(':id', $transactionId);
    $stmt->execute();
    
    $transaction = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$transaction) {
        echo json_encode([
            'success' => false,
            'message' => 'Transaction non trouvée'
        ]);
        exit;
    }
    
    // Formater les valeurs si nécessaire
    $transaction['amount'] = (float)$transaction['amount'];
    $transaction['date'] = date('Y-m-d', strtotime($transaction['date']));
    
    echo json_encode([
        'success' => true,
        'transaction' => $transaction
    ]);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erreur de base de données: ' . $e->getMessage()
    ]);
}
?>