<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}
require_once 'db.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $content = $_POST['content'] ?? '';
    $urgency = $_POST['urgency'] ?? 'none';
    $location = $_POST['location'] ?? 'Non spécifié';
    $timezone = $_POST['timezone'] ?? 'UTC';

    $database = new Database();
    $conn = $database->getConnection();

    $stmt = $conn->prepare("INSERT INTO feeds 
        (user_id, content, urgency, location, timezone, created_at) 
        VALUES (:user_id, :content, :urgency, :location, :timezone, NOW())");
    
    $stmt->bindParam(':user_id', $_SESSION['user_id']);
    $stmt->bindParam(':content', $content);
    $stmt->bindParam(':urgency', $urgency);
    $stmt->bindParam(':location', $location);
    $stmt->bindParam(':timezone', $timezone);
    
    $stmt->execute();

    header("Location: dashboard.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Peerkinton - Créer un Feed</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Poppins', sans-serif; }
    </style>
</head>
<body class="bg-black text-white min-h-screen flex items-center justify-center">
    <div class="w-full max-w-md p-6">
        <h1 class="text-2xl mb-6 text-center">Créer un Feed</h1>
        <form method="post" id="feedForm" class="bg-gray-900 p-6 rounded">
            <textarea name="content" required 
                class="w-full bg-black text-white p-3 rounded mb-4" 
                placeholder="Contenu de votre feed"></textarea>
            
            <select name="urgency" 
                class="w-full bg-black text-white p-3 rounded mb-4">
                <option value="none">Aucun</option>
                <option value="low">Faible</option>
                <option value="high">Haut</option>
            </select>

            <input type="hidden" name="location" id="location">
            <input type="hidden" name="timezone" id="timezone">
            
            <button type="submit" 
                class="w-full bg-white text-black p-3 rounded hover:bg-gray-200">
                Envoyer
            </button>
        </form>
        <div class="mt-4 text-center">
            <a href="dashboard.php" class="text-white underline">Retour</a>
        </div>
    </div>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        if ("geolocation" in navigator) {
            navigator.geolocation.getCurrentPosition(function(position) {
                document.getElementById('location').value = 
                    `${position.coords.latitude}, ${position.coords.longitude}`;
                document.getElementById('timezone').value = 
                    Intl.DateTimeFormat().resolvedOptions().timeZone;
            });
        }
    });
    </script>
</body>
</html>