<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Support - Imators</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.1.2/dist/tailwind.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap');
        body {
            font-family: 'Space Grotesk', sans-serif;
            background-color: #000000;
            color: #FFFFFF;
        }
        
        header {
            background-color: rgba(0, 0, 0, 0.8);
            transition: background-color 0.5s;
        }
        
        .separator {
            height: 1px;
            background-color: #333;
            width: 100%;
            margin: 30px 0;
        }
    </style>
</head>
<body>
    <?php include 'src/header.php'; ?>

    <div class="w-full h-64 md:h-80 lg:h-96 overflow-hidden">
        <img src="banner_color.png" alt="Support Banner" class="w-full h-full object-cover">
    </div>
    
    <div class="container px-4 mx-auto py-12">
        <h1 class="text-4xl lg:text-5xl font-light mb-6">Support.</h1>
        <p class="text-xl text-gray-400 mb-12">This page contains everything you need to contact us at the right address.</p>
        
        <div class="separator"></div>
        
        <div class="py-8 flex flex-wrap items-center">
            <div class="w-full md:w-1/4 mb-6 md:mb-0">
                <div class="flex items-center">
                    <i class="fas fa-tools text-xl mr-4"></i>
                    <h3 class="text-xl font-bold">Hardware Support</h3>
                </div>
            </div>
            <div class="w-full md:w-2/4 mb-6 md:mb-0">
                <p class="text-gray-400">Technical issues with any of our products purchased from a Cergies Store by Imators.</p>
                <p class="text-sm text-gray-500 mt-2"><i class="fas fa-info-circle"></i> Account required</p>
            </div>
            <div class="w-full md:w-1/4 text-right">
                <a href="https://idsma.imators.com" class="inline-block bg-white text-black px-6 py-2 rounded-lg hover:bg-gray-200">Access Support Portal</a>
            </div>
        </div>
        
        <div class="separator"></div>
        
        <div class="py-8 flex flex-wrap items-center">
            <div class="w-full md:w-1/4 mb-6 md:mb-0">
                <div class="flex items-center">
                    <i class="fas fa-newspaper text-xl mr-4"></i>
                    <h3 class="text-xl font-bold">Press Inquiries</h3>
                </div>
            </div>
            <div class="w-full md:w-2/4 mb-6 md:mb-0">
                <p class="text-gray-400">For interview requests or article placement, contact our press team directly.</p>
                <p class="text-sm text-gray-500 mt-2"><i class="fas fa-envelope"></i> press@imators.com</p>
            </div>
            <div class="w-full md:w-1/4 text-right">
                <a href="mailto:press@imators.com" class="inline-block bg-white text-black px-6 py-2 rounded-lg hover:bg-gray-200">Contact Press Team</a>
            </div>
        </div>
        
        <div class="separator"></div>
        
        <div class="py-8 flex flex-wrap items-center">
            <div class="w-full md:w-1/4 mb-6 md:mb-0">
                <div class="flex items-center">
                    <i class="fas fa-network-wired text-xl mr-4"></i>
                    <h3 class="text-xl font-bold">Technical Support</h3>
                </div>
            </div>
            <div class="w-full md:w-2/4 mb-6 md:mb-0">
                <p class="text-gray-400">For network issues or service unavailability due to various causes.</p>
                <p class="text-sm text-gray-500 mt-2"><i class="fas fa-info-circle"></i> Account required</p>
            </div>
            <div class="w-full md:w-1/4 text-right">
                <a href="https://idsma.imators.com" class="inline-block bg-white text-black px-6 py-2 rounded-lg hover:bg-gray-200">Access Support Portal</a>
            </div>
        </div>
        
        <div class="separator"></div>
        
        <div class="py-8 flex flex-wrap items-center">
            <div class="w-full md:w-1/4 mb-6 md:mb-0">
                <div class="flex items-center">
                    <i class="fas fa-comments text-xl mr-4"></i>
                    <h3 class="text-xl font-bold">Community Forum</h3>
                </div>
            </div>
            <div class="w-full md:w-2/4 mb-6 md:mb-0">
                <p class="text-gray-400">Join our community forum to find answers, share experiences, and connect with other Imators users.</p>
            </div>
            <div class="w-full md:w-1/4 text-right">
                <a href="/forum" class="inline-block bg-white text-black px-6 py-2 rounded-lg hover:bg-gray-200">Visit Forum</a>
            </div>
        </div>
        
        <div class="separator"></div>
        
        <div class="py-12">
            <h2 class="text-2xl font-bold mb-8">Need Quick Help?</h2>
            
            <div class="flex flex-wrap">
                <div class="w-full md:w-1/2 mb-8 md:mb-0">
                    <div class="flex">
                        <i class="fas fa-book text-xl mr-4 pt-1"></i>
                        <div>
                            <h3 class="text-lg font-semibold mb-2">Knowledge Base</h3>
                            <p class="text-gray-400 mb-2">Browse our extensive knowledge base for guides and solutions to common issues.</p>
                            <a href="/kb" class="text-white hover:text-gray-300">Explore Knowledge Base →</a>
                        </div>
                    </div>
                </div>
                
                <div class="w-full md:w-1/2">
                    <div class="flex">
                        <i class="fas fa-download text-xl mr-4 pt-1"></i>
                        <div>
                            <h3 class="text-lg font-semibold mb-2">Downloads</h3>
                            <p class="text-gray-400 mb-2">Access manuals, software updates, and drivers for Imators products.</p>
                            <a href="/downloads" class="text-white hover:text-gray-300">Go to Downloads →</a>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="mt-10 text-center">
                <p class="text-gray-400 mb-4">Still can't find what you're looking for?</p>
                <a href="/contact" class="inline-block bg-white text-black px-6 py-2 rounded-lg hover:bg-gray-200">Contact Us</a>
            </div>
        </div>
        
        <div class="separator"></div>
        
        <div class="py-8">
            <h2 class="text-2xl font-bold mb-6">Support Hours</h2>
            <div class="flex">
                <i class="far fa-clock text-xl mr-4 pt-1"></i>
                <div>
                    <p>Everyday : 9:00 AM - 6:00 PM GMT</p>
                    <p class="text-gray-400 text-sm mt-2">Our support team is available during these hours. For urgent issues outside of these hours, please use our ticket system, and we'll respond as soon as possible.</p>
                </div>
            </div>
        </div>
    </div>

    <footer class="bg-black text-white border-t border-gray-800">
        <div class="container px-4 mx-auto py-10">
            <div class="flex flex-wrap">
                <div class="w-full md:w-1/3 mb-8 md:mb-0">
                    <h5 class="text-xs uppercase font-medium mb-4">Follow Us</h5>
                    <a href="https://instagram.com/itsimators" class="text-sm font-medium hover:text-gray-100">Instagram</a>
                </div>
                
                <div class="w-full md:w-1/3 mb-8 md:mb-0">
                    <h5 class="text-xs uppercase font-medium mb-4">Discover</h5>
                    <ul class="space-y-2">
                        <li><a href="/privacy" class="text-sm hover:text-gray-100">Privacy Policy</a></li>
                        <li><a href="/terms-of-use" class="text-sm hover:text-gray-100">Terms of Use</a></li>
                        <li><a href="/" class="text-sm hover:text-gray-100">Home</a></li>
                        <li><a href="/about-us" class="text-sm hover:text-gray-100">About Us</a></li>
                        <li><a href="/contact-us" class="text-sm hover:text-gray-100">Contact Us</a></li>
                    </ul>
                </div>
                
                <div class="w-full md:w-1/3">
                    <h5 class="text-xs uppercase font-medium mb-4">Possible reality</h5>
                    <p class="text-sm">All images, videos, and content on this site are the property of Imators.</p>
                </div>
            </div>
            
            <div class="separator"></div>
            
            <div class="text-center">
                <p class="text-sm mb-2">&copy; 2025 Imators. All rights reserved.</p>
                <p class="text-xs">Imators is a registered LLC (Limited Liability Company). All our products, whether technologically physical or simply online, are subject to our rules, which you can access.</p>
            </div>
        </div>
    </footer>

    <script>
        document.getElementById('mobile-menu-button')?.addEventListener('click', function() {
            document.getElementById('mobile-menu')?.classList.remove('hidden');
        });
        
        document.getElementById('mobile-menu-close')?.addEventListener('click', function() {
            document.getElementById('mobile-menu')?.classList.add('hidden');
        });
    </script>
</body>
</html>