<?php
$transparent_header = isset($transparent_header) ? $transparent_header : false;
?>

<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imators</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap');

        body {
            font-family: 'Poppins', sans-serif;
            color: #fff;
            background-color: #000;
            margin: 0;
        }

        .header {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            background-color: rgba(0, 0, 0, 0.95);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            height: 70px;
            z-index: 100;
            transition: all 0.3s ease;
        }

        @media (min-width: 1024px) {
            .header {
                height: 90px;
            }
        }

        .header-transparent {
            background-color: transparent;
            border-bottom: none;
        }

        .header-transparent.scrolled {
            background-color: rgba(0, 0, 0, 0.95);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .header-container {
            max-width: 1200px;
            margin: 0 auto;
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 20px;
        }

        .logo img {
            height: 28px;
            transition: all 0.3s ease;
        }

        @media (min-width: 1024px) {
            .logo img {
                height: 36px;
            }
        }
        
        /* Navigation Menu */
        .nav-menu {
            display: flex;
            gap: 30px;
        }

        @media (max-width: 1023px) {
            .nav-menu {
                display: none;
            }
        }

        .nav-item {
            position: relative;
            padding: 10px;
            cursor: pointer;
            font-weight: 400;
        }

        .nav-item:hover {
            color: rgba(255, 255, 255, 0.7);
        }

        /* Fullscreen Category Panel */
        .category-panel {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100vh;
            background-color: rgba(0, 0, 0, 0.95);
            backdrop-filter: blur(10px);
            z-index: 200;
            display: flex;
            flex-direction: column;
            opacity: 0;
            visibility: hidden;
            transition: opacity 0.3s ease, visibility 0.3s ease;
            overflow-y: auto;
        }

        .category-panel.active {
            opacity: 1;
            visibility: visible;
        }

        .panel-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 20px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            position: sticky;
            top: 0;
            background-color: rgba(0, 0, 0, 0.95);
            z-index: 2;
        }

        .panel-title {
            font-size: 1.5rem;
            font-weight: 600;
        }

        .close-panel {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            cursor: pointer;
            transition: background 0.2s ease;
        }

        .close-panel:hover {
            background: rgba(255, 255, 255, 0.2);
        }

        .panel-content {
            display: flex;
            flex: 1;
            padding: 40px 20px;
        }

        @media (max-width: 767px) {
            .panel-content {
                flex-direction: column;
            }
        }

        .links-section {
            flex: 1;
        }

        .links-list {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .links-list li {
            margin-bottom: 20px;
        }

        .category-link {
            display: flex;
            align-items: center;
            padding: 15px;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 10px;
            transition: all 0.2s ease;
        }

        .category-link:hover {
            background: rgba(255, 255, 255, 0.1);
            transform: translateY(-3px);
        }

        .link-icon {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            border-radius: 8px;
            margin-right: 15px;
            background: rgba(255, 255, 255, 0.1);
        }

        .link-content {
            flex: 1;
        }

        .link-title {
            font-weight: 500;
            margin-bottom: 3px;
        }

        .link-desc {
            font-size: 0.8rem;
            opacity: 0.7;
        }

        .stories-section {
            width: 300px;
            margin-left: 40px;
            padding-left: 40px;
            border-left: 1px solid rgba(255, 255, 255, 0.1);
        }

        @media (max-width: 767px) {
            .stories-section {
                width: 100%;
                margin-left: 0;
                padding-left: 0;
                border-left: none;
                margin-top: 40px;
                padding-top: 40px;
                border-top: 1px solid rgba(255, 255, 255, 0.1);
            }
        }

        .stories-title {
            font-size: 1.2rem;
            font-weight: 500;
            margin-bottom: 20px;
        }

        .stories-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 20px;
        }

        .story-card {
            aspect-ratio: 1/1;
            border-radius: 10px;
            overflow: hidden;
            position: relative;
            background-size: cover;
            background-position: center;
            transition: all 0.3s ease;
        }

        .story-card:hover {
            transform: scale(1.05);
        }

        .story-content {
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            padding: 15px;
            background: linear-gradient(transparent, rgba(0, 0, 0, 0.8));
        }

        .story-title {
            font-size: 0.9rem;
            font-weight: 600;
            margin-bottom: 5px;
        }

        .story-desc {
            font-size: 0.8rem;
            opacity: 0.8;
        }

        .account-btn {
            padding: 8px 16px;
            background: #fff;
            color: #000;
            border-radius: 8px;
            font-weight: 500;
            transition: all 0.2s ease;
        }

        @media (max-width: 1023px) {
            .account-btn {
                display: none;
            }
        }

        .account-btn:hover {
            opacity: 0.9;
        }

        /* Mobile Menu Toggle */
        .menu-toggle {
            width: 40px;
            height: 40px;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            display: none;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            position: relative;
        }

        @media (max-width: 1023px) {
            .menu-toggle {
                display: flex;
            }
        }

        .menu-toggle span {
            display: block;
            width: 18px;
            height: 2px;
            background: #fff;
            position: relative;
            transition: all 0.3s ease;
        }

        .menu-toggle span::before,
        .menu-toggle span::after {
            content: '';
            position: absolute;
            width: 18px;
            height: 2px;
            background: #fff;
            transition: all 0.3s ease;
        }

        .menu-toggle span::before {
            top: -6px;
        }

        .menu-toggle span::after {
            top: 6px;
        }

        .menu-toggle.active span {
            background: transparent;
        }

        .menu-toggle.active span::before {
            transform: rotate(45deg);
            top: 0;
        }

        .menu-toggle.active span::after {
            transform: rotate(-45deg);
            top: 0;
        }

        /* Mobile Menu */
        .mobile-menu {
            position: fixed;
            top: 70px;
            left: 0;
            width: 100%;
            height: calc(100vh - 70px);
            background: #000;
            z-index: 99;
            transform: translateY(-100%);
            transition: all 0.3s ease;
            visibility: hidden;
            opacity: 0;
            overflow-y: auto;
        }

        .mobile-menu.active {
            transform: translateY(0);
            visibility: visible;
            opacity: 1;
        }

        .mobile-header {
            padding: 20px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .mobile-title {
            font-size: 1.2rem;
            font-weight: 500;
        }

        .mobile-stories {
            padding: 20px;
        }

        .mobile-stories-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
        }

        .mobile-story {
            aspect-ratio: 1/1;
            border-radius: 12px;
            overflow: hidden;
            position: relative;
        }

        .mobile-story-content {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            padding: 15px;
            display: flex;
            flex-direction: column;
            justify-content: flex-end;
            background: linear-gradient(transparent 50%, rgba(0, 0, 0, 0.8));
        }

        .mobile-story-title {
            font-size: 1rem;
            font-weight: 600;
            margin-bottom: 5px;
        }

        .mobile-story-desc {
            font-size: 0.75rem;
            opacity: 0.8;
            margin-bottom: 10px;
        }

        .mobile-story-btn {
            align-self: flex-start;
            padding: 6px 12px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 20px;
            font-size: 0.75rem;
            transition: all 0.2s ease;
        }

        .mobile-nav {
            padding: 20px;
        }

        .mobile-nav-item {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 15px;
            margin-bottom: 15px;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 10px;
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .mobile-nav-item:active {
            background: rgba(255, 255, 255, 0.1);
        }
    </style>
</head>
<body class="h-full">
    <!-- Header -->
    <header class="header <?php echo $transparent_header ? 'header-transparent' : ''; ?>">
        <div class="header-container">
            <div class="logo">
                <a href="/">
                    <img src="https://cdn.imators.com/logo.png" alt="Imators">
                </a>
            </div>

            <nav class="nav-menu">
                <div class="nav-item" data-category="products">Products</div>
                <div class="nav-item" data-category="developer">Developer Tools</div>
                <div class="nav-item" data-category="company">Company</div>
            </nav>

            <div class="flex items-center space-x-4">
                <a href="https://idsma.imators.com" class="account-btn">Imators Account</a>
                <div class="menu-toggle">
                    <span></span>
                </div>
            </div>
        </div>
    </header>

    <!-- Products Category Panel -->
    <div class="category-panel" id="products-panel">
        <div class="panel-header">
            <h2 class="panel-title">Products</h2>
            <button class="close-panel">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M18 6L6 18M6 6l12 12" />
                </svg>
            </button>
        </div>
        <div class="panel-content">
            <div class="links-section">
                <ul class="links-list">
                    <li>
                        <a href="https://academ.my" class="category-link">
                            <div class="link-icon" style="color: #8B5CF6;">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253" />
                                </svg>
                            </div>
                            <div class="link-content">
                                <div class="link-title">Academ</div>
                                <div class="link-desc">Say goodbye to homework overflow</div>
                            </div>
                        </a>
                    </li>
                    <li>
                        <a href="/progm" class="category-link">
                            <div class="link-icon" style="color: #F59E0B;">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2" />
                                </svg>
                            </div>
                            <div class="link-content">
                                <div class="link-title">Progm</div>
                                <div class="link-desc">Program management simplified</div>
                            </div>
                        </a>
                    </li>
                    <li>
                        <a href="https://ohmypanel.com" class="category-link">
                            <div class="link-icon" style="color: #10B981;">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
                                </svg>
                            </div>
                            <div class="link-content">
                                <div class="link-title">OhMyPanel</div>
                                <div class="link-desc">Quick & easy shopping</div>
                            </div>
                        </a>
                    </li>
                    <li>
                        <a href="https://owtfitt.com" class="category-link">
                            <div class="link-icon" style="color: #EF4444;">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                                </svg>
                            </div>
                            <div class="link-content">
                                <div class="link-title">Owtfitt</div>
                                <div class="link-desc">Premium fashion outfits</div>
                            </div>
                        </a>
                    </li>
                    <li>
                        <a href="https://imators.systems/traffic" class="category-link">
                            <div class="link-icon" style="color: #3B82F6;">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3m-6 3V7m6 10l4.553 2.276A1 1 0 0021 18.382V7.618a1 1 0 00-.553-.894L15 4m0 13V4" />
                                </svg>
                            </div>
                            <div class="link-content">
                                <div class="link-title">TrafficLight</div>
                                <div class="link-desc">Intelligent traffic management</div>
                            </div>
                        </a>
                    </li>
                </ul>
            </div>
            <div class="stories-section">
                <h3 class="stories-title">Stories</h3>
                <div class="stories-grid">
                    <div class="story-card" style="background-image: url('https://cdn.imators.com/story1.jpg')">
                        <div class="story-content">
                            <h5 class="story-title">Academ Success</h5>
                            <p class="story-desc">See how Academ transforms education</p>
                        </div>
                    </div>
                    <div class="story-card" style="background-image: url('https://cdn.imators.com/story2.jpg')">
                        <div class="story-content">
                            <h5 class="story-title">TrafficLight Impact</h5>
                            <p class="story-desc">Smart traffic solutions</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Developer Tools Category Panel -->
    <div class="category-panel" id="developer-panel">
        <div class="panel-header">
            <h2 class="panel-title">Developer Tools</h2>
            <button class="close-panel">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M18 6L6 18M6 6l12 12" />
                </svg>
            </button>
        </div>
        <div class="panel-content">
            <div class="links-section">
                <ul class="links-list">
                    <li>
                        <a href="https://imators.systems" class="category-link">
                            <div class="link-icon" style="color: #7C3AED;">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M10 20l4-16m4 4l4 4-4 4M6 16l-4-4 4-4" />
                                </svg>
                            </div>
                            <div class="link-content">
                                <div class="link-title">Imators Systems</div>
                                <div class="link-desc">Enterprise-grade systems</div>
                            </div>
                        </a>
                    </li>
                    <li>
                        <a href="https://developer.imators.com" class="category-link">
                            <div class="link-icon" style="color: #2563EB;">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M8 9l3 3-3 3m5 0h3M5 20h14a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                </svg>
                            </div>
                            <div class="link-content">
                                <div class="link-title">Imators Developer</div>
                                <div class="link-desc">Developer resources & APIs</div>
                            </div>
                        </a>
                    </li>
                    <li>
                        <a href="https://imators.systems/traffic" class="category-link">
                            <div class="link-icon" style="color: #3B82F6;">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3m-6 3V7m6 10l4.553 2.276A1 1 0 0021 18.382V7.618a1 1 0 00-.553-.894L15 4m0 13V4" />
                                </svg>
                            </div>
                            <div class="link-content">
                                <div class="link-title">TrafficLight</div>
                                <div class="link-desc">Traffic management API</div>
                            </div>
                        </a>
                    </li>
                </ul>
            </div>
            <div class="stories-section">
                <h3 class="stories-title">Stories</h3>
                <div class="stories-grid">
                    <div class="story-card" style="background-image: url('https://cdn.imators.com/dev1.jpg')">
                        <div class="story-content">
                            <h5 class="story-title">Developer Journey</h5>
                            <p class="story-desc">Building with Imators tools</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Company Category Panel -->
    <div class="category-panel" id="company-panel">
        <div class="panel-header">
            <h2 class="panel-title">Company</h2>
            <button class="close-panel">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M18 6L6 18M6 6l12 12" />
                </svg>
            </button>
        </div>
        <div class="panel-content">
            <div class="links-section">
                <ul class="links-list">
                    <li>
                        <a href="/support" class="category-link">
                            <div class="link-icon" style="color: #10B981;">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z" />
                                </svg>
                            </div>
                            <div class="link-content">
                                <div class="link-title">Support</div>
                                <div class="link-desc">Get help with our products</div>
                            </div>
                        </a>
                    </li>
                    <li>
                        <a href="/contact-us" class="category-link">
                            <div class="link-icon" style="color: #EF4444;">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                                </svg>
                            </div>
                            <div class="link-content">
                                <div class="link-title">Contact us</div>
                                <div class="link-desc">Reach out to our team</div>
                            </div>
                        </a>
                    </li>
                    <li>
                        <a href="/about-us" class="category-link">
                            <div class="link-icon" style="color: #F59E0B;">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                                </svg>
                            </div>
                            <div class="link-content">
                                <div class="link-title">About Imators</div>
                                <div class="link-desc">Our mission and vision</div>
                            </div>
                        </a>
                    </li>
                </ul>
            </div>
            <div class="stories-section">
                <h3 class="stories-title">Stories</h3>
                <div class="stories-grid">
                    <div class="story-card" style="background-image: url('https://cdn.imators.com/company1.jpg')">
                        <div class="story-content">
                            <h5 class="story-title">Our Journey</h5>
                            <p class="story-desc">The story of Imators</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Mobile Menu -->
    <div class="mobile-menu">
        <div class="mobile-header">
            <h2 class="mobile-title">Nice to see you.</h2>
        </div>

        <div class="mobile-stories">
            <div class="mobile-stories-grid">
                <div class="mobile-story" style="background-color: #8B5CF6;">
                    <div class="mobile-story-content">
                        <h3 class="mobile-story-title">Academ</h3>
                        <p class="mobile-story-desc">Saying goodbye to homework overflow</p>
                        <a href="https://academ.my" class="mobile-story-btn">Learn more</a>
                    </div>
                </div>
                <div class="mobile-story" style="background-color: #FBBF24;">
                    <div class="mobile-story-content">
                        <h3 class="mobile-story-title">OhMyPanel</h3>
                        <p class="mobile-story-desc">Quick & easy shopping</p>
                        <a href="https://ohmypanel.com" class="mobile-story-btn">Learn morea>
                    </div>
                </div>
                <div class="mobile-story" style="background-color: #404040;">
                    <div class="mobile-story-content">
                        <h3 class="mobile-story-title">Imators Account</h3>
                        <p class="mobile-story-desc">Global benefits</p>
                        <a href="https://idsma.imators.com" class="mobile-story-btn">Explorer</a>
                    </div>
                </div>
                <div class="mobile-story" style="background-color: #3B82F6;">
                    <div class="mobile-story-content">
                        <h3 class="mobile-story-title">TrafficLight</h3>
                        <p class="mobile-story-desc">Traffic management</p>
                        <a href="https://imators.systems/traffic" class="mobile-story-btn">Discover</a>
                    </div>
                </div>
            </div>
        </div>

        <div class="mobile-nav">
            <div class="mobile-nav-item" data-category="products">
                <span>Products</span>
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 18l6-6-6-6"/>
                </svg>
            </div>
            <div class="mobile-nav-item" data-category="developer">
                <span>Developer Tools</span>
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 18l6-6-6-6"/>
                </svg>
            </div>
            <div class="mobile-nav-item" data-category="company">
                <span>Company</span>
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 18l6-6-6-6"/>
                </svg>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Elements
            const header = document.querySelector('.header');
            const menuToggle = document.querySelector('.menu-toggle');
            const mobileMenu = document.querySelector('.mobile-menu');
            const navItems = document.querySelectorAll('.nav-item');
            const mobileNavItems = document.querySelectorAll('.mobile-nav-item');
            const categoryPanels = document.querySelectorAll('.category-panel');
            const closePanelButtons = document.querySelectorAll('.close-panel');
            
            let lastScrollTop = 0;
            let scrollTimeout;
            let activeCategoryPanel = null;
            
            // Open category panel on click (both desktop and mobile)
            function openCategoryPanel(category) {
                const panel = document.getElementById(category + '-panel');
                
                if (panel) {
                    // Close any open panel first
                    if (activeCategoryPanel && activeCategoryPanel !== panel) {
                        activeCategoryPanel.classList.remove('active');
                    }
                    
                    panel.classList.add('active');
                    activeCategoryPanel = panel;
                    document.body.style.overflow = 'hidden'; // Prevent scrolling
                    
                    // Close mobile menu if open
                    if (mobileMenu.classList.contains('active')) {
                        mobileMenu.classList.remove('active');
                        menuToggle.classList.remove('active');
                    }
                }
            }
            
            // Close category panel
            function closeCategoryPanel() {
                if (activeCategoryPanel) {
                    activeCategoryPanel.classList.remove('active');
                    activeCategoryPanel = null;
                    document.body.style.overflow = ''; // Enable scrolling
                }
            }
            
            // Desktop navigation
            navItems.forEach(item => {
                item.addEventListener('click', function() {
                    const category = this.getAttribute('data-category');
                    openCategoryPanel(category);
                });
            });
            
            // Mobile navigation
            mobileNavItems.forEach(item => {
                item.addEventListener('click', function() {
                    const category = this.getAttribute('data-category');
                    openCategoryPanel(category);
                });
            });
            
            // Close panel buttons
            closePanelButtons.forEach(button => {
                button.addEventListener('click', closeCategoryPanel);
            });
            
            // Mobile menu toggle
            menuToggle.addEventListener('click', function() {
                this.classList.toggle('active');
                mobileMenu.classList.toggle('active');
                
                if (mobileMenu.classList.contains('active')) {
                    document.body.style.overflow = 'hidden'; // Prevent scrolling
                } else {
                    document.body.style.overflow = ''; // Enable scrolling
                }
            });
            
            // Close with ESC key
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape') {
                    // Close category panel if open
                    if (activeCategoryPanel) {
                        closeCategoryPanel();
                    }
                    
                    // Close mobile menu if open
                    if (mobileMenu.classList.contains('active')) {
                        mobileMenu.classList.remove('active');
                        menuToggle.classList.remove('active');
                        document.body.style.overflow = '';
                    }
                }
            });
            
            // Handle scroll for transparent header
            window.addEventListener('scroll', function() {
                clearTimeout(scrollTimeout);
                const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
                
                if (header.classList.contains('header-transparent')) {
                    if (scrollTop > 0) {
                        header.classList.add('scrolled');
                    } else {
                        header.classList.remove('scrolled');
                    }
                }
                
                // Hide/show header on scroll
                if (!mobileMenu.classList.contains('active') && !activeCategoryPanel && Math.abs(scrollTop - lastScrollTop) > 50) {
                    header.style.transform = scrollTop > lastScrollTop && scrollTop > header.offsetHeight ? 
                        'translateY(-100%)' : 'translateY(0)';
                    lastScrollTop = scrollTop;
                }
                
                scrollTimeout = setTimeout(() => {
                    header.style.transform = 'translateY(0)';
                }, 1000);
            });
            
            // Story card clicks
            const storyCards = document.querySelectorAll('.story-card');
            storyCards.forEach(card => {
                card.addEventListener('click', function() {
                    window.location.href = '#story-detail';
                });
            });
            
            // Mobile story clicks
            const mobileStories = document.querySelectorAll('.mobile-story');
            mobileStories.forEach(story => {
                story.addEventListener('click', function() {
                    const link = this.querySelector('a');
                    if (link) {
                        window.location.href = link.getAttribute('href');
                    }
                });
            });
        });
    </script>
</body>
</html>