<?php
$transparent_header = isset($transparent_header) ? $transparent_header : false;
?>

<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Header - Imators</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Swiper/9.3.2/swiper-bundle.min.css" />
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap');

        body {
            font-family: 'Poppins', sans-serif;
            color: #FFFFFF;
            background-color: #000000;
        }

        .header {
            background-color: rgba(0, 0, 0, 0.95);
            backdrop-filter: blur(10px);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            z-index: 1002;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            position: fixed;
            width: 100%;
            top: 0;
            height: 70px;
        }

        @media (min-width: 1024px) {
            .header {
                height: 90px;
            }
        }

        .header-transparent {
            background-color: transparent;
            backdrop-filter: none;
            border-bottom: none;
        }

        .header-transparent.scrolled {
            background-color: rgba(0, 0, 0, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .desktop-menu {
            display: none;
        }

        @media (min-width: 1024px) {
            .desktop-menu {
                display: flex;
            }

            .desktop-menu-item {
                position: relative;
                padding: 1rem;
                cursor: pointer;
                color: #FFFFFF;
                font-weight: 350;
                transition: all 0.3s ease;
                border-radius: 12px;
            }

            .desktop-menu-item:hover {
                color: rgba(255, 255, 255, 0.7);
                background: rgba(255, 255, 255, 0.1);
            }
        }

        .desktop-submenu {
            position: fixed;
            top: 90px;
            left: 0;
            width: 100%;
            background-color: rgba(0, 0, 0, 0.9);
            backdrop-filter: blur(15px);
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            padding: 30px 0;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.3);
            z-index: 1001;
        }

        .desktop-menu-item:hover .desktop-submenu {
            opacity: 1;
            visibility: visible;
        }

        .submenu-container {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            padding: 0 20px;
        }

        .submenu-links {
            flex: 1;
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(220px, 1fr));
            gap: 20px;
        }

        .submenu-link {
            display: block;
            padding: 16px;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 16px;
            transition: all 0.3s ease;
        }

        .submenu-link:hover {
            background: rgba(255, 255, 255, 0.1);
            transform: translateY(-3px);
            border-color: rgba(255, 255, 255, 0.2);
        }

        .submenu-title {
            font-weight: 600;
            font-size: 1rem;
            margin-bottom: 5px;
        }

        .submenu-desc {
            font-size: 0.85rem;
            opacity: 0.7;
        }

        .submenu-stories {
            width: 350px;
            margin-left: 30px;
            padding-left: 30px;
            border-left: 1px solid rgba(255, 255, 255, 0.1);
        }

        .stories-title {
            font-size: 1.2rem;
            font-weight: 600;
            margin-bottom: 20px;
        }

        .stories-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 20px;
        }

        .story-item {
            aspect-ratio: 1/1;
            border-radius: 16px;
            overflow: hidden;
            position: relative;
            background-size: cover;
            background-position: center;
            transition: all 0.3s ease;
        }

        .story-item:hover {
            transform: scale(1.05);
        }

        .story-content {
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            padding: 20px;
            background: linear-gradient(transparent, rgba(0, 0, 0, 0.8));
        }

        .story-title {
            font-size: 1rem;
            font-weight: 600;
            margin-bottom: 5px;
        }

        .story-desc {
            font-size: 0.85rem;
            opacity: 0.8;
        }

        .mobile-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            backdrop-filter: blur(5px);
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
            z-index: 1000;
        }

        .mobile-overlay.active {
            opacity: 1;
            visibility: visible;
        }

        .mobile-menu {
            position: fixed;
            top: 70px;
            left: 0;
            width: 100%;
            height: calc(100vh - 70px);
            background: #000000;
            transform: translateY(-100%);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            z-index: 1001;
            opacity: 0;
            visibility: hidden;
            overflow-y: auto;
            -webkit-overflow-scrolling: touch;
        }

        .mobile-menu.active {
            transform: translateY(0);
            opacity: 1;
            visibility: visible;
        }

        .mobile-menu-header {
            position: sticky;
            top: 0;
            background: #000000;
            z-index: 2;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 20px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
        }

        .menu-title {
            font-size: 1.25rem;
            font-weight: 600;
        }

        .stories-grid-mobile {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
            padding: 20px;
        }

        .story-card {
            aspect-ratio: 1/1;
            border-radius: 16px;
            overflow: hidden;
            position: relative;
            transition: all 0.3s ease;
        }

        .story-card-inner {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            display: flex;
            flex-direction: column;
            justify-content: flex-end;
            padding: 20px;
            background: linear-gradient(transparent 50%, rgba(0, 0, 0, 0.7));
        }

        .story-card-title {
            font-size: 1.1rem;
            font-weight: 600;
            margin-bottom: 5px;
        }

        .story-card-desc {
            font-size: 0.85rem;
            opacity: 0.8;
            margin-bottom: 10px;
        }

        .story-card-link {
            align-self: flex-start;
            padding: 6px 12px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 30px;
            font-size: 0.75rem;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .mobile-menu-items {
            padding: 20px;
            padding-bottom: 40px;
        }

        .mobile-menu-item {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 16px;
            margin-bottom: 12px;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 16px;
            cursor: pointer;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .mobile-menu-item:active {
            transform: scale(0.98);
            background: rgba(255, 255, 255, 0.12);
        }

        .mobile-submenu-panel {
            position: fixed;
            top: 70px;
            left: 0;
            width: 100%;
            height: calc(100vh - 70px);
            background: #000000;
            z-index: 1002;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            transform: translateX(100%);
            opacity: 0;
            visibility: hidden;
            overflow-y: auto;
        }

        .mobile-submenu-panel.active {
            transform: translateX(0);
            opacity: 1;
            visibility: visible;
        }

        .mobile-submenu-header {
            position: sticky;
            top: 0;
            background: #000000;
            z-index: 2;
            display: flex;
            align-items: center;
            padding: 20px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            gap: 15px;
            backdrop-filter: blur(10px);
        }

        .mobile-submenu-content {
            padding: 20px;
            padding-bottom: 40px;
        }

        .mobile-submenu-link {
            display: block;
            padding: 16px;
            margin-bottom: 12px;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 16px;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
        }

        .mobile-submenu-link:active {
            transform: scale(0.98);
            background: rgba(255, 255, 255, 0.12);
        }

        .mobile-link-title {
            font-weight: 500;
            margin-bottom: 4px;
        }

        .mobile-link-desc {
            font-size: 0.75rem;
            opacity: 0.7;
        }

        .hamburger {
            width: 40px;
            height: 40px;
            position: relative;
            cursor: pointer;
            z-index: 1003;
            display: none;
            align-items: center;
            justify-content: center;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
        }

        @media (max-width: 1023px) {
            .hamburger {
                display: flex;
            }
        }

        .hamburger span {
            display: block;
            position: absolute;
            height: 2px;
            width: 20px;
            background: #FFFFFF;
            border-radius: 2px;
            opacity: 1;
            left: 10px;
            transition: transform 0.3s ease-in-out;
        }

        .hamburger span:nth-child(1) {
            top: 14px;
            transform-origin: center;
        }

        .hamburger span:nth-child(2) {
            top: 24px;
            transform-origin: center;
        }

        .hamburger.active span:nth-child(1) {
            transform: translateY(5px) rotate(45deg);
        }

        .hamburger.active span:nth-child(2) {
            transform: translateY(-5px) rotate(-45deg);
        }

        .close-button {
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .imators-account-btn {
            display: inline-flex;
            align-items: center;
            padding: 0.5rem 1rem;
            font-weight: 500;
            color: #000000;
            background-color: #FFFFFF;
            border-radius: 12px;
            transition: all 0.2s ease;
        }

        .imators-account-btn:hover {
            opacity: 0.9;
        }

        .header-content {
            height: 100%;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .logo-container {
            display: flex;
            align-items: center;
        }

        .logo-container img {
            height: 28px;
            transition: all 0.3s ease;
        }

        @media (min-width: 1024px) {
            .logo-container img {
                height: 36px;
            }
        }
    </style>
</head>
<body class="h-full">
    <header class="header <?php echo $transparent_header ? 'header-transparent' : ''; ?>">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 header-content">
            <div class="logo-container">
                <a href="/" class="flex items-center">
                    <img src="https://cdn.imators.com/logo.png" alt="Logo Imators">
                </a>
            </div>

            <div class="desktop-menu items-center space-x-6">
                <div class="desktop-menu-item font-light">
                    Products
                    <div class="desktop-submenu">
                        <div class="submenu-container">
                            <div class="submenu-links">
                                <a href="https://academ.my" class="submenu-link">
                                    <div class="submenu-title">Academ</div>
                                    <div class="submenu-desc">Say goodbye to homework overflow</div>
                                </a>
                                <a href="/progm" class="submenu-link">
                                    <div class="submenu-title">Progm</div>
                                    <div class="submenu-desc">Program management simplified</div>
                                </a>
                                <a href="https://ohmypanel.com" class="submenu-link">
                                    <div class="submenu-title">OhMyPanel</div>
                                    <div class="submenu-desc">Quick & easy shopping</div>
                                </a>
                                <a href="https://owtfitt.com" class="submenu-link">
                                    <div class="submenu-title">Owtfitt</div>
                                    <div class="submenu-desc">Premium fashion outfits</div>
                                </a>
                                <a href="https://imators.systems/traffic" class="submenu-link">
                                    <div class="submenu-title">TrafficLight</div>
                                    <div class="submenu-desc">Intelligent traffic management</div>
                                </a>
                            </div>
                            <div class="submenu-stories">
                                <h4 class="stories-title">Stories</h4>
                                <div class="stories-grid">
                                    <div class="story-item" style="background-image: url('https://cdn.imators.com/story1.jpg')">
                                        <div class="story-content">
                                            <h5 class="story-title">Academ Success</h5>
                                            <p class="story-desc">See how Academ transforms education</p>
                                        </div>
                                    </div>
                                    <div class="story-item" style="background-image: url('https://cdn.imators.com/story2.jpg')">
                                        <div class="story-content">
                                            <h5 class="story-title">TrafficLight Impact</h5>
                                            <p class="story-desc">Smart traffic solutions in action</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="desktop-menu-item">
                    Developer Tools
                    <div class="desktop-submenu">
                        <div class="submenu-container">
                            <div class="submenu-links">
                                <a href="https://imators.systems" class="submenu-link">
                                    <div class="submenu-title">Imators Systems</div>
                                    <div class="submenu-desc">Enterprise-grade systems</div>
                                </a>
                                <a href="https://developer.imators.com" class="submenu-link">
                                    <div class="submenu-title">Imators Developer</div>
                                    <div class="submenu-desc">Developer resources & APIs</div>
                                </a>
                                <a href="https://imators.systems/traffic" class="submenu-link">
                                    <div class="submenu-title">TrafficLight</div>
                                    <div class="submenu-desc">Traffic management API</div>
                                </a>
                            </div>
                            <div class="submenu-stories">
                                <h4 class="stories-title">Stories</h4>
                                <div class="stories-grid">
                                    <div class="story-item" style="background-image: url('https://cdn.imators.com/dev1.jpg')">
                                        <div class="story-content">
                                            <h5 class="story-title">Developer Journey</h5>
                                            <p class="story-desc">Building with Imators tools</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="desktop-menu-item">
                    Company
                    <div class="desktop-submenu">
                        <div class="submenu-container">
                            <div class="submenu-links">
                                <a href="/support" class="submenu-link">
                                    <div class="submenu-title">Support</div>
                                    <div class="submenu-desc">Get help with our products</div>
                                </a>
                                <a href="/contact-us" class="submenu-link">
                                    <div class="submenu-title">Contact us</div>
                                    <div class="submenu-desc">Reach out to our team</div>
                                </a>
                                <a href="/about-us" class="submenu-link">
                                    <div class="submenu-title">About Imators</div>
                                    <div class="submenu-desc">Our mission and vision</div>
                                </a>
                            </div>
                            <div class="submenu-stories">
                                <h4 class="stories-title">Stories</h4>
                                <div class="stories-grid">
                                    <div class="story-item" style="background-image: url('https://cdn.imators.com/company1.jpg')">
                                        <div class="story-content">
                                            <h5 class="story-title">Our Journey</h5>
                                            <p class="story-desc">The story of Imators</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="flex items-center space-x-4">
                <a href="https://idsma.imators.com" class="imators-account-btn lg:flex hidden">
                    Imators Account
                </a>
                <button id="hamburger" class="hamburger">
                    <span></span>
                    <span></span>
                </button>
            </div>
        </div>
    </header>
    
    <div class="mobile-overlay"></div>

    <div class="mobile-menu">
        <div class="mobile-menu-header">
            <span class="menu-title">Nice to see you.</span>
        </div>

        <div class="stories-grid-mobile">
            <div class="story-card" style="background-color: #8B5CF6;">
                <div class="story-card-inner">
                    <h3 class="story-card-title">Academ</h3>
                    <p class="story-card-desc">Say goodbye to homework overflow</p>
                    <a href="https://academ.my" class="story-card-link">Learn more</a>
                </div>
            </div>
            <div class="story-card" style="background-color: #FBBF24;">
                <div class="story-card-inner">
                    <h3 class="story-card-title">OhMyPanel</h3>
                    <p class="story-card-desc">Quick & easy shopping</p>
                    <a href="https://ohmypanel.com" class="story-card-link">Learn more</a>
                </div>
            </div>
            <div class="story-card" style="background-color: #404040;">
                <div class="story-card-inner">
                    <h3 class="story-card-title">Imators Account</h3>
                    <p class="story-card-desc">Global benefits</p>
                    <a href="https://idsma.imators.com" class="story-card-link">Explorer</a>
                </div>
            </div>
            <div class="story-card" style="background-color: #3B82F6;">
                <div class="story-card-inner">
                    <h3 class="story-card-title">TrafficLight</h3>
                    <p class="story-card-desc">Traffic management</p>
                    <a href="https://imators.systems/traffic" class="story-card-link">Discover</a>
                </div>
            </div>
        </div>
  
        <div class="mobile-menu-items">
            <div class="mobile-menu-item" data-submenu="products">
                <span>Products</span>
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 18l6-6-6-6"/>
                </svg>
            </div>
            <div class="mobile-menu-item" data-submenu="dev-tools">
                <span>Developer Tools</span>
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 18l6-6-6-6"/>
                </svg>
            </div>
            <div class="mobile-menu-item" data-submenu="company">
                <span>Company</span>
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 18l6-6-6-6"/>
                </svg>
            </div>
        </div>
    </div>
    
    <div class="mobile-submenu-panel" id="products-submenu">
        <div class="mobile-submenu-header">
            <button class="close-button back-button">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M15 18l-6-6 6-6"/>
                </svg>
            </button>
            <span class="menu-title">Products</span>
        </div>
        <div class="mobile-submenu-content">
            <a href="https://academ.my" class="mobile-submenu-link">
                <div class="mobile-link-title">Academ</div>
                <div class="mobile-link-desc">Say goodbye to homework overflow</div>
            </a>
            <a href="/progm" class="mobile-submenu-link">
                <div class="mobile-link-title">Progm</div>
                <div class="mobile-link-desc">Program management simplified</div>
            </a>
            <a href="https://ohmypanel.com" class="mobile-submenu-link">
                <div class="mobile-link-title">OhMyPanel</div>
                <div class="mobile-link-desc">Quick & easy shopping</div>
            </a>
            <a href="https://owtfitt.com" class="mobile-submenu-link">
                <div class="mobile-link-title">Owtfitt</div>
                <div class="mobile-link-desc">Premium fashion outfits</div>
            </a>
            <a href="https://imators.systems/traffic" class="mobile-submenu-link">
                <div class="mobile-link-title">TrafficLight</div>
                <div class="mobile-link-desc">Intelligent traffic management</div>
            </a>
        </div>
    </div>

    <div class="mobile-submenu-panel" id="dev-tools-submenu">
        <div class="mobile-submenu-header">
            <button class="close-button back-button">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M15 18l-6-6 6-6"/>
                </svg>
            </button>
            <span class="menu-title">Developer Tools</span>
        </div>
        <div class="mobile-submenu-content">
            <a href="https://imators.systems" class="mobile-submenu-link">
                <div class="mobile-link-title">Imators Systems</div>
                <div class="mobile-link-desc">Enterprise-grade systems</div>
            </a>
            <a href="https://developer.imators.com" class="mobile-submenu-link">
                <div class="mobile-link-title">Imators Developer</div>
                <div class="mobile-link-desc">Developer resources & APIs</div>
            </a>
            <a href="https://imators.systems/traffic" class="mobile-submenu-link">
                <div class="mobile-link-title">TrafficLight</div>
                <div class="mobile-link-desc">Traffic management API</div>
            </a>
        </div>
    </div>

    <div class="mobile-submenu-panel" id="company-submenu">
        <div class="mobile-submenu-header">
            <button class="close-button back-button">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M15 18l-6-6 6-6"/>
                </svg>
            </button>
            <span class="menu-title">Company</span>
        </div>
        <div class="mobile-submenu-content">
            <a href="/support" class="mobile-submenu-link">
                <div class="mobile-link-title">Support</div>
                <div class="mobile-link-desc">Get help with our products</div>
            </a>
            <a href="/contact-us" class="mobile-submenu-link">
                <div class="mobile-link-title">Contact us</div>
                <div class="mobile-link-desc">Reach out to our team</div>
            </a>
            <a href="/about-us" class="mobile-submenu-link">
                <div class="mobile-link-title">About Imators</div>
                <div class="mobile-link-desc">Our mission and vision</div>
            </a>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/Swiper/9.3.2/swiper-bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const hamburger = document.getElementById('hamburger');
            const mobileMenu = document.querySelector('.mobile-menu');
            const mobileOverlay = document.querySelector('.mobile-overlay');
            const backButtons = document.querySelectorAll('.back-button');
            const menuItems = document.querySelectorAll('.mobile-menu-item');
            const header = document.querySelector('.header');
            const submenus = document.querySelectorAll('.mobile-submenu-panel');
            
            let isTransitioning = false;
            let lastScrollTop = 0;
            let scrollTimeout;

            function openMenu() {
                if (isTransitioning) return;
                document.body.style.overflow = 'hidden';
                mobileOverlay.classList.add('active');
                mobileMenu.classList.add('active');
                hamburger.classList.add('active');
            }

            function closeMenu() {
                if (isTransitioning) return;
                document.body.style.overflow = '';
                mobileOverlay.classList.remove('active');
                mobileMenu.classList.remove('active');
                hamburger.classList.remove('active');
                submenus.forEach(submenu => {
                    submenu.classList.remove('active');
                });
            }

            hamburger.addEventListener('click', () => {
                mobileMenu.classList.contains('active') ? closeMenu() : openMenu();
            });

            backButtons.forEach(button => {
                button.addEventListener('click', () => {
                    const submenuPanel = button.closest('.mobile-submenu-panel');
                    if (submenuPanel) {
                        submenuPanel.classList.remove('active');
                    }
                });
            });

            mobileOverlay.addEventListener('click', closeMenu);

            menuItems.forEach(item => {
                item.addEventListener('click', () => {
                    if (isTransitioning) return;
                    isTransitioning = true;

                    const submenuId = item.getAttribute('data-submenu') + '-submenu';
                    const submenu = document.getElementById(submenuId);

                    if (submenu) {
                        submenu.classList.add('active');
                    }

                    setTimeout(() => {
                        isTransitioning = false;
                    }, 300);
                });
            });

            window.addEventListener('scroll', () => {
                clearTimeout(scrollTimeout);
                const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
                
                if (header.classList.contains('header-transparent')) {
                    if (scrollTop > 0) {
                        header.classList.add('scrolled');
                    } else {
                        header.classList.remove('scrolled');
                    }
                }

                if (!mobileMenu.classList.contains('active') && Math.abs(scrollTop - lastScrollTop) > 50) {
                    header.style.transform = scrollTop > lastScrollTop && scrollTop > header.offsetHeight ? 
                        'translateY(-100%)' : 'translateY(0)';
                    lastScrollTop = scrollTop;
                }

                scrollTimeout = setTimeout(() => {
                    header.style.transform = 'translateY(0)';
                }, 1000);
            });

            let touchStartY = 0;
            mobileMenu.addEventListener('touchstart', (e) => {
                touchStartY = e.touches[0].clientY;
            }, { passive: true });

            mobileMenu.addEventListener('touchmove', (e) => {
                const touchEndY = e.touches[0].clientY;
                const deltaY = touchEndY - touchStartY;

                if (deltaY > 70) {
                    closeMenu();
                    touchStartY = 0;
                }
            }, { passive: true });

            document.addEventListener('keydown', (e) => {
                if (e.key === 'Escape') {
                    if (mobileMenu.classList.contains('active')) {
                        closeMenu();
                    }
                }
            });

            const storyCards = document.querySelectorAll('.story-card');
            storyCards.forEach(card => {
                card.addEventListener('click', () => {
                    const link = card.querySelector('a');
                    if (link) {
                        window.location.href = link.getAttribute('href');
                    }
                });
            });

            const storyItems = document.querySelectorAll('.story-item');
            storyItems.forEach(item => {
                item.addEventListener('click', () => {
                    window.location.href = '#story-detail';
                });
            });
        });
    </script>
</body>
</html>