<?php
$transparent_header = isset($transparent_header) ? $transparent_header : false;
?>

<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Header - Imators</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Swiper/9.3.2/swiper-bundle.min.css" />
    <link rel="stylesheet" href="header.css">
</head>
<body class="h-full">
    <header class="header <?php echo $transparent_header ? 'header-transparent' : ''; ?>">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 header-content">
            <div class="logo-container">
                <a href="/" class="flex items-center">
                    <img src="https://cdn.imators.com/logo.png" alt="Logo Imators">
                </a>
            </div>

            <div class="desktop-menu items-center space-x-6">
                <div class="desktop-menu-item font-light">
                    Products
                    <div class="desktop-overlay" id="products-overlay">
                        <div class="overlay-container">
                            <div class="overlay-content">
                                <div class="overlay-header">
                                    <h3 class="overlay-title">Products</h3>
                                    <button class="overlay-close">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                            <path d="M18 6L6 18M6 6l12 12" />
                                        </svg>
                                    </button>
                                </div>
                                <div class="overlay-links">
                                    <a href="https://academ.my" class="overlay-link">Academ</a>
                                    <a href="/progm" class="overlay-link">Progm</a>
                                    <a href="https://ohmypanel.com" class="overlay-link">OhMyPanel</a>
                                    <a href="https://owtfitt.com" class="overlay-link">Owtfitt</a>
                                    <a href="https://imators.systems/traffic" class="overlay-link">TrafficLight</a>
                                </div>
                                <div class="overlay-stories">
                                    <h4 class="stories-title">Stories</h4>
                                    <div class="stories-grid">
                                        <div class="story-item" style="background-image: url('https://cdn.imators.com/story1.jpg')">
                                            <div class="story-content">
                                                <h5>Academ Stories</h5>
                                                <p>Discover how Academ transforms education</p>
                                            </div>
                                        </div>
                                        <div class="story-item" style="background-image: url('https://cdn.imators.com/story2.jpg')">
                                            <div class="story-content">
                                                <h5>OhMyPanel Impact</h5>
                                                <p>See the difference in shopping experience</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="desktop-menu-item">
                    Developer Tools
                    <div class="desktop-overlay" id="dev-tools-overlay">
                        <div class="overlay-container">
                            <div class="overlay-content">
                                <div class="overlay-header">
                                    <h3 class="overlay-title">Developer Tools</h3>
                                    <button class="overlay-close">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                            <path d="M18 6L6 18M6 6l12 12" />
                                        </svg>
                                    </button>
                                </div>
                                <div class="overlay-links">
                                    <a href="https://imators.systems" class="overlay-link">Imators Systems</a>
                                    <a href="https://developer.imators.com" class="overlay-link">Imators Developer</a>
                                    <a href="https://imators.systems/traffic" class="overlay-link">TrafficLight</a>
                                </div>
                                <div class="overlay-stories">
                                    <h4 class="stories-title">Stories</h4>
                                    <div class="stories-grid">
                                        <div class="story-item" style="background-image: url('https://cdn.imators.com/dev1.jpg')">
                                            <div class="story-content">
                                                <h5>Dev Stories</h5>
                                                <p>Building with Imators tools</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="desktop-menu-item">
                    Company
                    <div class="desktop-overlay" id="company-overlay">
                        <div class="overlay-container">
                            <div class="overlay-content">
                                <div class="overlay-header">
                                    <h3 class="overlay-title">Company</h3>
                                    <button class="overlay-close">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                            <path d="M18 6L6 18M6 6l12 12" />
                                        </svg>
                                    </button>
                                </div>
                                <div class="overlay-links">
                                    <a href="/support" class="overlay-link">Support</a>
                                    <a href="/contact-us" class="overlay-link">Contact us</a>
                                    <a href="/about-us" class="overlay-link">About Imators</a>
                                </div>
                                <div class="overlay-stories">
                                    <h4 class="stories-title">Stories</h4>
                                    <div class="stories-grid">
                                        <div class="story-item" style="background-image: url('https://cdn.imators.com/company1.jpg')">
                                            <div class="story-content">
                                                <h5>Our Journey</h5>
                                                <p>The story of Imators</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="flex items-center space-x-4">
                <a href="https://idsma.imators.com" class="imators-account-btn lg:flex hidden">
                    Imators Account
                </a>
                <button id="hamburger" class="hamburger">
                    <span></span>
                    <span></span>
                </button>
            </div>
        </div>
    </header>
    
    <div class="mobile-overlay"></div>

    <div class="mobile-menu">
        <div class="mobile-menu-header">
            <span class="menu-title">Nice to see you.</span>
        </div>

        <div class="featured-cards-section">
            <div class="stories-container">
                <div class="stories-grid-mobile">
                    <div class="story-card" style="background: linear-gradient(135deg, #8B5CF6, #C4B5FD, #F3E8FF);">
                        <div class="story-card-content">
                            <h3>Academ</h3>
                            <p>Say goodbye to homework overflow</p>
                            <a href="https://academ.my">Learn more</a>
                        </div>
                    </div>
                    <div class="story-card" style="background: linear-gradient(135deg, #FBBF24, #FEF3C7);">
                        <div class="story-card-content">
                            <h3>OhMyPanel</h3>
                            <p>Quick & easy shopping</p>
                            <a href="https://ohmypanel.com">Learn more</a>
                        </div>
                    </div>
                    <div class="story-card" style="background: linear-gradient(135deg, #000000, #404040, #FFFFFF);">
                        <div class="story-card-content">
                            <h3>Imators Account</h3>
                            <p>Global benefits</p>
                            <a href="https://idsma.imators.com">Explorer</a>
                        </div>
                    </div>
                    <div class="story-card" style="background: linear-gradient(135deg, #1E3A8A, #3B82F6);">
                        <div class="story-card-content">
                            <h3>Support</h3>
                            <p>Fast & efficient help</p>
                            <a href="/contact-us">Help me</a>
                        </div>
                    </div>
                    <div class="story-card" style="background: linear-gradient(135deg, #059669, #A7F3D0);">
                        <div class="story-card-content">
                            <h3>TrafficLight</h3>
                            <p>Traffic management</p>
                            <a href="https://imators.systems/traffic">Discover</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
  
        <div class="mobile-menu-items">
            <div class="mobile-menu-item" data-submenu="products">
                <span>Products</span>
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 18l6-6-6-6"/>
                </svg>
            </div>
            <div class="mobile-menu-item" data-submenu="dev-tools">
                <span>Developer Tools</span>
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 18l6-6-6-6"/>
                </svg>
            </div>
            <div class="mobile-menu-item" data-submenu="company">
                <span>Company</span>
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 18l6-6-6-6"/>
                </svg>
            </div>
        </div>
    </div>
    
    <div class="mobile-submenu-panel" id="products-submenu">
        <div class="mobile-submenu-header">
            <button class="close-button back-button">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M15 18l-6-6 6-6"/>
                </svg>
            </button>
            <span class="menu-title">Products</span>
        </div>
        <div class="mobile-submenu-content">
            <a href="https://academ.my" class="mobile-submenu-link">Academ</a>
            <a href="/progm" class="mobile-submenu-link">Progm</a>
            <a href="https://ohmypanel.com" class="mobile-submenu-link">OhMyPanel</a>
            <a href="https://owtfitt.com" class="mobile-submenu-link">Owtfitt</a>
            <a href="https://imators.systems/traffic" class="mobile-submenu-link">TrafficLight</a>
        </div>
    </div>

    <div class="mobile-submenu-panel" id="dev-tools-submenu">
        <div class="mobile-submenu-header">
            <button class="close-button back-button">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M15 18l-6-6 6-6"/>
                </svg>
            </button>
            <span class="menu-title">Developer Tools</span>
        </div>
        <div class="mobile-submenu-content">
            <a href="https://imators.systems" class="mobile-submenu-link">Imators Systems</a>
            <a href="https://developer.imators.com" class="mobile-submenu-link">Imators Developer</a>
            <a href="https://imators.systems/traffic" class="mobile-submenu-link">TrafficLight</a>
        </div>
    </div>

    <div class="mobile-submenu-panel" id="company-submenu">
        <div class="mobile-submenu-header">
            <button class="close-button back-button">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M15 18l-6-6 6-6"/>
                </svg>
            </button>
            <span class="menu-title">Company</span>
        </div>
        <div class="mobile-submenu-content">
            <a href="/support" class="mobile-submenu-link">Support</a>
            <a href="/contact-us" class="mobile-submenu-link">Customer Support</a>
            <a href="/about-us" class="mobile-submenu-link">About Imators</a>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/Swiper/9.3.2/swiper-bundle.min.js"></script>
    <script src="imators-header.js"></script>
</body>
</html>