<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AndWeare</title>
    <link rel="icon" type="image/png" href="logo.png">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+KR:wght@300;400;500;700&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.11.5/gsap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.11.5/ScrollTrigger.min.js"></script>
    <style>
        body {
            font-family: 'Noto Sans KR', sans-serif;
            background-color: #ffffff;
            overflow-x: hidden;
        }
        
        .content-container {
            position: relative;
            z-index: 10;
        }
        
        .phone-container {
            position: fixed;
            pointer-events: none;
            width: 270px;
            height: 570px;
            border-radius: 42px;
            background-color: #111;
            box-shadow: 0 15px 35px rgba(0,0,0,0.2);
            padding: 4px;
            overflow: hidden;
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 0;
            filter: blur(15px);
            transform: translateY(30px);
            transition: opacity 1s ease, filter 1s ease, transform 1s ease;
        }
        
        .phone-container.visible {
            opacity: 1;
            filter: blur(0);
            transform: translateY(0);
        }
        
        .phone-left.visible {
            transition-delay: 0.9s;
        }
        
        .phone-right.visible {
            transition-delay: 1.2s;
        }
        
        .phone-frame {
            width: 100%;
            height: 100%;
            border-radius: 38px;
            overflow: hidden;
            position: relative;
            border: 1px solid rgba(255,255,255,0.05);
        }
        
        .dynamic-island {
            position: absolute;
            top: 10px;
            left: 50%;
            transform: translateX(-50%);
            width: 100px;
            height: 30px;
            background-color: #000;
            border-radius: 20px;
            z-index: 2;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .dynamic-island::after {
            content: '';
            position: absolute;
            width: 8px;
            height: 8px;
            border-radius: 50%;
            background-color: rgba(255,255,255,0.4);
            right: 10px;
        }
        
        .phone-video {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .phone-left {
            left: 10%;
            top: 20%;
            transform: perspective(1000px) rotateY(-5deg) rotateX(5deg) rotate(-5deg);
        }
        
        .phone-scroll {
            right: 10%;
            top: 20%;
            transform: perspective(1000px) rotateY(5deg) rotateX(5deg) rotate(5deg);
            z-index: 20;
        }
        
        .phone-mobile {
            position: relative;
            bottom: -50px;
            width: 200px;
            height: 200px;
            margin: 0 auto;
            overflow: hidden;
            border-top-left-radius: 42px;
            border-top-right-radius: 42px;
            display: none;
        }
        
        .phone-mobile .phone-frame {
            border-radius: 0;
            border-top-left-radius: 38px;
            border-top-right-radius: 38px;
        }
        
        .blur-element {
            opacity: 0;
            filter: blur(10px);
            transform: translateY(20px);
            transition: opacity 0.8s ease, filter 0.8s ease, transform 0.8s ease;
        }
        
        .blur-element.visible {
            opacity: 1;
            filter: blur(0);
            transform: translateY(0);
        }
        
        .delay-100 {
            transition-delay: 0.1s;
        }
        
        .delay-200 {
            transition-delay: 0.3s;
        }
        
        .delay-300 {
            transition-delay: 0.5s;
        }
        
        .delay-400 {
            transition-delay: 0.7s;
        }
        
        .feature-section {
            height: 100vh;
            display: flex;
            align-items: center;
        }
        
        .feature-content {
            opacity: 0;
            transform: translateX(-50px);
        }
        
        .feature-icon {
            font-size: 2.5rem;
            margin-bottom: 1rem;
        }
        
        @media (max-width: 768px) {
            .phone-scroll {
                display: none;
            }
            
            .phone-mobile {
                display: block;
            }
            
            .feature-section {
                height: auto;
                padding: 5rem 1rem;
            }
        }
    </style>
</head>
<body>
    <div class="phone-container phone-left hidden md:block">
        <div class="phone-frame">
            <div class="dynamic-island"></div>
            <video autoplay loop muted playsinline class="phone-video">
                <source src="250395_small.mp4" type="video/mp4">
            </video>
        </div>
    </div>
    
    <div class="phone-container phone-scroll hidden md:block">
        <div class="phone-frame">
            <div class="dynamic-island"></div>
            <video autoplay loop muted playsinline class="phone-video">
                <source src="253998_small.mp4" type="video/mp4">
            </video>
        </div>
    </div>
    
    <div class="min-h-screen flex items-center justify-center p-4">
        <div class="content-container max-w-2xl mx-auto text-center">
            <span class="blur-element inline-block px-4 py-2 bg-gray-100 rounded-full text-sm font-medium text-gray-800 mb-6">Where we'll all be</span>
            
            <h1 class="blur-element delay-100 text-5xl md:text-6xl font-bold mb-6">AndWeare.</h1>
            
            <p class="blur-element delay-200 text-xl text-gray-600 mb-10">
                Create a private online space where your family can connect, share, and organize your life together - no matter how far apart you are.
            </p>
            
            <a href="/hub" class="blur-element delay-300 inline-block px-8 py-4 bg-black text-white rounded-full hover:bg-gray-800 transition-colors text-center text-lg">
                Get Started
            </a>
            
            <div class="phone-mobile mt-16">
                <div class="phone-frame">
                    <video autoplay loop muted playsinline class="phone-video">
                        <source src="253998_small.mp4" type="video/mp4">
                    </video>
                </div>
            </div>
        </div>
    </div>

    <div class="features-container">
        <section class="feature-section">
            <div class="max-w-6xl mx-auto px-4 md:px-8 w-full">
                <div class="grid md:grid-cols-2 gap-12 items-center">
                    <div class="feature-content">
                        <div class="feature-icon text-blue-500">
                            <i class="fas fa-users"></i>
                        </div>
                        <h2 class="text-3xl md:text-4xl font-bold mb-4">Connecter votre famille</h2>
                        <p class="text-lg text-gray-600">
                            Restez en contact avec vos proches, partagez des photos et des vidéos dans un espace privé 
                            et sécurisé créé uniquement pour votre famille.
                        </p>
                    </div>
                    <div class="md:hidden phone-mobile">
                        <div class="phone-frame">
                            <video autoplay loop muted playsinline class="phone-video">
                                <source src="253998_small.mp4" type="video/mp4">
                            </video>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="feature-section">
            <div class="max-w-6xl mx-auto px-4 md:px-8 w-full">
                <div class="grid md:grid-cols-2 gap-12 items-center">
                    <div class="feature-content">
                        <div class="feature-icon text-green-500">
                            <i class="fas fa-calendar-alt"></i>
                        </div>
                        <h2 class="text-3xl md:text-4xl font-bold mb-4">Organiser votre vie</h2>
                        <p class="text-lg text-gray-600">
                            Calendriers partagés, listes de tâches et rappels pour coordonner facilement les activités 
                            familiales et ne jamais manquer un événement important.
                        </p>
                    </div>
                    <div class="md:hidden phone-mobile">
                        <div class="phone-frame">
                            <video autoplay loop muted playsinline class="phone-video">
                                <source src="253998_small.mp4" type="video/mp4">
                            </video>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="feature-section">
            <div class="max-w-6xl mx-auto px-4 md:px-8 w-full">
                <div class="grid md:grid-cols-2 gap-12 items-center">
                    <div class="feature-content">
                        <div class="feature-icon text-purple-500">
                            <i class="fas fa-shield-alt"></i>
                        </div>
                        <h2 class="text-3xl md:text-4xl font-bold mb-4">Sécurité et confidentialité</h2>
                        <p class="text-lg text-gray-600">
                            Protégez vos moments les plus précieux avec un chiffrement de bout en bout et un contrôle 
                            total sur qui peut voir et partager votre contenu familial.
                        </p>
                    </div>
                    <div class="md:hidden phone-mobile">
                        <div class="phone-frame">
                            <video autoplay loop muted playsinline class="phone-video">
                                <source src="253998_small.mp4" type="video/mp4">
                            </video>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Animation initiale
            setTimeout(function() {
                const elements = document.querySelectorAll('.blur-element, .phone-container');
                elements.forEach(function(element) {
                    element.classList.add('visible');
                });
            }, 300);
            
            // Initialiser GSAP ScrollTrigger
            gsap.registerPlugin(ScrollTrigger);
            
            // Animation du téléphone au scroll
            const phoneScroll = document.querySelector('.phone-scroll');
            if (window.innerWidth > 768) {
                gsap.to(phoneScroll, {
                    scrollTrigger: {
                        trigger: '.features-container',
                        start: 'top top',
                        end: 'bottom bottom',
                        scrub: true,
                        pin: true,
                        pinSpacing: false
                    },
                    y: window.innerHeight * 0.6,
                    ease: 'none'
                });
            }
            
            // Animation des sections de fonctionnalités
            document.querySelectorAll('.feature-content').forEach((section, index) => {
                gsap.fromTo(section, 
                    { opacity: 0, x: -50 },
                    {
                        scrollTrigger: {
                            trigger: section.closest('.feature-section'),
                            start: 'top 70%',
                            end: 'bottom 70%',
                            scrub: 1,
                            toggleActions: 'play none none reverse'
                        },
                        opacity: 1,
                        x: 0,
                        ease: 'power2.out',
                        duration: 1
                    }
                );
            });
            
            // Animation responsive pour mobile
            if (window.innerWidth <= 768) {
                document.querySelectorAll('.phone-mobile').forEach((phone, index) => {
                    if (!phone.closest('.feature-section')) return;
                    
                    gsap.fromTo(phone, 
                        { opacity: 0, y: 50 },
                        {
                            scrollTrigger: {
                                trigger: phone.closest('.feature-section'),
                                start: 'top 80%',
                                end: 'bottom 80%',
                                toggleActions: 'play none none reverse'
                            },
                            opacity: 1,
                            y: 0,
                            ease: 'power2.out',
                            duration: 0.6
                        }
                    );
                });
            }
        });
    </script>
</body>
</html>