<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AndWeare</title>
    <link rel="icon" type="image/png" href="logo.png">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+KR:wght@300;400;500;700&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            font-family: 'Noto Sans KR', sans-serif;
            background-color: #ffffff;
            overflow-x: hidden;
        }
        
        .content-container {
            position: relative;
            z-index: 10;
        }
        
        .phone-container {
            position: fixed;
            pointer-events: none;
            width: 270px;
            height: 550px;
            border-radius: 28px;
            background-color: #222;
            box-shadow: 0 10px 25px rgba(0,0,0,0.2);
            padding: 8px;
            overflow: hidden;
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 0;
            filter: blur(15px);
            transform: translateY(30px);
            transition: opacity 1s ease, filter 1s ease, transform 1s ease;
        }
        
        .phone-container.visible {
            opacity: 1;
            filter: blur(0);
            transform: translateY(0);
        }
        
        .phone-left.visible {
            transition-delay: 0.9s;
        }
        
        .phone-right.visible {
            transition-delay: 1.2s;
        }
        
        .phone-frame {
            width: 100%;
            height: 100%;
            border-radius: 20px;
            overflow: hidden;
            position: relative;
            border: 1px solid rgba(255,255,255,0.1);
        }
        
        .phone-notch {
            position: absolute;
            top: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 90px;
            height: 18px;
            background-color: #222;
            border-bottom-left-radius: 8px;
            border-bottom-right-radius: 8px;
            z-index: 2;
        }
        
        .phone-video {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .phone-left {
            left: 5%;
            top: 15%;
            transform: perspective(1000px) rotateY(-15deg) rotateX(5deg);
        }
        
        .phone-right {
            right: 5%;
            top: 15%;
            transform: perspective(1000px) rotateY(15deg) rotateX(5deg);
        }
        
        .blur-element {
            opacity: 0;
            filter: blur(10px);
            transform: translateY(20px);
            transition: opacity 0.8s ease, filter 0.8s ease, transform 0.8s ease;
        }
        
        .blur-element.visible {
            opacity: 1;
            filter: blur(0);
            transform: translateY(0);
        }
        
        .delay-100 {
            transition-delay: 0.1s;
        }
        
        .delay-200 {
            transition-delay: 0.3s;
        }
        
        .delay-300 {
            transition-delay: 0.5s;
        }
        
        .delay-400 {
            transition-delay: 0.7s;
        }
    </style>
</head>
<body class="min-h-screen flex items-center justify-center p-4">
    <div class="phone-container phone-left hidden md:block">
        <div class="phone-frame">
            <div class="phone-notch"></div>
            <video autoplay loop muted playsinline class="phone-video">
                <source src="250395_small.mp4" type="video/mp4">
            </video>
        </div>
    </div>
    
    <div class="phone-container phone-right hidden md:block">
        <div class="phone-frame">
            <div class="phone-notch"></div>
            <video autoplay loop muted playsinline class="phone-video">
                <source src="253998_small.mp4" type="video/mp4">
            </video>
        </div>
    </div>
    
    <div class="content-container max-w-2xl mx-auto text-center">
        <span class="blur-element inline-block px-4 py-2 bg-gray-100 rounded-full text-sm font-medium text-gray-800 mb-6">Where we'll all be</span>
        
        <h1 class="blur-element delay-100 text-5xl md:text-6xl font-bold mb-6">AndWeare</h1>
        
        <p class="blur-element delay-200 text-xl text-gray-600 mb-10">
            Create a private online space where your family can connect, share, and organize your life together - no matter how far apart you are.
        </p>
        
        <a href="/hub" class="blur-element delay-300 inline-block px-8 py-4 bg-black text-white rounded-full hover:bg-gray-800 transition-colors text-center text-lg">
            Get Started
        </a>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(function() {
                const elements = document.querySelectorAll('.blur-element, .phone-container');
                elements.forEach(function(element) {
                    element.classList.add('visible');
                });
            }, 300);
        });
    </script>
</body>
</html>