<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AndWeare</title>
    <link rel="icon" type="image/png" href="logo.png">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+KR:wght@300;400;500;700&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            font-family: 'Noto Sans KR', sans-serif;
            background-color: #ffffff;
            overflow-x: hidden;
        }
        
        .content-container {
            position: relative;
            z-index: 10;
        }
        
        .phone-container {
            position: fixed;
            pointer-events: none;
            width: 270px;
            height: 570px;
            border-radius: 42px;
            background-color: #111;
            box-shadow: 0 15px 35px rgba(0,0,0,0.2);
            padding: 4px;
            overflow: hidden;
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 0;
            filter: blur(15px);
            transform: translateY(30px);
            transition: opacity 1s ease, filter 1s ease, transform 1s ease;
        }
        
        .phone-container.visible {
            opacity: 1;
            filter: blur(0);
            transform: translateY(0);
        }
        
        .phone-left.visible {
            transition-delay: 0.9s;
        }
        
        .phone-right.visible {
            transition-delay: 1.2s;
        }
        
        .phone-frame {
            width: 100%;
            height: 100%;
            border-radius: 38px;
            overflow: hidden;
            position: relative;
            border: 1px solid rgba(255,255,255,0.05);
        }
        
        .dynamic-island {
            position: absolute;
            top: 10px;
            left: 50%;
            transform: translateX(-50%);
            width: 100px;
            height: 30px;
            background-color: #000;
            border-radius: 20px;
            z-index: 2;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .dynamic-island::after {
            content: '';
            position: absolute;
            width: 8px;
            height: 8px;
            border-radius: 50%;
            background-color: rgba(255,255,255,0.4);
            right: 10px;
        }
        
        .phone-video {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .phone-left {
            left: 10%;
            top: 20%;
            transform: perspective(1000px) rotateY(-5deg) rotateX(5deg) rotate(-5deg);
        }
        
        .phone-right {
            right: 10%;
            top: 20%;
            transform: perspective(1000px) rotateY(5deg) rotateX(5deg) rotate(5deg);
        }
        
        .mobile-phone {
            position: relative;
            width: 140px;
            height: 280px;
            border-radius: 28px;
            background-color: #111;
            box-shadow: 0 10px 25px rgba(0,0,0,0.15);
            padding: 2px;
            overflow: hidden;
            opacity: 0;
            filter: blur(10px);
            transform: translateY(20px);
            transition: opacity 0.8s ease, filter 0.8s ease, transform 0.8s ease;
        }
        
        .mobile-phone.visible {
            opacity: 1;
            filter: blur(0);
            transform: translateY(0);
        }
        
        .mobile-frame {
            width: 100%;
            height: 100%;
            border-radius: 26px;
            overflow: hidden;
            position: relative;
            border: 1px solid rgba(255,255,255,0.05);
        }
        
        .mobile-island {
            position: absolute;
            top: 8px;
            left: 50%;
            transform: translateX(-50%);
            width: 60px;
            height: 20px;
            background-color: #000;
            border-radius: 12px;
            z-index: 2;
        }
        
        .mobile-island::after {
            content: '';
            position: absolute;
            width: 6px;
            height: 6px;
            border-radius: 50%;
            background-color: rgba(255,255,255,0.4);
            right: 8px;
        }
        
        .top-phones {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 140px;
            display: flex;
            justify-content: center;
            padding-top: 0;
            z-index: 5;
            overflow: hidden;
        }
        
        .bottom-phone {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            height: 140px;
            display: flex;
            justify-content: center;
            z-index: 5;
            overflow: hidden;
        }
        
        .top-left-phone {
            clip-path: polygon(0 0, 100% 0, 100% 50%, 0 50%);
            margin-right: 15px;
        }
        
        .top-right-phone {
            clip-path: polygon(0 0, 100% 0, 100% 50%, 0 50%);
            margin-left: 15px;
        }
        
        .bottom-center-phone {
            clip-path: polygon(0 50%, 100% 50%, 100% 100%, 0 100%);
        }
        
        @media (max-width: 768px) {
            .content-container {
                padding-top: 100px;
                padding-bottom: 100px;
            }
        }
        
        .blur-element {
            opacity: 0;
            filter: blur(10px);
            transform: translateY(20px);
            transition: opacity 0.8s ease, filter 0.8s ease, transform 0.8s ease;
        }
        
        .blur-element.visible {
            opacity: 1;
            filter: blur(0);
            transform: translateY(0);
        }
        
        .delay-100 {
            transition-delay: 0.1s;
        }
        
        .delay-200 {
            transition-delay: 0.3s;
        }
        
        .delay-300 {
            transition-delay: 0.5s;
        }
        
        .delay-400 {
            transition-delay: 0.7s;
        }
        
        .delay-500 {
            transition-delay: 0.9s;
        }
        
        .delay-600 {
            transition-delay: 1.1s;
        }
    </style>
</head>
<body class="min-h-screen flex items-center justify-center p-4">
    <?php include 'header.php'; ?>
    
    <div class="phone-container phone-left hidden md:block">
        <div class="phone-frame">
            <div class="dynamic-island"></div>
            <video autoplay loop muted playsinline class="phone-video">
                <source src="250395_small.mp4" type="video/mp4">
            </video>
        </div>
    </div>
    
    <div class="phone-container phone-right hidden md:block">
        <div class="phone-frame">
            <div class="dynamic-island"></div>
            <video autoplay loop muted playsinline class="phone-video">
                <source src="253998_small.mp4" type="video/mp4">
            </video>
        </div>
    </div>
    
    <div class="top-phones md:hidden">
        <div class="mobile-phone top-left-phone blur-element delay-500">
            <div class="mobile-frame">
                <div class="mobile-island"></div>
                <video autoplay loop muted playsinline class="phone-video">
                    <source src="250395_small.mp4" type="video/mp4">
                </video>
            </div>
        </div>
        <div class="mobile-phone top-right-phone blur-element delay-500">
            <div class="mobile-frame">
                <div class="mobile-island"></div>
                <video autoplay loop muted playsinline class="phone-video">
                    <source src="253998_small.mp4" type="video/mp4">
                </video>
            </div>
        </div>
    </div>
    
    <div class="content-container max-w-2xl mx-auto text-center">
        <span class="blur-element inline-block px-4 py-2 bg-gray-100 rounded-full text-sm font-medium text-gray-800 mb-6">Where we'll all be</span>
        
        <h1 class="blur-element delay-100 text-5xl md:text-6xl font-bold mb-6">AndWeare.</h1>
        
        <p class="blur-element delay-200 text-xl text-gray-600 mb-10">
            Create a private online space where your family can connect, share, and organize your life together - no matter how far apart you are.
        </p>
        
        <a href="/hub" class="blur-element delay-300 inline-block px-8 py-4 bg-black text-white rounded-full hover:bg-gray-800 transition-colors text-center text-lg">
            Get Started
        </a>
    </div>
    
    <div class="bottom-phone md:hidden">
        <div class="mobile-phone bottom-center-phone blur-element delay-600">
            <div class="mobile-frame">
                <div class="mobile-island"></div>
                <video autoplay loop muted playsinline class="phone-video">
                    <source src="250395_small.mp4" type="video/mp4">
                </video>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(function() {
                const elements = document.querySelectorAll('.blur-element, .phone-container, .mobile-phone');
                elements.forEach(function(element) {
                    element.classList.add('visible');
                });
            }, 300);
        });
    </script>
</body>
</html>