<?php
session_start();

if(!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

require_once 'db.php';

$user_id = $_SESSION['user_id'];
$sql = "SELECT * FROM users WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

$sql = "SELECT solde FROM comptes_bancaires WHERE user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$compte = $result->fetch_assoc();
$solde = $compte ? $compte['solde'] : 0;

$sql = "SELECT * FROM identites WHERE user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$identite = $result->fetch_assoc();

$sql = "SELECT * FROM courriers WHERE destinataire_id = ? ORDER BY date DESC";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$courriers = [];
while($row = $result->fetch_assoc()) {
    $courriers[] = $row;
}

$sql = "SELECT * FROM casier_judiciaire WHERE user_id = ? ORDER BY date DESC";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$casier = [];
while($row = $result->fetch_assoc()) {
    $casier[] = $row;
}

if(isset($_POST['action'])) {
    switch($_POST['action']) {
        case 'virement':
            include 'includes/traitement_virement.php';
            break;
        case 'regler_facture':
            include 'includes/traitement_facture.php';
            break;
         case 'generer_id':
            include 'includes/traitement_generation_id.php';
            break;
    }
}

$onglet = isset($_GET['onglet']) ? $_GET['onglet'] : 'banque';
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Peerkinton - Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
        }
        .tab-content {
            display: none;
        }
        .tab-content.active {
            display: block;
        }
    </style>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'sans': ['Poppins', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#f0f9ff',
                            100: '#e0f2fe',
                            200: '#bae6fd',
                            300: '#7dd3fc',
                            400: '#38bdf8',
                            500: '#0ea5e9',
                            600: '#0284c7',
                            700: '#0369a1',
                            800: '#075985',
                            900: '#0c4a6e',
                        }
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-gray-50 text-gray-900">
    <div class="min-h-screen flex flex-col">
        <nav class="bg-white shadow">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between h-16">
                    <div class="flex">
                        <div class="flex-shrink-0 flex items-center">
                            <img src="logo.png" alt="Peerkinton Logo" class="h-8">
                        </div>
                    </div>
                    <div class="flex items-center">
                        <div class="ml-3 relative">
                            <div class="flex items-center space-x-4">
                                <span class="text-sm font-medium"><?php echo htmlspecialchars($user['email']); ?></span>
                                <a href="logout.php" class="text-gray-500 hover:text-gray-700">
                                    <i class="fas fa-sign-out-alt"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </nav>

        <div class="flex-grow py-6">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="border-b border-gray-200 mb-6">
                    <nav class="-mb-px flex space-x-8">
                        <a href="?onglet=banque" class="<?php echo $onglet == 'banque' ? 'border-primary-500 text-primary-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'; ?> whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                            <i class="fas fa-university mr-2"></i> Banque
                        </a>
                        <a href="?onglet=courrier" class="<?php echo $onglet == 'courrier' ? 'border-primary-500 text-primary-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'; ?> whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                            <i class="fas fa-envelope mr-2"></i> Courrier
                        </a>
                        <a href="?onglet=identite" class="<?php echo $onglet == 'identite' ? 'border-primary-500 text-primary-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'; ?> whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                            <i class="fas fa-id-card mr-2"></i> Identité
                        </a>
                    </nav>
                </div>

                <div class="tab-content <?php echo $onglet == 'banque' ? 'active' : ''; ?>" id="tab-banque">
                    <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                        <div class="px-4 py-5 sm:px-6 flex justify-between items-center">
                            <div>
                                <h3 class="text-lg leading-6 font-medium text-gray-900">
                                    Compte bancaire
                                </h3>
                                <p class="mt-1 max-w-2xl text-sm text-gray-500">
                                    Gérez vos finances.
                                </p>
                            </div>
                            <div class="px-6 py-4 bg-primary-50 rounded-lg border border-primary-100">
                                <p class="text-sm text-gray-600">Solde actuel</p>
                                <p class="text-2xl font-semibold text-primary-700"><?php echo number_format($solde, 2, ',', ' '); ?> F&</p>
                            </div>
                        </div>
                        <div class="border-t border-gray-200">
                            <div class="px-4 py-5 sm:p-6">
                                <h4 class="text-md font-medium text-gray-900 mb-4">Effectuer un virement</h4>
                                
                                <?php if(isset($virement_message)): ?>
                                    <div class="mb-4 px-4 py-3 rounded <?php echo $virement_success ? 'bg-green-50 text-green-800' : 'bg-red-50 text-red-800'; ?>">
                                        <?php echo $virement_message; ?>
                                    </div>
                                <?php endif; ?>
                                
                                <form action="" method="POST" class="space-y-4">
                                    <input type="hidden" name="action" value="virement">
                                    
                                    <div>
                                        <label for="id_destinataire" class="block text-sm font-medium text-gray-700">ID du destinataire</label>
                                        <input type="text" name="id_destinataire" id="id_destinataire" required class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500 sm:text-sm">
                                    </div>
                                    
                                    <div>
                                        <label for="montant" class="block text-sm font-medium text-gray-700">Montant</label>
                                        <div class="mt-1 relative rounded-md shadow-sm">
                                            <input type="number" step="0.01" min="0.01" name="montant" id="montant" required class="block w-full pr-12 border-gray-300 rounded-md focus:ring-primary-500 focus:border-primary-500 sm:text-sm">
                                            <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                <span class="text-gray-500 sm:text-sm">€</span>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div>
                                        <label for="motif" class="block text-sm font-medium text-gray-700">Motif</label>
                                        <input type="text" name="motif" id="motif" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500 sm:text-sm">
                                    </div>
                                    
                                    <div>
                                        <button type="submit" class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-primary-600 hover:bg-primary-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500">
                                            Effectuer le virement
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        
                        <div class="border-t border-gray-200">
                            <div class="px-4 py-5 sm:p-6">
                                <h4 class="text-md font-medium text-gray-900 mb-4">Votre ID de transfert</h4>
                                <div class="bg-gray-50 p-4 rounded-md border border-gray-200">
                                    <p class="text-center font-mono text-lg"><?php echo $identite ? $identite['code_transfert'] : 'Aucun ID généré'; ?></p>
                                </div>
                                
                                <?php if(!$identite || !$identite['code_transfert']): ?>
                                <form action="" method="POST" class="mt-4">
                                    <input type="hidden" name="action" value="generer_id">
                                    <button type="submit" class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-primary-600 hover:bg-primary-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500">
                                        Générer un ID de transfert
                                    </button>
                                </form>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="border-t border-gray-200">
                            <div class="px-4 py-5 sm:p-6">
                                <h4 class="text-md font-medium text-gray-900 mb-4">Dernières transactions</h4>
                                
                                <div class="overflow-x-auto">
                                    <table class="min-w-full divide-y divide-gray-200">
                                        <thead class="bg-gray-50">
                                            <tr>
                                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Type</th>
                                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Destinataire/Émetteur</th>
                                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Montant</th>
                                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Motif</th>
                                            </tr>
                                        </thead>
                                        <tbody class="bg-white divide-y divide-gray-200">
                                            <?php
                                            $sql = "SELECT * FROM transactions WHERE user_id = ? OR destinataire_id = ? ORDER BY date DESC LIMIT 10";
                                            $stmt = $conn->prepare($sql);
                                            $stmt->bind_param("ii", $user_id, $user_id);
                                            $stmt->execute();
                                            $result = $stmt->get_result();
                                            
                                            if($result->num_rows > 0) {
                                                while($transaction = $result->fetch_assoc()) {
                                                    $type = $transaction['user_id'] == $user_id ? 'Envoi' : 'Réception';
                                                    $montant = $transaction['montant'];
                                                    $montantClass = $type == 'Envoi' ? 'text-red-600' : 'text-green-600';
                                                    $montantPrefix = $type == 'Envoi' ? '-' : '+';
                                                    
                                                    echo '<tr>';
                                                    echo '<td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">' . date('d/m/Y H:i', strtotime($transaction['date'])) . '</td>';
                                                    echo '<td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">' . $type . '</td>';
                                                    echo '<td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">' . ($type == 'Envoi' ? $transaction['destinataire_nom'] : $transaction['emetteur_nom']) . '</td>';
                                                    echo '<td class="px-6 py-4 whitespace-nowrap text-sm ' . $montantClass . '">' . $montantPrefix . number_format($montant, 2, ',', ' ') . ' €</td>';
                                                    echo '<td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">' . $transaction['motif'] . '</td>';
                                                    echo '</tr>';
                                                }
                                            } else {
                                                echo '<tr><td colspan="5" class="px-6 py-4 text-sm text-gray-500 text-center">Aucune transaction récente</td></tr>';
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="tab-content <?php echo $onglet == 'courrier' ? 'active' : ''; ?>" id="tab-courrier">
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <div class="md:col-span-1">
                            <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                                <div class="px-4 py-5 sm:px-6">
                                    <h3 class="text-lg leading-6 font-medium text-gray-900">
                                        Boîte de réception
                                    </h3>
                                </div>
                                <div class="border-t border-gray-200">
                                    <ul class="divide-y divide-gray-200">
                                        <?php if(count($courriers) > 0): ?>
                                            <?php foreach($courriers as $index => $courrier): ?>
                                                <li>
                                                    <a href="https://peerkinton.com/dashboard.php?onglet=courrier&courrier_id=<?php echo $courrier['id']; ?>" class="block hover:bg-gray-50 <?php echo (isset($_GET['courrier_id']) && $_GET['courrier_id'] == $courrier['id']) ? 'bg-primary-50' : ''; ?>">
                                                        <div class="px-4 py-4 sm:px-6">
                                                            <div class="flex items-center justify-between">
                                                                <p class="text-sm font-medium text-primary-600 truncate">
                                                                    <?php echo htmlspecialchars($courrier['sujet']); ?>
                                                                </p>
                                                                <div class="ml-2 flex-shrink-0 flex">
                                                                    <?php if($courrier['type'] == 'facture'): ?>
                                                                        <p class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800">
                                                                            Facture
                                                                        </p>
                                                                    <?php elseif($courrier['type'] == 'communication'): ?>
                                                                        <p class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-blue-100 text-blue-800">
                                                                            Communication
                                                                        </p>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                            <div class="mt-2 flex justify-between">
                                                                <div class="flex items-center text-sm text-gray-500">
                                                                    <span><?php echo htmlspecialchars($courrier['expediteur']); ?></span>
                                                                </div>
                                                                <div class="text-sm text-gray-500">
                                                                    <span><?php echo date('d/m/Y', strtotime($courrier['date'])); ?></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </li>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <li class="px-4 py-5 sm:px-6 text-sm text-gray-500 text-center">
                                                Aucun courrier reçu
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        
                        <div class="md:col-span-2">
                            <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                                <?php
                                $courrier_details = null;
                                if(isset($_GET['courrier_id'])) {
                                    $courrier_id = $_GET['courrier_id'];
                                    foreach($courriers as $c) {
                                        if($c['id'] == $courrier_id) {
                                            $courrier_details = $c;
                                            break;
                                        }
                                    }
                                }
                                
                                if($courrier_details):
                                ?>
                                    <div class="px-4 py-5 sm:px-6">
                                        <h3 class="text-lg leading-6 font-medium text-gray-900">
                                            <?php echo htmlspecialchars($courrier_details['sujet']); ?>
                                        </h3>
                                        <p class="mt-1 max-w-2xl text-sm text-gray-500">
                                            De: <?php echo htmlspecialchars($courrier_details['expediteur']); ?> • 
                                            <?php echo date('d/m/Y à H:i', strtotime($courrier_details['date'])); ?>
                                        </p>
                                    </div>
                                    <div class="border-t border-gray-200 px-4 py-5 sm:px-6">
                                        <div class="prose max-w-none">
                                            <?php echo $courrier_details['contenu']; ?>
                                        </div>
                                        
                                        <?php if($courrier_details['type'] == 'facture'): ?>
                                            <div class="mt-6 border-t border-gray-200 pt-6">
                                                <div class="flex justify-between items-center">
                                                    <div>
                                                        <p class="text-sm font-medium text-gray-700">Montant à payer:</p>
                                                        <p class="text-2xl font-semibold text-gray-900"><?php echo number_format($courrier_details['montant'], 2, ',', ' '); ?> Fcoin</p>
                                                    </div>
                                                    
                                                    <?php if(!$courrier_details['paye']): ?>
                                                        <form action="" method="POST">
                                                            <input type="hidden" name="action" value="regler_facture">
                                                            <input type="hidden" name="facture_id" value="<?php echo $courrier_details['id']; ?>">
                                                            <button type="submit" class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-primary-600 hover:bg-primary-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500">
                                                                Régler cette facture
                                                            </button>
                                                        </form>
                                                    <?php else: ?>
                                                        <div class="px-4 py-2 bg-green-100 text-green-800 rounded-md">
                                                            Facture réglée le <?php echo date('d/m/Y', strtotime($courrier_details['date_paiement'])); ?>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php else: ?>
                                    <div class="px-4 py-5 sm:px-6 text-center text-gray-500">
                                        <i class="fas fa-envelope-open-text text-5xl mb-3"></i>
                                        <p>Sélectionnez un message pour le consulter</p>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="tab-content <?php echo $onglet == 'identite' ? 'active' : ''; ?>" id="tab-identite">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                                <div class="px-4 py-5 sm:px-6">
                                    <h3 class="text-lg leading-6 font-medium text-gray-900">
                                        Carte d'identité
                                    </h3>
                                    <p class="mt-1 max-w-2xl text-sm text-gray-500">
                                        Vos informations personnelles.
                                    </p>
                                </div>
                                
                                <?php if($identite): ?>
                                    <div class="border-t border-gray-200">
                                        <div class="p-6 bg-gradient-to-r from-primary-600 to-primary-800 rounded-lg mx-4 my-5 text-white shadow-lg">
                                            <div class="flex justify-between items-start mb-6">
                                                <div>
                                                    <h4 class="text-xl font-bold mb-1">Peerkinton</h4>
                                                    <p class="text-sm opacity-80">Carte Nationale d'Identité</p>
                                                </div>
                                                <div class="text-right">
                                                    <p class="text-sm opacity-80">ID: <?php echo $identite['id_carte']; ?></p>
                                                </div>
                                            </div>
                                            
                                            <div class="grid grid-cols-2 gap-4 mb-4">
                                                <div>
                                                    <p class="text-xs opacity-80">Nom</p>
                                                    <p class="font-medium"><?php echo $identite['nom']; ?></p>
                                                </div>
                                                <div>
                                                    <p class="text-xs opacity-80">Prénom</p>
                                                    <p class="font-medium"><?php echo $identite['prenom']; ?></p>
                                                </div>
                                                <div>
                                                    <p class="text-xs opacity-80">Date de naissance</p>
                                                    <p class="font-medium"><?php echo date('d/m/Y', strtotime($identite['date_naissance'])); ?></p>
                                                </div>
                                                <div>
                                                    <p class="text-xs opacity-80">Lieu de naissance</p>
                                                    <p class="font-medium"><?php echo $identite['lieu_naissance']; ?></p>
                                                </div>
                                                <div>
                                                    <p class="text-xs opacity-80">Nationalité</p>
                                                    <p class="font-medium"><?php echo $identite['nationalite']; ?></p>
                                                </div>
                                                <div>
                                                    <p class="text-xs opacity-80">Sexe</p>
                                                    <p class="font-medium"><?php echo $identite['sexe']; ?></p>
                                                </div>
                                            </div>
                                            
                                            <div class="mt-6 pt-4 border-t border-white border-opacity-20 flex justify-between items-center">
                                                <div>
                                                    <p class="text-xs opacity-80">Date d'émission</p>
                                                    <p class="font-medium"><?php echo date('d/m/Y', strtotime($identite['date_emission'])); ?></p>
                                                </div>
                                                <div class="text-right">
                                                    <p class="text-xs opacity-80">Date d'expiration</p>
                                                    <p class="font-medium"><?php echo date('d/m/Y', strtotime($identite['date_expiration'])); ?></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <div class="border-t border-gray-200 px-4 py-5 sm:p-6 text-center">
                                        <p class="text-gray-500">Aucune carte d'identité trouvée.</p>
                                    </div>
                                <?php endif; ?>
                            </div>
                            
                            <div class="mt-6 bg-white shadow overflow-hidden sm:rounded-lg">
                                <div class="px-4 py-5 sm:px-6">
                                    <h3 class="text-lg leading-6 font-medium text-gray-900">
                                        Niveau de notoriété
                                    </h3>
                                </div>
                                <div class="border-t border-gray-200 px-4 py-5 sm:p-6">
                                    <?php
                                    if($identite) {
                                        $notoriete = $identite['notoriete'];
                                        
                                        if($notoriete >= 80) {
                                            $niveau = "Excellente";
                                            $couleur = "green";
                                        } elseif($notoriete >= 60) {
                                            $niveau = "Bonne";
                                            $couleur = "blue";
                                        } elseif($notoriete >= 40) {
                                            $niveau = "Moyenne";
                                            $couleur = "yellow";
                                        } elseif($notoriete >= 20) {
                                            $niveau = "Mauvaise";
                                            $couleur = "orange";
                                        } else {
                                            $niveau = "Très mauvaise";
                                            $couleur = "red";
                                        }
                                    }
                                    ?>
                                    
                                    <?php if($identite): ?>
                                        <div class="text-center mb-4">
                                            <span class="px-3 py-1 text-sm font-medium rounded-full bg-<?php echo $couleur; ?>-100 text-<?php echo $couleur; ?>-800">
                                                <?php echo $niveau; ?>
                                            </span>
                                        </div>
                                        
                                        <div class="relative pt-1">
                                            <div class="overflow-hidden h-2 mb-4 text-xs flex rounded bg-gray-200">
                                                <div style="width:<?php echo $notoriete; ?>%" class="shadow-none flex flex-col text-center whitespace-nowrap text-white justify-center bg-<?php echo $couleur; ?>-500"></div>
                                            </div>
                                        <div class="flex justify-between text-xs text-gray-600">
                                                <span>0%</span>
                                                <span>50%</span>
                                                <span>100%</span>
                                            </div>
                                        </div>
                                        
                                        <p class="mt-4 text-sm text-gray-600">
                                            Votre notoriété est basée sur vos activités dans la ville. Maintenir une bonne notoriété vous donne accès à plus d'opportunités.
                                        </p>
                                    <?php else: ?>
                                        <p class="text-center text-gray-500">Aucune information de notoriété disponible.</p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        
                        <div>
                            <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                                <div class="px-4 py-5 sm:px-6">
                                    <h3 class="text-lg leading-6 font-medium text-gray-900">
                                        Casier judiciaire
                                    </h3>
                                    <p class="mt-1 max-w-2xl text-sm text-gray-500">
                                        Historique des infractions.
                                    </p>
                                </div>
                                <div class="border-t border-gray-200">
                                    <?php if(count($casier) > 0): ?>
                                        <ul class="divide-y divide-gray-200">
                                            <?php foreach($casier as $infraction): ?>
                                                <li class="px-4 py-4 sm:px-6">
                                                    <div class="flex items-start justify-between">
                                                        <div>
                                                            <h4 class="text-sm font-medium text-gray-900"><?php echo $infraction['type']; ?></h4>
                                                            <p class="mt-1 text-sm text-gray-600"><?php echo $infraction['description']; ?></p>
                                                        </div>
                                                        <div class="ml-4 flex-shrink-0">
                                                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-red-800">
                                                                <?php echo date('d/m/Y', strtotime($infraction['date'])); ?>
                                                            </span>
                                                        </div>
                                                    </div>
                                                    <div class="mt-2">
                                                        <div class="flex items-center text-sm text-gray-500">
                                                            <span>Sanction: <?php echo $infraction['sanction']; ?></span>
                                                        </div>
                                                    </div>
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    <?php else: ?>
                                        <div class="px-4 py-5 sm:p-6 text-center">
                                            <div class="mb-4">
                                                <i class="fas fa-check-circle text-green-500 text-4xl"></i>
                                            </div>
                                            <h4 class="text-lg font-medium text-gray-900 mb-2">Casier judiciaire vierge</h4>
                                            <p class="text-gray-500">Vous n'avez commis aucune infraction.</p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <div class="mt-6 bg-white shadow overflow-hidden sm:rounded-lg">
                                <div class="px-4 py-5 sm:px-6">
                                    <h3 class="text-lg leading-6 font-medium text-gray-900">
                                        Informations additionnelles
                                    </h3>
                                </div>
                                <div class="border-t border-gray-200">
                                    <dl>
                                        <?php if($identite): ?>
                                            <div class="bg-gray-50 px-4 py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                                                <dt class="text-sm font-medium text-gray-500">Adresse</dt>
                                                <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2"><?php echo $identite['adresse']; ?></dd>
                                            </div>
                                            <div class="bg-white px-4 py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                                                <dt class="text-sm font-medium text-gray-500">Téléphone</dt>
                                                <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2"><?php echo $identite['telephone']; ?></dd>
                                            </div>
                                            <div class="bg-gray-50 px-4 py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                                                <dt class="text-sm font-medium text-gray-500">Email</dt>
                                                <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2"><?php echo $user['email']; ?></dd>
                                            </div>
                                            <div class="bg-white px-4 py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                                                <dt class="text-sm font-medium text-gray-500">Profession</dt>
                                                <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2"><?php echo $identite['profession']; ?></dd>
                                            </div>
                                        <?php else: ?>
                                            <div class="px-4 py-5 sm:p-6 text-center">
                                                <p class="text-gray-500">Aucune information additionnelle disponible.</p>
                                            </div>
                                        <?php endif; ?>
                                    </dl>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const tabs = document.querySelectorAll('a[href^="?onglet="]');
            const tabContents = document.querySelectorAll('.tab-content');
            
            tabs.forEach(tab => {
                tab.addEventListener('click', function(e) {
                    e.preventDefault();
                    const onglet = this.getAttribute('href').replace('?onglet=', '');
                    
                    tabs.forEach(t => {
                        t.classList.remove('border-primary-500', 'text-primary-600');
                        t.classList.add('border-transparent', 'text-gray-500', 'hover:text-gray-700', 'hover:border-gray-300');
                    });
                    
                    this.classList.add('border-primary-500', 'text-primary-600');
                    this.classList.remove('border-transparent', 'text-gray-500', 'hover:text-gray-700', 'hover:border-gray-300');
                    
                    tabContents.forEach(content => {
                        content.classList.remove('active');
                    });
                    
                    document.getElementById('tab-' + onglet).classList.add('active');
                    
                    window.history.pushState({}, '', '?onglet=' + onglet);
                });
            });
        });
    </script>
</body>
</html>