<?php
require_once 'db.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $db = getDB1Connection();
        
        $userId = $_POST['user-id'];
        $email = $_POST['email'];
        $username = $_POST['username'];
        $password = $_POST['password'];
        $note = $_POST['note']; // Ajout de la note

        // Préparation de la requête de base
        $updateFields = ['email = ?', 'username = ?', 'note = ?'];
        $params = [$email, $username, $note];

        // Si un nouveau mot de passe est fourni, on l'ajoute à la mise à jour
        if (!empty($password)) {
            $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
            $updateFields[] = 'password = ?';
            $params[] = $hashedPassword;
        }

        // Ajout de l'ID à la fin des paramètres
        $params[] = $userId;

        // Construction de la requête SQL
        $sql = "UPDATE utilisateurs SET " . implode(', ', $updateFields) . " WHERE id = ?";
        
        // Exécution de la requête
        $stmt = $db->prepare($sql);
        $stmt->execute($params);

        if($stmt->rowCount() > 0) {
            echo json_encode([
                'success' => true,
                'message' => 'User updated successfully'
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'No changes were made'
            ]);
        }

    } catch(PDOException $e) {
        echo json_encode([
            'success' => false,
            'message' => 'Database error: ' . $e->getMessage()
        ]);
    } catch(Exception $e) {
        echo json_encode([
            'success' => false,
            'message' => 'Error: ' . $e->getMessage()
        ]);
    }
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Invalid request method'
    ]);
}