<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Produits OMP - Imators</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @keyframes scroll-text {
            0% { transform: translateX(100%) }
            100% { transform: translateX(-100%) }
        }
        .scroll-animation {
            animation: scroll-text 20s linear infinite;
        }
        .scroll-animation:hover {
            animation-play-state: paused;
        }
        .bg-parallax {
            background-attachment: fixed;
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
        }
        .status-beta { color: #f59e0b; }
        .status-maintenance { color: #ef4444; }
        .status-online { color: #10b981; }
    </style>
</head>
<body class="font-sans">
    
    <section class="relative h-screen bg-parallax overflow-hidden" style="background-image: url('https://images.unsplash.com/photo-1518709268805-4e9042af2176?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2025&q=80')">
        <div class="absolute inset-0 bg-black bg-opacity-50"></div>
        
        <div class="relative z-10 h-full flex flex-col justify-center px-8 lg:px-16">
            <h1 class="text-8xl font-bold text-white text-left mb-8">
                GAMME OMP
            </h1>
        </div>
        
        <div class="absolute bottom-0 left-0 right-0 bg-white bg-opacity-10 backdrop-blur-sm h-16 flex items-center overflow-hidden">
            <div class="scroll-animation whitespace-nowrap text-white text-xl font-medium">
                Solutions professionnelles • Technologies avancées • Innovation continue • Performance optimale • Expertise technique • Support premium • Solutions professionnelles • Technologies avancées • Innovation continue • Performance optimale • Expertise technique • Support premium
            </div>
        </div>
    </section>

    <section class="py-16 bg-gray-50">
        <div class="container mx-auto px-8 lg:px-16">
            <div id="products-list" class="space-y-8">
                
            </div>
        </div>
    </section>

    <script>
        const products = [
            {
                name: "OMP Analytics",
                description: "Plateforme d'analyse de données en temps réel avec tableaux de bord personnalisables et insights automatiques.",
                logo: "https://images.unsplash.com/photo-1551288049-bebda4e38f71?ixlib=rb-4.0.3&auto=format&fit=crop&w=100&q=80"
            },
            {
                name: "OMP Cloud",
                description: "Infrastructure cloud sécurisée et scalable pour héberger vos applications critiques avec haute disponibilité.",
                logo: "https://images.unsplash.com/photo-1544197150-b99a580bb7a8?ixlib=rb-4.0.3&auto=format&fit=crop&w=100&q=80"
            },
            {
                name: "OMP Security",
                description: "Suite de sécurité complète incluant monitoring, détection d'intrusions et protection contre les cybermenaces.",
                logo: "https://images.unsplash.com/photo-1563013544-824ae1b704d3?ixlib=rb-4.0.3&auto=format&fit=crop&w=100&q=80"
            },
            {
                name: "OMP Workflow",
                description: "Automatisation des processus métier avec designer visuel et intégrations natives aux principaux ERP.",
                logo: "https://images.unsplash.com/photo-1454165804606-c3d57bc86b40?ixlib=rb-4.0.3&auto=format&fit=crop&w=100&q=80"
            }
        ];

        function getRandomStatus() {
            const statuses = ['beta', 'maintenance', 'online'];
            return statuses[Math.floor(Math.random() * statuses.length)];
        }

        function getStatusDisplay(status) {
            const statusMap = {
                'beta': { text: 'BETA', class: 'status-beta' },
                'maintenance': { text: 'MAINTENANCE', class: 'status-maintenance' },
                'online': { text: 'ONLINE', class: 'status-online' }
            };
            return statusMap[status];
        }

        function renderProducts() {
            const productsList = document.getElementById('products-list');
            productsList.innerHTML = '';
            
            products.forEach(product => {
                const status = getRandomStatus();
                const statusInfo = getStatusDisplay(status);
                
                const productDiv = document.createElement('div');
                productDiv.className = 'bg-white rounded-lg shadow-lg p-8 flex items-center justify-between hover:shadow-xl transition-shadow duration-300';
                
                productDiv.innerHTML = `
                    <div class="flex-1">
                        <h3 class="text-3xl font-bold text-gray-900 mb-4">${product.name}</h3>
                        <p class="text-lg text-gray-600 mb-4 max-w-2xl">${product.description}</p>
                        <div class="flex items-center">
                            <span class="text-sm font-semibold ${statusInfo.class}">${statusInfo.text}</span>
                        </div>
                    </div>
                    <div class="ml-8">
                        <img src="${product.logo}" alt="${product.name}" class="w-24 h-24 rounded-lg object-cover">
                    </div>
                `;
                
                productsList.appendChild(productDiv);
            });
        }

        renderProducts();
        setInterval(renderProducts, 1000);
    </script>

</body>
</html>