<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>About Imators</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.1.2/dist/tailwind.min.css">
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css" />
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@2.8.0/dist/alpine.min.js" defer></script>
</head>
    <style>
    
        @import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap');
        body {
            font-family: 'Space Grotesk', sans-serif;
        }
        
        .gradient-background {
            background: rgb(34,193,195);
            background: linear-gradient(0deg, rgba(34,193,195,1) 0%, rgba(167,45,253,1) 100%);
            color: #FFFFFF;
        }

        header {
            background-color: rgba(0, 0, 0, 0.8); 
            transition: background-color 0.5s;
        }
        .menu-link {
            transition: color 0.3s ease-in-out;
            color: #FFF !important; 
        }
        .footer, .mobile-menu {
            background-color: #111827;
            color: #FFF;
        }

        .coc {
            background-color: #111827;
        }

        .timeline {
            position: relative;
        }
        .timeline::before {
            content: '';
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            top: 0;
            bottom: 0;
            width: 2px;
            background: #D1D5DB;
        }
        .timeline-item {
            position: relative;
            width: 100%;
            padding: 10px 40px;
            margin-bottom: 20px;
        }
        .timeline-marker {
            position: absolute;
            top: 15px;
            left: 50%;
            transform: translateX(-50%);
            height: 20px;
            width: 20px;
            border-radius: 50%;
            background: #3B82F6;
        }
        .timeline-content {
            max-width: 40%;
            padding: 20px;
            background: #F9FAFB;
            border-radius: 8px;
        }
        .timeline-item:nth-child(even) .timeline-content {
            margin-left: auto;
            background: #EFF6FF;
        }

        .parallax-container {
            perspective: 2px;
        }
        .parallax-background {
            transform: translateZ(-1px) scale(2);
            min-height: 100vh;
            background-size: cover;
            background-position: center;
        }
        .content {
            position: relative;
        }
        
        .fade-in-section {
            transition: opacity 0.6s ease-out, transform 1s ease-out;
            opacity: 0;
            transform: translateY(20px);
            visibility: hidden;
        }
        .fade-in-section.is-visible {
            opacity: 1;
            transform: none;
            visibility: visible;
        }

   
        
        @keyframes gradient {
            0% {
                background-position: 0% 50%;
            }
            50% {
                background-position: 100% 50%;
            }
            100% {
                background-position: 0% 50%;
            }
        }

        .gradient-bg {
            background: linear-gradient(-45deg, #6b1839, #1c4b82, #076b3b);
            background-size: 400% 400%;
            animation: gradient 15s ease infinite;
        }

        /* Style pour les images arrondies */
        .rounded-image {
            border-radius: 1rem; /* Arrondi des images */
            overflow: hidden;
        }
    </style>

</head>
<body class="bg-black text-white">
<?php include 'src/header.php'; ?>

    <section class="py-20">
        <div class="container px-4 mx-auto ">
          <div class="max-w-xl lg:max-w-2xl mx-auto text-center"></div>
        </div>
        <div class="h-96 mb-12 lg:mb-16">
          <img class="w-full h-full object-cover" src="banner.png" alt="">
        </div>
        <div class="container px-4 mx-auto">
          <div class="max-w-2xl mx-auto">
            <p class="mb-6 lg:mb-8 text-lg leading-loose lg:text-xl lg:leading-relaxed text-gray-500">At Imators, our fundamental mission is to revolutionise the current technological landscape by focusing on what truly matters. We aim to transcend the limitations of the present technological phase, paving the way for what we call the second technological era, transformative shift in how we interact with and use technology.
</p>
            <p class="mb-6 lg:mb-8 text-lg leading-loose lg:text-xl lg:leading-relaxed text-gray-500">Our future-oriented vision encompasses the development of modern tools and solutions on a global scale, whilst steadfastly protecting humanity's autonomy in decision-making. We maintain an unwavering commitment to ethical technological advancement: you won't find us developing robots or artificial intelligence systems that could potentially harm humans or promote indolence. Instead, our innovations are designed to enhance human capabilities whilst preserving human agency.
             A cornerstone of our mission is to guide society towards a more thoughtful and balanced relationship with technology. Whilst our aspiration to become an integral part of daily life might sound ambitious, we emphasise that our presence will be constructive rather than overwhelming. We seek to illuminate rather than obscure reality, helping people maintain their connection to the world around them.</p>
            <p class="text-lg leading-loose lg:text-xl lg:leading-relaxed text-gray-500">Imators is dedicated to leading our clients towards a brighter future. We strive to create solutions that bring greater serenity and convenience to modern life, all whilst safeguarding the essential qualities that make us human. Our commitment lies in enhancing life through technology, not replacing human experience with it.</p>
          </div>
        </div>
      </section>


<script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>
<script>
    var swiper = new Swiper('.swiper-container', {
        slidesPerView: 1,
        spaceBetween: 30,
        pagination: {
            el: '.swiper-pagination',
            clickable: true,
        },
        breakpoints: {
            640: {
                slidesPerView: 2,
                spaceBetween: 20,
            },
            768: {
                slidesPerView: 3,
                spaceBetween: 40,
            },
            1024: {
                slidesPerView: 4,
                spaceBetween: 50,
            },
        }
    });

    window.addEventListener('scroll', () => {
        document.querySelectorAll('.fade-in-section').forEach((el) => {
            const scrollY = window.scrollY + window.innerHeight;
            const elementTop = el.getBoundingClientRect().top + window.scrollY;
            const isVisible = scrollY > elementTop + 100; // Offset de 100px pour un effet plus t�t

            if (isVisible) {
                el.classList.add('is-visible');
            }
        });
    });

    document.getElementById('mobile-menu-button').addEventListener('click', function() {
        document.getElementById('mobile-menu').classList.remove('hidden');
      });
    
      document.getElementById('mobile-menu-close').addEventListener('click', function() {
        document.getElementById('mobile-menu').classList.add('hidden');
      });
</script>

<script src="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.js"></script>
<script>
    AOS.init();

document.addEventListener("DOMContentLoaded", function() {
    // S lectionne tous les  l ments d clencheurs de l'effet de glissement
    const triggers = document.querySelectorAll('.slide-trigger');

    triggers.forEach(trigger => {
        trigger.addEventListener('click', function(e) {
            e.preventDefault(); // Emp che le comportement par d faut des liens
            const targetId = this.getAttribute('href'); // R cup re l'ID de la cible depuis l'attribut href
            const targetElement = document.querySelector(targetId); // S lectionne l' l ment cible
            
            // V rifie si l' l ment cible existe
            if (targetElement) {
                // Fait d filer jusqu'  l' l ment cible avec un effet doux
                targetElement.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });
});

</script>

<footer class="bg-black text-white">
        <div class="max-w-6xl mx-auto px-4 py-10 flex flex-wrap justify-between">
            <div class="w-full md:w-1/3 p-5">
            <h5 class="text-xs uppercase font-medium mb-6">Follow Us</h5>
                <div class="flex items-center space-x-4">
                    <a href="https://instagram.com/itsimators" class="text-sm font-medium duration-700 hover:text-gray-100 flex items-center">
                        
                        <span>Instagram</span>
                    </a>
                </div>
            </div>
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Discover</h5>
                <a href="/privacy" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Privacy Policy</a>
                <a href="/terms-of-use" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Terms of Use</a>
                <a href="/" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Home</a>
                <a href="/about-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">About Us</a>
                <a href="/contact-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Contact Us</a>
            </div>
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Possible reality</h5>
                <p class="text-sm">All images, videos, and content on this site are the property of Imators.</p>
            </div>
        </div>
        <div class="text-center py-4 border-t border-gray-800">
            <p class="text-sm mb-2">&copy; 2025 Imators. All rights reserved.</p>
            <p class="text-xs">Imators is a registered LLC (Limited Liability Company). All our products, whether technologically physical or simply online, are subject to our rules, which you can access.</p>
        </div>
    </footer>


</body>


</body>
</html>
