const express = require('express');
const http = require('http');
const socketIo = require('socket.io');
const bodyParser = require('body-parser');

const app = express();
const server = http.createServer(app);
const io = socketIo(server);

app.use(bodyParser.json());
app.use(express.static('.'));

app.post('/notify', (req, res) => {
    const { event, data } = req.body;
    
    switch (event) {
        case 'newTrafficLight':
            io.emit('newTrafficLight', data);
            break;
        case 'updateTrafficLight':
            io.emit('trafficLightUpdate', data);
            break;
    }
    
    res.json({ success: true });
});

io.on('connection', (socket) => {
    console.log('Client connected');
    
    socket.on('disconnect', () => {
        console.log('Client disconnected');
    });
});

const PORT = process.env.PORT || 80;
server.listen(PORT, () => {
    console.log(`Server running on port ${PORT}`);
});