<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Services - AktasCorp</title>
    <link rel="icon" type="image/png" href="ac.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Raleway:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Raleway', sans-serif;
            background-color: #f9f0e6;
        }
    </style>
</head>
<body class="text-gray-800">
    <div class="max-w-4xl mx-auto px-4 py-20">
        <header class="mb-24">
            <h1 class="text-4xl font-light tracking-wider">Our Services</h1>
            <p class="text-sm">Explore our range of development and consulting services tailored for modern businesses.</p>
        </header>

        <main>
            <section class="mb-12">
                <h2 class="text-2xl font-light mb-6">Web Development</h2>
                <p class="mb-6">
                    Custom websites, web applications, and e-commerce solutions built with modern technologies. We focus on performance, security, and user experience to deliver professional digital solutions.</p>
                <ul class="space-y-4">
                    <li>- Business websites from $1,500</li>
                    <li>- E-commerce platforms from $3,500</li>
                    <li>- Custom web applications from $5,000</li>
                    <li>- Monthly maintenance $150/month</li>
                </ul>
            </section>

            <section class="mb-12">
                <h2 class="text-2xl font-light mb-6">Design & Branding</h2>
                <p class="mb-6">
                    Professional visual identity creation, logo design, and brand guidelines. We help establish a strong visual presence that reflects your business values and connects with your audience.</p>
                <ul class="space-y-4">
                    <li>- Logo design $350</li>
                    <li>- Complete brand identity $1,200</li>
                    <li>- Brand guidelines $800</li>
                    <li>- UI/UX design $150/day</li>
                </ul>
            </section>

            <section class="mb-12">
                <h2 class="text-2xl font-light mb-6">Digital Strategy</h2>
                <p class="mb-6">
                    SEO optimization, social media management, and digital marketing campaigns. We develop strategies to increase your online visibility and drive meaningful engagement with your target audience.</p>
                <ul class="space-y-4">
                    <li>- SEO audit $500</li>
                    <li>- Monthly SEO optimization $200/month</li>
                    <li>- Social media management $400/month</li>
                    <li>- Advertising campaigns $300 + ad budget</li>
                </ul>
            </section>

            <section class="mb-12">
                <h2 class="text-2xl font-light mb-6">Consulting & Training</h2>
                <p class="mb-6">
                    Technical consulting, strategic guidance, and professional training sessions. We provide expertise to help you make informed decisions and develop your team's capabilities.</p>
                <ul class="space-y-4">
                    <li>- Strategic consultation $120/hour</li>
                    <li>- Technical training $800/day</li>
                    <li>- Technical audit $600</li>
                    <li>- Support services $80/hour</li>
                </ul>
            </section>

            <section class="mb-12">
                <h2 class="text-2xl font-light mb-6">Contact</h2>
                <p>
                    For project discussions or custom quotes, reach out to our team at msg@aktascorp.com
                </p>
            </section>
        </main>

        <footer class="mt-24 pt-6 border-t border-gray-200 text-sm text-gray-500">
            <p>&copy; 2025 AktasCorporation. All rights reserved.</p>
        </footer>
    </div>
</body>
</html>