<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Services - AktasCorp</title>
    <link rel="icon" type="image/png" href="ac.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Raleway:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Raleway', sans-serif;
            background-color: #f9f0e6;
        }
    </style>
</head>
<body class="text-gray-800">
    <div class="max-w-4xl mx-auto px-4 py-20">
        <header class="mb-24">
            <h1 class="text-4xl font-light tracking-wider">Our Services</h1>
            <p class="text-sm">Explore our range of development and consulting services tailored for modern businesses.</p>
        </header>

        <main>
            <section class="mb-12">
                <h2 class="text-2xl font-light mb-6">Web Development</h2>
                <p class="mb-6">
                    Custom websites, web applications, and e-commerce solutions built with modern technologies. We focus on performance, security, and user experience to deliver professional digital solutions.</p>
                <div class="grid grid-cols-1 md:grid-cols-4 gap-6 border-t border-gray-200 pt-4">
                    <div class="border-r border-gray-200 pr-4">Business websites<br><span class="font-semibold">from $1,500</span></div>
                    <div class="border-r border-gray-200 pr-4">E-commerce platforms<br><span class="font-semibold">from $3,500</span></div>
                    <div class="border-r border-gray-200 pr-4">Custom web applications<br><span class="font-semibold">from $5,000</span></div>
                    <div>Monthly maintenance<br><span class="font-semibold">$30/month</span></div>
                </div>
            </section>

            <section class="mb-12">
                <h2 class="text-2xl font-light mb-6">Design & Branding</h2>
                <p class="mb-6">
                    Professional visual identity creation, logo design, and brand guidelines. We help establish a strong visual presence that reflects your business values and connects with your audience.</p>
                <div class="grid grid-cols-1 md:grid-cols-4 gap-6 border-t border-gray-200 pt-4">
                    <div class="border-r border-gray-200 pr-4">Logo design<br><span class="font-semibold">$350</span></div>
                    <div class="border-r border-gray-200 pr-4">Complete brand identity<br><span class="font-semibold">$1,200</span></div>
                    <div class="border-r border-gray-200 pr-4">Brand guidelines<br><span class="font-semibold">$800</span></div>
                    <div>UI/UX design<br><span class="font-semibold">$150/day</span></div>
                </div>
            </section>

            <section class="mb-12">
                <h2 class="text-2xl font-light mb-6">Digital Strategy</h2>
                <p class="mb-6">
                    SEO optimization, social media management, and digital marketing campaigns. We develop strategies to increase your online visibility and drive meaningful engagement with your target audience.</p>
                <div class="grid grid-cols-1 md:grid-cols-4 gap-6 border-t border-gray-200 pt-4">
                    <div class="border-r border-gray-200 pr-4">SEO audit<br><span class="font-semibold">$500</span></div>
                    <div class="border-r border-gray-200 pr-4">Monthly SEO optimization<br><span class="font-semibold">$200/month</span></div>
                    <div class="border-r border-gray-200 pr-4">Social media management<br><span class="font-semibold">$400/month</span></div>
                    <div>Advertising campaigns<br><span class="font-semibold">$300 + ad budget</span></div>
                </div>
            </section>

            <section class="mb-12">
                <h2 class="text-2xl font-light mb-6">Consulting & Training</h2>
                <p class="mb-6">
                    Technical consulting, strategic guidance, and professional training sessions. We provide expertise to help you make informed decisions and develop your team's capabilities.</p>
                <div class="grid grid-cols-1 md:grid-cols-4 gap-6 border-t border-gray-200 pt-4">
                    <div class="border-r border-gray-200 pr-4">Strategic consultation<br><span class="font-semibold">$120/hour</span></div>
                    <div class="border-r border-gray-200 pr-4">Technical training<br><span class="font-semibold">$800/day</span></div>
                    <div class="border-r border-gray-200 pr-4">Technical audit<br><span class="font-semibold">$600</span></div>
                    <div>Support services<br><span class="font-semibold">$80/hour</span></div>
                </div>
            </section>

            <section class="mb-12">
                <h2 class="text-2xl font-light mb-6">Contact</h2>
                <p>
                    For project discussions or custom quotes, reach out to our team at msg@aktascorp.com
                </p>
            </section>
        </main>

        <footer class="mt-24 pt-6 border-t border-gray-200 text-sm text-gray-500">
            <p>&copy; 2025 AktasCorporation. All rights reserved.</p>
        </footer>
    </div>
</body>
</html>