<?php
include 'header.php';
include 'db.php';

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($id <= 0) {
    header('Location: media.php');
    exit;
}

$article = mysqli_query($conn, "SELECT *, DATE_FORMAT(date_publication, '%d/%m/%Y à %H:%i') as formatted_date FROM articles WHERE id = $id AND status = 'published'");

if (mysqli_num_rows($article) === 0) {
    header('Location: media.php');
    exit;
}

$article = mysqli_fetch_assoc($article);

$related = mysqli_query($conn, "SELECT id, title FROM articles WHERE id != $id AND status = 'published' ORDER BY date_publication DESC LIMIT 3");
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($article['title']) ?> - Vert Chasseur</title>
    <link rel="icon" type="image/png" href="logo_new.png">
    <meta name="description" content="<?= htmlspecialchars(substr($article['excerpt'] ?? $article['content'], 0, 160)) ?>">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    colors: {
                        dark: {
                            100: '#1e1e1e',
                            200: '#252525',
                            300: '#2d2d2d',
                            400: '#353535',
                            500: '#3a3a3a',
                        }
                    }
                }
            }
        }
    </script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Princess+Sofia&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            letter-spacing: -0.01em;
        }
        .txt-chasseur {
            font-family: "Princess Sofia", serif;
            font-weight: 400;
            font-style: normal;
        }
        .article-content {
            line-height: 1.8;
        }
        .article-content p {
            margin-bottom: 1.5rem;
        }
        .article-content h2 {
            font-size: 1.5rem;
            font-weight: 500;
            margin-top: 2rem;
            margin-bottom: 1rem;
        }
        .article-content h3 {
            font-size: 1.25rem;
            font-weight: 500;
            margin-top: 1.5rem;
            margin-bottom: 0.75rem;
        }
        .article-content ul, .article-content ol {
            margin-left: 1.5rem;
            margin-bottom: 1.5rem;
        }
        .article-content li {
            margin-bottom: 0.5rem;
        }
        .article-content a {
            color: #6366f1;
            text-decoration: underline;
        }
        .article-content a:hover {
            color: #4f46e5;
        }
    </style>
</head>
<body class="bg-white dark:bg-black text-black dark:text-white transition-colors duration-300">
    <script>
        if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
            document.documentElement.classList.add('dark');
        }
        window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', e => {
            if (e.matches) {
                document.documentElement.classList.add('dark');
            } else {
                document.documentElement.classList.remove('dark');
            }
        });
    </script>

    <main class="container mx-auto px-4 py-16 max-w-4xl">
        <div class="mb-8">
            <a href="actualites.php" class="inline-flex items-center text-gray-500 dark:text-gray-400 hover:text-black dark:hover:text-white">
                <i class="fas fa-arrow-left mr-2"></i>
                Retour aux actualités
            </a>
        </div>

        <article>
            <header class="mb-10">
                <h1 class="text-3xl md:text-4xl lg:text-5xl font-light mb-6 text-black dark:text-white">
                    <?= htmlspecialchars($article['title']) ?>
                </h1>
                
                <div class="flex flex-wrap items-center gap-6 text-gray-500 dark:text-gray-400 text-sm">
                    <div class="flex items-center">
                        <i class="fas fa-user mr-2"></i>
                        <span><?= htmlspecialchars($article['author']) ?></span>
                    </div>
                    
                    <div class="flex items-center">
                        <i class="fas fa-calendar mr-2"></i>
                        <span><?= $article['formatted_date'] ?></span>
                    </div>
                    
                    <?php if(!empty($article['category'])): ?>
                    <div class="flex items-center">
                        <i class="fas fa-tag mr-2"></i>
                        <span><?= htmlspecialchars($article['category']) ?></span>
                    </div>
                    <?php endif; ?>
                </div>
            </header>
            
            <div class="article-content prose prose-lg max-w-none dark:prose-invert mb-12 text-gray-800 dark:text-gray-200">
                <?= nl2br(htmlspecialchars($article['content'])) ?>
            </div>
        </article>
        
        <?php if(mysqli_num_rows($related) > 0): ?>
        <div class="mt-16 pt-8 border-t border-gray-100 dark:border-gray-800">
            <h3 class="text-xl font-medium text-black dark:text-white mb-6">Articles similaires</h3>
            
            <div class="grid gap-6 grid-cols-1 sm:grid-cols-2 lg:grid-cols-3">
                <?php while($relatedArticle = mysqli_fetch_assoc($related)): ?>
                <a href="article.php?id=<?= $relatedArticle['id'] ?>" class="block p-5 bg-white dark:bg-dark-200 rounded-xl border border-gray-100 dark:border-gray-800 hover:border-indigo-200 dark:hover:border-indigo-800 transition-colors shadow-sm hover:shadow-md">
                    <h4 class="text-lg font-medium text-black dark:text-white"><?= htmlspecialchars($relatedArticle['title']) ?></h4>
                </a>
                <?php endwhile; ?>
            </div>
        </div>
        <?php endif; ?>
    </main>

    <footer class="w-full py-8 mt-16 border-t border-gray-100 dark:border-gray-900">
        <p class="text-xs text-gray-500 dark:text-gray-400 text-center max-w-3xl mx-auto px-4">© 2025 Vert Chasseur · A <a href="https://aktascorp.com" class="underline hover:text-gray-600 dark:hover:text-gray-300">aktascorp</a> member · <a href="https://aktascorp.com/privacy" class="hover:text-gray-600 dark:hover:text-gray-300">Confidentialité</a></p>
    </footer>
</body>
</html>