<?php
session_start();

if (!isset($_SESSION['search_results']) || !isset($_SESSION['search_params'])) {
    header('Location: index.php');
    exit;
}

$type = $_GET['type'] ?? '';
$id = $_GET['id'] ?? '';
$package = $_GET['package'] ?? '';

if (empty($type) || (empty($id) && empty($package))) {
    header('Location: results.php');
    exit;
}

$results = $_SESSION['search_results'];
$params = $_SESSION['search_params'];

$selected_item = null;

if ($type === 'combined' && !empty($package)) {
    $selected_item = $results['data'] ?? null;
} else {
    if (isset($results['data']) && is_array($results['data'])) {
        foreach ($results['data'] as $item) {
            if (isset($item['id']) && $item['id'] == $id) {
                $selected_item = $item;
                break;
            }
        }
    }
}

if ($selected_item === null) {
    header('Location: results.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hizhat - Réservation</title>
    <link href="https://fonts.googleapis.com/css2?family=Lexend+Tera:wght@100;200;300;400;500;600;700&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        * {
            font-family: 'Lexend Tera', sans-serif;
        }

        .hero {
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }

        .line {
            height: 1px;
            background: #dedede;
        }
        
        .booking-card {
            border: 1px solid #dedede;
            border-radius: 10px;
        }
        
        .form-input {
            @apply w-full p-2 border rounded text-sm;
        }
    </style>
</head>
<body class="bg-gray-50">
    <div class="hero p-8">
        <header>
            <div class="flex items-center justify-center gap-6">
                <div class="line flex-1"></div>
                <a href="index.php" class="text-2xl font-light px-6">Hizhat</a>
                <div class="line flex-1"></div>
            </div>
        </header>

        <main class="flex flex-col items-center justify-center gap-8 my-12">
            <div class="w-full max-w-5xl">
                <div class="flex items-center justify-between mb-8">
                    <h2 class="text-2xl md:text-3xl font-light">Finaliser votre réservation</h2>
                    <a href="results.php" class="text-sm underline">Retour aux résultats</a>
                </div>
                
                <div class="flex flex-wrap">
                    <div class="w-full lg:w-2/3 pr-0 lg:pr-8 mb-8 lg:mb-0">
                        <div class="booking-card bg-white p-6 mb-6">
                            <h3 class="text-lg font-medium mb-4">Information de contact</h3>
                            
                            <form action="process_booking.php" method="POST" id="bookingForm">
                                <input type="hidden" name="booking_type" value="<?= htmlspecialchars($type) ?>">
                                <input type="hidden" name="item_id" value="<?= htmlspecialchars($id) ?>">
                                <?php if ($type === 'combined'): ?>
                                <input type="hidden" name="package_type" value="<?= htmlspecialchars($package) ?>">
                                <?php endif; ?>
                                
                                <div class="flex flex-wrap -mx-2 mb-4">
                                    <div class="w-full md:w-1/2 px-2 mb-4">
                                        <label class="block text-xs mb-1">Prénom</label>
                                        <input type="text" name="first_name" class="form-input" required>
                                    </div>
                                    <div class="w-full md:w-1/2 px-2 mb-4">
                                        <label class="block text-xs mb-1">Nom</label>
                                        <input type="text" name="last_name" class="form-input" required>
                                    </div>
                                </div>
                                
                                <div class="flex flex-wrap -mx-2 mb-4">
                                    <div class="w-full md:w-1/2 px-2 mb-4">
                                        <label class="block text-xs mb-1">Email</label>
                                        <input type="email" name="email" class="form-input" required>
                                    </div>
                                    <div class="w-full md:w-1/2 px-2 mb-4">
                                        <label class="block text-xs mb-1">Téléphone</label>
                                        <input type="tel" name="phone" class="form-input" required>
                                    </div>
                                </div>
                                
                                <?php if ($type === 'flight' || $type === 'train' || $type === 'combined'): ?>
                                <div class="mb-6">
                                    <h3 class="text-lg font-medium mb-4">Informations des voyageurs</h3>
                                    
                                    <div id="travelers-container">
                                        <div class="traveler-info border rounded p-4 mb-4">
                                            <h4 class="text-sm font-medium mb-2">Voyageur 1</h4>
                                            
                                            <div class="flex flex-wrap -mx-2 mb-4">
                                                <div class="w-full md:w-1/3 px-2 mb-4">
                                                    <label class="block text-xs mb-1">Prénom</label>
                                                    <input type="text" name="travelers[0][first_name]" class="form-input" required>
                                                </div>
                                                <div class="w-full md:w-1/3 px-2 mb-4">
                                                    <label class="block text-xs mb-1">Nom</label>
                                                    <input type="text" name="travelers[0][last_name]" class="form-input" required>
                                                </div>
                                                <div class="w-full md:w-1/3 px-2 mb-4">
                                                    <label class="block text-xs mb-1">Date de naissance</label>
                                                    <input type="date" name="travelers[0][dob]" class="form-input" required>
                                                </div>
                                            </div>
                                            
                                            <div class="flex flex-wrap -mx-2">
                                                <div class="w-full md:w-1/2 px-2 mb-4">
                                                    <label class="block text-xs mb-1">Nationalité</label>
                                                    <input type="text" name="travelers[0][nationality]" class="form-input" required>
                                                </div>
                                                <div class="w-full md:w-1/2 px-2 mb-4">
                                                    <label class="block text-xs mb-1">Numéro de passeport/ID</label>
                                                    <input type="text" name="travelers[0][document_number]" class="form-input" required>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <button type="button" id="add-traveler" class="text-sm text-blue-600 hover:underline">+ Ajouter un voyageur</button>
                                </div>
                                <?php endif; ?>
                                
                                <?php if ($type === 'hotel' || $type === 'combined'): ?>
                                <div class="mb-6">
                                    <h3 class="text-lg font-medium mb-4">Préférences d'hébergement</h3>
                                    
                                    <div class="flex flex-wrap -mx-2 mb-4">
                                        <div class="w-full md:w-1/2 px-2 mb-4">
                                            <label class="block text-xs mb-1">Type de chambre</label>
                                            <select name="room_type" class="form-input">
                                                <option value="standard">Standard</option>
                                                <option value="double">Double</option>
                                                <option value="superior">Supérieure</option>
                                                <option value="suite">Suite</option>
                                            </select>
                                        </div>
                                        <div class="w-full md:w-1/2 px-2 mb-4">
                                            <label class="block text-xs mb-1">Arrangements spéciaux</label>
                                            <select name="room_arrangement" class="form-input">
                                                <option value="no_preference">Pas de préférence</option>
                                                <option value="non_smoking">Non-fumeur</option>
                                                <option value="twin_beds">Lits jumeaux</option>
                                                <option value="king_bed">Lit king-size</option>
                                                <option value="accessible">Chambre accessible</option>
                                            </select>
                                        </div>
                                    </div>
                                    
                                    <div class="mb-4">
                                        <label class="block text-xs mb-1">Demandes spéciales</label>
                                        <textarea name="special_requests" class="form-input h-24" placeholder="Indiquez ici vos demandes ou besoins particuliers"></textarea>
                                    </div>
                                </div>
                                <?php endif; ?>
                                
                                <div class="mb-6">
                                    <h3 class="text-lg font-medium mb-4">Paiement</h3>
                                    
                                    <div class="flex flex-wrap -mx-2 mb-4">
                                        <div class="w-full px-2 mb-4">
                                            <label class="block text-xs mb-1">Nom sur la carte</label>
                                            <input type="text" name="card_name" class="form-input" required>
                                        </div>
                                    </div>
                                    
                                    <div class="flex flex-wrap -mx-2 mb-4">
                                        <div class="w-full px-2 mb-4">
                                            <label class="block text-xs mb-1">Numéro de carte</label>
                                            <input type="text" name="card_number" class="form-input" placeholder="XXXX XXXX XXXX XXXX" required>
                                        </div>
                                    </div>
                                    
                                    <div class="flex flex-wrap -mx-2 mb-4">
                                        <div class="w-full md:w-1/2 px-2 mb-4">
                                            <label class="block text-xs mb-1">Date d'expiration</label>
                                            <input type="text" name="card_expiry" class="form-input" placeholder="MM/AA" required>
                                        </div>
                                        <div class="w-full md:w-1/2 px-2 mb-4">
                                            <label class="block text-xs mb-1">Code de sécurité (CVV)</label>
                                            <input type="text" name="card_cvv" class="form-input" placeholder="XXX" required>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="mb-4">
                                    <label class="flex items-start">
                                        <input type="checkbox" name="terms" class="mt-1 mr-2" required>
                                        <span class="text-xs">J'accepte les <a href="https://imators.com/terms-of-use" class="text-blue-600 hover:underline">conditions d'utilisation</a> et la <a href="https://imators.com/privacy" class="text-blue-600 hover:underline">politique de confidentialité</a>.</span>
                                    </label>
                                </div>
                                
                                <button type="submit" class="bg-gray-900 text-white px-8 py-3 rounded-full text-sm hover:bg-gray-800 transition-all duration-300 w-full">
                                    Confirmer et payer
                                </button>
                            </form>
                        </div>
                    </div>
                    
                    <div class="w-full lg:w-1/3">
                        <div class="booking-card bg-white p-6 sticky top-8">
                            <h3 class="text-lg font-medium mb-4">Récapitulatif</h3>
                            
                            <?php if ($type === 'flight'): ?>
                                <div class="mb-4 pb-4 border-b">
                                    <div class="flex justify-between mb-2">
                                        <div class="text-sm font-medium"><?= htmlspecialchars($selected_item['airline'] ?? '') ?></div>
                                        <div class="text-sm"><?= htmlspecialchars($selected_item['flight_number'] ?? '') ?></div>
                                    </div>
                                    
                                    <div class="flex justify-between mb-2">
                                        <div>
                                            <div class="text-lg font-medium"><?= htmlspecialchars($selected_item['departure']['time'] ?? '') ?></div>
                                            <div class="text-xs text-gray-600"><?= htmlspecialchars($selected_item['departure']['airport'] ?? '') ?></div>
                                        </div>
                                        <div class="text-right">
                                            <div class="text-lg font-medium"><?= htmlspecialchars($selected_item['arrival']['time'] ?? '') ?></div>
                                            <div class="text-xs text-gray-600"><?= htmlspecialchars($selected_item['arrival']['airport'] ?? '') ?></div>
                                        </div>
                                    </div>
                                    
                                    <div class="text-xs text-gray-500 text-center mt-2">
                                        <?= htmlspecialchars($selected_item['duration'] ?? '') ?> • 
                                        <?= ($selected_item['stops'] ?? 0) == 0 ? 'Direct' : ($selected_item['stops'] == 1 ? '1 escale' : $selected_item['stops'] . ' escales') ?>
                                    </div>
                                </div>
                            <?php elseif ($type === 'hotel'): ?>
                                <div class="mb-4 pb-4 border-b">
                                    <h4 class="text-base font-medium mb-1"><?= htmlspecialchars($selected_item['name'] ?? '') ?></h4>
                                    
                                    <div class="flex items-center mb-2">
                                        <?php for ($i = 0; $i < ($selected_item['stars'] ?? 0); $i++): ?>
                                            <span class="text-yellow-400">★</span>
                                        <?php endfor; ?>
                                    </div>
                                    
                                    <p class="text-xs text-gray-600 mb-2"><?= htmlspecialchars($selected_item['address'] ?? '') ?></p>
                                    
                                    <div class="flex justify-between mb-1">
                                        <div class="text-xs">Check-in:</div>
                                        <div class="text-xs font-medium"><?= htmlspecialchars($params['checkin_date'] ?? '') ?></div>
                                    </div>
                                    
                                    <div class="flex justify-between">
                                        <div class="text-xs">Check-out:</div>
                                        <div class="text-xs font-medium"><?= htmlspecialchars($params['checkout_date'] ?? '') ?></div>
                                    </div>
                                </div>
                            <?php elseif ($type === 'train'): ?>
                                <div class="mb-4 pb-4 border-b">
                                    <div class="flex justify-between mb-2">
                                        <div class="text-sm font-medium"><?= htmlspecialchars($selected_item['company'] ?? '') ?></div>
                                        <div class="text-sm"><?= htmlspecialchars($selected_item['train_number'] ?? '') ?></div>
                                    </div>
                                    
                                    <div class="flex justify-between mb-2">
                                        <div>
                                            <div class="text-lg font-medium"><?= htmlspecialchars($selected_item['departure']['time'] ?? '') ?></div>
                                            <div class="text-xs text-gray-600"><?= htmlspecialchars($selected_item['departure']['station'] ?? '') ?></div>
                                        </div>
                                        <div class="text-right">
                                            <div class="text-lg font-medium"><?= htmlspecialchars($selected_item['arrival']['time'] ?? '') ?></div>
                                            <div class="text-xs text-gray-600"><?= htmlspecialchars($selected_item['arrival']['station'] ?? '') ?></div>
                                        </div>
                                    </div>
                                    
                                    <div class="text-xs text-gray-500 text-center mt-2">
                                        <?= htmlspecialchars($selected_item['duration'] ?? '') ?> • 
                                        <?= ($selected_item['stops'] ?? 0) == 0 ? 'Direct' : ($selected_item['stops'] == 1 ? '1 arrêt' : $selected_item['stops'] . ' arrêts') ?>
                                    </div>
                                </div>
                            <?php elseif ($type === 'combined'): ?>
                                <div class="mb-4 pb-4 border-b">
                                    <h4 class="text-base font-medium mb-2">Forfait <?= str_replace('_', ' + ', htmlspecialchars($package)) ?></h4>
                                    
                                    <div class="flex justify-between mb-1">
                                        <div class="text-xs">Destination:</div>
                                        <div class="text-xs font-medium"><?= htmlspecialchars($selected_item['destination'] ?? '') ?></div>
                                    </div>
                                    
                                    <div class="flex justify-between mb-1">
                                        <div class="text-xs">Arrivée:</div>
                                        <div class="text-xs font-medium"><?= htmlspecialchars($selected_item['dates']['start'] ?? '') ?></div>
                                    </div>
                                    
                                    <div class="flex justify-between mb-1">
                                        <div class="text-xs">Départ:</div>
                                        <div class="text-xs font-medium"><?= htmlspecialchars($selected_item['dates']['end'] ?? '') ?></div>
                                    </div>
                                </div>
                            <?php endif; ?>
                            
                            <div class="mb-4 pb-4 border-b">
                                <h4 class="text-sm font-medium mb-2">Détails du prix</h4>
                                
                                <?php if ($type === 'flight'): ?>
                                    <div class="flex justify-between mb-1">
                                        <div class="text-xs">Vol</div>
                                        <div class="text-xs"><?= htmlspecialchars($selected_item['price'] ?? '0') ?> €</div>
                                    </div>
                                    <div class="flex justify-between mb-1">
                                        <div class="text-xs">Taxes et frais</div>
                                        <div class="text-xs"><?= number_format((float)($selected_item['price'] ?? 0) * 0.2, 2) ?> €</div>
                                    </div>
                                <?php elseif ($type === 'hotel'): ?>
                                    <div class="flex justify-between mb-1">
                                        <div class="text-xs"><?= htmlspecialchars($selected_item['price_per_night'] ?? '0') ?> € x <?= calculateNights($params['checkin_date'] ?? '', $params['checkout_date'] ?? '') ?> nuits</div>
                                        <div class="text-xs"><?= htmlspecialchars($selected_item['total_price'] ?? '0') ?> €</div>
                                    </div>
                                    <div class="flex justify-between mb-1">
                                        <div class="text-xs">Taxes et frais</div>
                                        <div class="text-xs"><?= number_format((float)($selected_item['total_price'] ?? 0) * 0.1, 2) ?> €</div>
                                    </div>
                                <?php elseif ($type === 'train'): ?>
                                    <div class="flex justify-between mb-1">
                                        <div class="text-xs">Billet de train</div>
                                        <div class="text-xs"><?= htmlspecialchars($selected_item['price'] ?? '0') ?> €</div>
                                    </div>
                                    <div class="flex justify-between mb-1">
                                        <div class="text-xs">Frais de réservation</div>
                                        <div class="text-xs">5.00 €</div>
                                    </div>
                                <?php elseif ($type === 'combined'): ?>
                                    <?php 
                                    $total_price = 0;
                                    
                                    if (isset($selected_item['flights']) && is_array($selected_item['flights']) && !empty($selected_item['flights'])) {
                                        $flight_price = (float)($selected_item['flights'][0]['price'] ?? 0);
                                        $total_price += $flight_price;
                                    ?>
                                    <div class="flex justify-between mb-1">
                                        <div class="text-xs">Vol</div>
                                        <div class="text-xs"><?= number_format($flight_price, 2) ?> €</div>
                                    </div>
                                    <?php } ?>
                                    
                                    <?php 
                                    if (isset($selected_item['hotels']) && is_array($selected_item['hotels']) && !empty($selected_item['hotels'])) {
                                        $hotel_price = (float)($selected_item['hotels'][0]['total_price'] ?? 0);
                                        $total_price += $hotel_price;
                                    ?>
                                    <div class="flex justify-between mb-1">
                                        <div class="text-xs">Hébergement</div>
                                        <div class="text-xs"><?= number_format($hotel_price, 2) ?> €</div>
                                    </div>
                                    <?php } ?>
                                    
                                    <?php 
                                    if (isset($selected_item['trains']) && is_array($selected_item['trains']) && !empty($selected_item['trains'])) {
                                        $train_price = (float)($selected_item['trains'][0]['price'] ?? 0);
                                        $total_price += $train_price;
                                    ?>
                                    <div class="flex justify-between mb-1">
                                        <div class="text-xs">Train</div>
                                        <div class="text-xs"><?= number_format($train_price, 2) ?> €</div>
                                    </div>
                                    <?php } ?>
                                    
                                    <?php 
                                    if (isset($selected_item['cars']) && is_array($selected_item['cars']) && !empty($selected_item['cars'])) {
                                        $car_price = (float)($selected_item['cars'][0]['total_price'] ?? 0);
                                        $total_price += $car_price;
                                    ?>
                                    <div class="flex justify-between mb-1">
                                        <div class="text-xs">Location de voiture</div>
                                        <div class="text-xs"><?= number_format($car_price, 2) ?> €</div>
                                    </div>
                                    <?php } ?>
                                    
                                    <div class="flex justify-between mb-1">
                                        <div class="text-xs">Réduction forfait</div>
                                        <div class="text-xs text-green-600">-<?= number_format($total_price * 0.1, 2) ?> €</div>
                                    </div>
                                    
                                    <?php
                                    $total_price = $total_price * 0.9; // Apply 10% discount
                                    ?>
                                <?php endif; ?>
                            </div>
                            
                            <div class="flex justify-between font-medium">
                                <div>Total</div>
                                <?php if ($type === 'flight'): ?>
                                <div><?= number_format((float)($selected_item['price'] ?? 0) * 1.2, 2) ?> €</div>
                                <?php elseif ($type === 'hotel'): ?>
                                <div><?= number_format((float)($selected_item['total_price'] ?? 0) * 1.1, 2) ?> €</div>
                                <?php elseif ($type === 'train'): ?>
                                <div><?= number_format((float)($selected_item['price'] ?? 0) + 5, 2) ?> €</div>
                                <?php elseif ($type === 'combined'): ?>
                                <div><?= number_format($total_price, 2) ?> €</div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>

        <script>
            document.addEventListener('DOMContentLoaded', function() {
                let travelerCount = 1;
                const maxTravelers = 10;
                const travelersContainer = document.getElementById('travelers-container');
                const addTravelerBtn = document.getElementById('add-traveler');
                
                if (addTravelerBtn) {
                    addTravelerBtn.addEventListener('click', function() {
                        if (travelerCount >= maxTravelers) {
                            alert('Maximum de ' + maxTravelers + ' voyageurs atteint');
                            return;
                        }
                        
                        travelerCount++;
                        
                        const newTraveler = document.createElement('div');
                        newTraveler.className = 'traveler-info border rounded p-4 mb-4';
                        newTraveler.innerHTML = `
                            <div class="flex justify-between mb-2">
                                <h4 class="text-sm font-medium">Voyageur ${travelerCount}</h4>
                                <button type="button" class="remove-traveler text-xs text-red-600">Supprimer</button>
                            </div>
                            
                            <div class="flex flex-wrap -mx-2 mb-4">
                                <div class="w-full md:w-1/3 px-2 mb-4">
                                    <label class="block text-xs mb-1">Prénom</label>
                                    <input type="text" name="travelers[${travelerCount-1}][first_name]" class="form-input" required>
                                </div>
                                <div class="w-full md:w-1/3 px-2 mb-4">
                                    <label class="block text-xs mb-1">Nom</label>
                                    <input type="text" name="travelers[${travelerCount-1}][last_name]" class="form-input" required>
                                </div>
                                <div class="w-full md:w-1/3 px-2 mb-4">
                                    <label class="block text-xs mb-1">Date de naissance</label>
                                    <input type="date" name="travelers[${travelerCount-1}][dob]" class="form-input" required>
                                </div>
                            </div>
                            
                            <div class="flex flex-wrap -mx-2">
                                <div class="w-full md:w-1/2 px-2 mb-4">
                                    <label class="block text-xs mb-1">Nationalité</label>
                                    <input type="text" name="travelers[${travelerCount-1}][nationality]" class="form-input" required>
                                </div>
                                <div class="w-full md:w-1/2 px-2 mb-4">
                                    <label class="block text-xs mb-1">Numéro de passeport/ID</label>
                                    <input type="text" name="travelers[${travelerCount-1}][document_number]" class="form-input" required>
                                </div>
                            </div>
                        `;
                        
                        travelersContainer.appendChild(newTraveler);
                        
                        newTraveler.querySelector('.remove-traveler').addEventListener('click', function() {
                            travelersContainer.removeChild(newTraveler);
                            travelerCount--;
                        });
                    });
                }
            });
            
            function calculateNights(checkin, checkout) {
                if (!checkin || !checkout) return 0;
                
                const start = new Date(checkin);
                const end = new Date(checkout);
                
                return Math.round((end - start) / (1000 * 60 * 60 * 24));
            }
        </script>

        <footer class="bg-white font-['Poppins'] px-8">
            <div class="max-w-5xl mx-auto px-4 py-8 flex flex-wrap justify-between">
                <div class="w-full md:w-1/2 p-5">
                    <h5 class="text-xs uppercase font-medium mb-6">Legal</h5>
                    <a href="https://imators.com/privacy" class="my-3 block hover:text-gray-600 text-sm font-medium duration-700">Privacy Policy</a>
                    <a href="https://imators.com/terms-of-use" class="my-3 block hover:text-gray-600 text-sm font-medium duration-700">Terms of Use</a>
                </div>
                <div class="w-full md:w-1/2 p-5">
                    <h5 class="text-xs uppercase font-medium mb-6">About</h5>
                    <p class="text-sm">Hizhat is a member of Imators Group.</p>
                </div>
            </div>
            <div class="text-center py-4 border-t border-gray-200">
                <p class="text-sm mb-2">&copy; 2025 Imators. All rights reserved.</p>
                <p class="text-xs">Imators is a registered LLC (Limited Liability Company). All our products are subject to our rules.</p>
            </div>
        </footer>
    </div>
</body>
</html>

<?php
function calculateNights($checkin, $checkout) {
    if (empty($checkin) || empty($checkout)) {
        return 0;
    }
    
    $start = new DateTime($checkin);
    $end = new DateTime($checkout);
    
    $interval = $end->diff($start);
    return $interval->days;
}
?>