<?php
$host = 'localhost:3306';
$dbname = 'gqdcvggs_traffic';
$username = 'gqdcvggs';
$password = 'imaors_management.346980*#@-onlyforcpanel;forchange';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Database connection failed: ' . $e->getMessage()]);
    exit;
}

$action = isset($_GET['action']) ? $_GET['action'] : '';

switch ($action) {
    case 'getTrafficLights':
        getTrafficLights($pdo);
        break;
    
    case 'getTrafficLight':
        $id = isset($_GET['id']) ? $_GET['id'] : null;
        getTrafficLight($pdo, $id);
        break;
    
    case 'addTrafficLight':
        addTrafficLight($pdo);
        break;
    
    case 'updateTiming':
        updateTiming($pdo);
        break;
    
    default:
        echo json_encode(['success' => false, 'message' => 'Invalid action']);
}

function getTrafficLights($pdo) {
    try {
        $stmt = $pdo->query("SELECT * FROM traffic_lights");
        $lights = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo json_encode($lights);
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => 'Error fetching traffic lights: ' . $e->getMessage()]);
    }
}

function getTrafficLight($pdo, $id) {
    if (!$id) {
        echo json_encode(['success' => false, 'message' => 'ID is required']);
        return;
    }
    
    try {
        $stmt = $pdo->prepare("SELECT * FROM traffic_lights WHERE id = ?");
        $stmt->execute([$id]);
        $light = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($light) {
            echo json_encode($light);
        } else {
            echo json_encode(['success' => false, 'message' => 'Traffic light not found']);
        }
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => 'Error fetching traffic light: ' . $e->getMessage()]);
    }
}

function addTrafficLight($pdo) {
    $json = file_get_contents('php://input');
    $data = json_decode($json, true);
    
    if (!$data) {
        echo json_encode(['success' => false, 'message' => 'Invalid data format']);
        return;
    }
    
    $required = ['name', 'latitude', 'longitude', 'direction', 'red_duration', 'green_duration'];
    foreach ($required as $field) {
        if (!isset($data[$field])) {
            echo json_encode(['success' => false, 'message' => "$field is required"]);
            return;
        }
    }
    
    try {
        $stmt = $pdo->prepare("INSERT INTO traffic_lights (name, latitude, longitude, direction, red_duration, green_duration) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->execute([
            $data['name'],
            $data['latitude'],
            $data['longitude'],
            $data['direction'],
            $data['red_duration'],
            $data['green_duration']
        ]);
        
        $id = $pdo->lastInsertId();
        
        $stmt = $pdo->prepare("SELECT * FROM traffic_lights WHERE id = ?");
        $stmt->execute([$id]);
        $light = $stmt->fetch(PDO::FETCH_ASSOC);
        
        notifyServer('newTrafficLight', $light);
        
        echo json_encode(['success' => true, 'light' => $light]);
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => 'Error adding traffic light: ' . $e->getMessage()]);
    }
}

function updateTiming($pdo) {
    $json = file_get_contents('php://input');
    $data = json_decode($json, true);
    
    if (!$data || !isset($data['id']) || !isset($data['red_duration'])) {
        echo json_encode(['success' => false, 'message' => 'Invalid data format']);
        return;
    }
    
    try {
        $stmt = $pdo->prepare("UPDATE traffic_lights SET red_duration = ? WHERE id = ?");
        $stmt->execute([$data['red_duration'], $data['id']]);
        
        $stmt = $pdo->prepare("SELECT * FROM traffic_lights WHERE id = ?");
        $stmt->execute([$data['id']]);
        $light = $stmt->fetch(PDO::FETCH_ASSOC);
        
        notifyServer('updateTrafficLight', $light);
        
        echo json_encode(['success' => true, 'light' => $light]);
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => 'Error updating traffic light timing: ' . $e->getMessage()]);
    }
}

function notifyServer($event, $data) {
    $url = "notify";
    $payload = json_encode([
        'event' => $event,
        'data' => $data
    ]);
    
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Content-Length: ' . strlen($payload)
    ]);
    
    $result = curl_exec($ch);
    curl_close($ch);
    
    return $result;
}
?>