<!DOCTYPE html>
<html lang="fr" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ÉLÉGANCE</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@200;300;400;500;600&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #000000;
            color: #ffffff;
        }
        .slider-container {
            position: relative;
            width: 95%;
            max-width: 1400px;
            margin: 1rem auto;
            aspect-ratio: 16 / 10;
            overflow: hidden;
        }
        .slider-frame {
            position: absolute;
            top: 20px;
            left: 20px;
            right: 20px;
            bottom: 20px;
            border: 1px solid rgba(255, 255, 255, 0.2);
            overflow: hidden;
            display: flex;
            flex-direction: column;
        }
        .slide {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            opacity: 0;
            transition: opacity 1s ease-in-out;
            display: flex;
            flex-direction: column;
        }
        .slide.active {
            opacity: 1;
        }
        .slide-image {
            flex-grow: 1;
            overflow: hidden;
        }
        .slide-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        .slide-content {
            background-color: white;
            color: black;
            padding: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .slide-text {
            flex-grow: 1;
        }
        .slider-nav {
            display: flex;
            align-items: center;
        }
        .slider-nav button {
            background: none;
            border: none;
            color: black;
            font-size: 1.5rem;
            cursor: pointer;
            padding: 0 10px;
            transition: opacity 0.3s ease;
        }
        .slider-nav button:hover {
            opacity: 0.7;
        }
        .slider-dots {
            display: flex;
            margin: 0 20px;
        }
        .dot {
            width: 8px;
            height: 8px;
            border-radius: 50%;
            background-color: rgba(0, 0, 0, 0.5);
            margin: 0 5px;
            transition: background-color 0.3s ease;
        }
        .dot.active {
            background-color: black;
        }
        @media (max-width: 768px) {
            .slider-container {
                aspect-ratio: 9 / 16;
                width: 95%;
                margin: 0.5rem auto;
            }
        }
    </style>
</head>
<body class="flex flex-col min-h-screen bg-black text-white">
    
    <?php include 'header.php'; ?>

    <main class="flex-grow flex items-center pt-24 md:pt-0 justify-center">
        <section class="slider-container">
            <div class="slider-frame">
                <div class="slide active">
                    <div class="slide-image">
                        <picture>
                            <source media="(max-width: 768px)" srcset="/api/placeholder/900/1200">
                            <img src="https://candaceabroad.com/wp-content/uploads/2023/08/Soho-House-London.jpeg" alt="Suite Luxe">
                        </picture>
                    </div>
                    <div class="slide-content">
                        <div class="slide-text">
                            <h2 class="text-2xl font-light mb-1">Suite Luxe</h2>
                            <p class="text-sm font-light">Découvrez le confort ultime dans nos suites d'exception.</p>
                        </div>
                        <div class="slider-nav">
                            <button id="prevBtn">&lt;</button>
                            <div class="slider-dots"></div>
                            <button id="nextBtn">&gt;</button>
                        </div>
                    </div>
                </div>
                <div class="slide">
                    <div class="slide-image">
                        <picture>
                            <source media="(max-width: 768px)" srcset="/api/placeholder/900/1200">
                            <img src="https://media.cntraveler.com/photos/6669f652336f2b15ddd2dc43/16:9/w_2560,c_limit/Soho%20House%20New%20York_SHNY%20club%20restaurant%201.jpg" alt="Restaurant Gastronomique">
                        </picture>
                    </div>
                    <div class="slide-content">
                        <div class="slide-text">
                            <h2 class="text-2xl font-light mb-1">Gastronomie Raffinée</h2>
                            <p class="text-sm font-light">Savourez une cuisine d'exception dans notre restaurant étoilé.</p>
                        </div>
                        <div class="slider-nav">
                            <button id="prevBtn">&lt;</button>
                            <div class="slider-dots"></div>
                            <button id="nextBtn">&gt;</button>
                        </div>
                    </div>
                </div>
                <div class="slide">
                    <div class="slide-image">
                        <picture>
                            <source media="(max-width: 768px)" srcset="/api/placeholder/900/1200">
                            <img src="https://cdn.vox-cdn.com/thumbor/Gxyr6-Png6gTs6p1JVn1yi5X5Jg=/0x0:4575x2761/1200x800/filters:focal(1897x1033:2629x1765)/cdn.vox-cdn.com/uploads/chorus_image/image/73225874/SHNY_Roof.0.jpg" alt="Spa & Bien-être">
                        </picture>
                    </div>
                    <div class="slide-content">
                        <div class="slide-text">
                            <h2 class="text-2xl font-light mb-1">Spa & Bien-être</h2>
                            <p class="text-sm font-light">Détendez-vous dans notre spa luxueux et ressourcez-vous.</p>
                        </div>
                        <div class="slider-nav">
                            <button id="prevBtn">&lt;</button>
                            <div class="slider-dots"></div>
                            <button id="nextBtn">&gt;</button>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>



    <script>
        const slides = document.querySelectorAll('.slide');
        const dots = document.querySelectorAll('.slider-dots');
        const prevBtns = document.querySelectorAll('#prevBtn');
        const nextBtns = document.querySelectorAll('#nextBtn');
        let currentSlide = 0;

        function showSlide(index) {
            slides[currentSlide].classList.remove('active');
            slides[index].classList.add('active');
            dots.forEach(dotContainer => {
                dotContainer.children[currentSlide].classList.remove('active');
                dotContainer.children[index].classList.add('active');
            });
            currentSlide = index;
        }

        function nextSlide() {
            showSlide((currentSlide + 1) % slides.length);
        }

        function prevSlide() {
            showSlide((currentSlide - 1 + slides.length) % slides.length);
        }

        dots.forEach(dotContainer => {
            slides.forEach((_, index) => {
                const dot = document.createElement('div');
                dot.classList.add('dot');
                if (index === 0) dot.classList.add('active');
                dot.addEventListener('click', () => showSlide(index));
                dotContainer.appendChild(dot);
            });
        });

        prevBtns.forEach(btn => btn.addEventListener('click', prevSlide));
        nextBtns.forEach(btn => btn.addEventListener('click', nextSlide));

        setInterval(nextSlide, 5000);
    </script>
</body>
</html>