<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>The Peerkinton Village</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Underdog&display=swap" rel="stylesheet">
</head>
<body class="bg-black text-white font-sans">
    <nav class="fixed top-0 left-0 w-full bg-black/80 z-50">
        <div class="container mx-auto flex justify-between items-center p-4">
            <a href="#" class="text-2xl font-['Underdog']">Peerkinton</a>
            <div class="space-x-4">
                <a href="#accueil" class="hover:text-gray-300">Accueil</a>
                <a href="#reserver" class="hover:text-gray-300">Réserver</a>
                <a href="#regles" class="hover:text-gray-300">Règles</a>
                <a href="#information" class="hover:text-gray-300">Information</a>
            </div>
        </div>
    </nav>

    <main class="container mx-auto px-4 pt-20">
        <section id="accueil" class="min-h-screen flex flex-col justify-center">
            <h1 class="text-6xl font-['Underdog'] mb-8">The Peerkinton Village</h1>
            <div class="max-w-2xl">
                <p class="text-xl mb-6">
                    Bienvenue dans un village campé dans l'atmosphère unique des années 1800, où l'histoire prend vie et où chaque visiteur devient un acteur de son propre récit.
                </p>
                <p class="text-xl mb-6">
                    The Peerkinton Village est une expérience immersive de roleplay qui vous transporte dans une reconstitution historique authentique, offrant une plongée totale dans le mode de vie du 19ème siècle.
                </p>
                <p class="text-xl">
                    Découvrez un monde où chaque détail, chaque interaction est pensée pour recréer l'essence d'une époque révolue.
                </p>
            </div>
        </section>

        <section id="reserver" class="min-h-screen flex flex-col justify-center">
            <h2 class="text-4xl mb-8">Réserver une Session</h2>
            <div class="max-w-2xl">
                <p class="text-xl mb-6">
                    Préparez-vous à vivre une expérience unique. Nos sessions de roleplay sont conçues pour offrir une immersion totale dans l'univers de Peerkinton.
                </p>
                <form class="space-y-4">
                    <input type="text" placeholder="Nom" class="w-full p-2 bg-gray-800 text-white">
                    <input type="email" placeholder="Email" class="w-full p-2 bg-gray-800 text-white">
                    <select class="w-full p-2 bg-gray-800 text-white">
                        <option>Choisissez une session</option>
                        <option>Session Journée</option>
                        <option>Session Week-end</option>
                        <option>Session Semaine Complète</option>
                    </select>
                    <button type="submit" class="bg-white text-black px-4 py-2 hover:bg-gray-200">
                        Réserver
                    </button>
                </form>
            </div>
        </section>

        <section id="regles" class="min-h-screen flex flex-col justify-center">
            <h2 class="text-4xl mb-8">Règles du Village</h2>
            <div class="max-w-2xl">
                <ul class="space-y-4 text-xl">
                    <li>1. Restez dans le personnage en permanence</li>
                    <li>2. Respectez l'authenticité historique</li>
                    <li>3. Utilisez uniquement des objets et des langages de l'époque</li>
                    <li>4. Aucun appareil moderne n'est autorisé pendant l'expérience</li>
                    <li>5. La courtoisie et le respect mutuel sont essentiels</li>
                </ul>
            </div>
        </section>

        <section id="information" class="min-h-screen flex flex-col justify-center">
            <h2 class="text-4xl mb-8">Informations</h2>
            <div class="max-w-2xl">
                <p class="text-xl mb-6">
                    The Peerkinton Village est situé dans un domaine privé de 50 hectares, entièrement reconstruit pour reproduire l'atmosphère des années 1800.
                </p>
                <p class="text-xl mb-6">
                    Nos sessions sont encadrées par des historiens et des experts en reconstitution historique pour garantir une expérience authentique.
                </p>
                <p class="text-xl">
                    Tarifs, réservations et détails complémentaires disponibles sur demande.
                </p>
            </div>
        </section>
    </main>

    <footer class="bg-black/80 text-center py-4 mt-8">
        <p>&copy; 2025 The Peerkinton Village. Tous droits réservés.</p>
    </footer>
</body>
</html>