<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>The Peerkinton Village</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Underdog&display=swap" rel="stylesheet">
</head>
<body class="bg-black text-white">
    <div class="relative min-h-screen flex flex-col lg:flex-row items-center justify-center overflow-hidden p-4">
        <div class="absolute inset-0 bg-gradient-to-br from-black via-black/80 to-black/50 z-10"></div>
        
        <div class="absolute top-0 left-0 w-full h-full pointer-events-none">
            <div class="absolute w-1/2 h-1/2 bg-white/5 rounded-full blur-3xl -top-1/4 -left-1/4 animate-pulse"></div>
            <div class="absolute w-1/2 h-1/2 bg-white/5 rounded-full blur-3xl -bottom-1/4 -right-1/4 animate-pulse delay-500"></div>
        </div>

        <div class="relative z-20 w-full max-w-6xl mx-auto grid lg:grid-cols-2 gap-8 items-center">
            <div class="text-center lg:text-left space-y-6">
                <h1 class="text-5xl md:text-7xl lg:text-8xl font-['Underdog'] relative inline-block">
                    <span class="absolute -left-6 -top-4 text-2xl opacity-50">✦</span>
                    Peerkinton
                    <span class="absolute -right-6 -bottom-4 text-2xl opacity-50">✦</span>
                </h1>
                <p class="text-lg md:text-xl max-w-2xl mx-auto lg:mx-0 font-light tracking-wide">
                    Voyagez dans le temps. Vivez une immersion totale dans l'expérience historique où vous devenez le protagoniste de votre propre récit.
                </p>
                <div class="flex flex-col sm:flex-row justify-center lg:justify-start space-y-4 sm:space-y-0 sm:space-x-4">
                    <a href="#" class="px-6 py-3 bg-white text-black rounded-full hover:bg-gray-200 transition duration-300 transform hover:-translate-y-1 shadow-lg text-center">
                        Découvrir l'expérience
                    </a>
                    <a href="#" class="px-6 py-3 border border-white rounded-full hover:bg-white/10 transition duration-300 transform hover:-translate-y-1 text-center">
                        Réserver une session
                    </a>
                </div>
            </div>
            <div class="hidden lg:flex justify-center items-center">
                <div class="w-full max-w-md aspect-square bg-white/10 rounded-full flex items-center justify-center">
                    <div class="w-3/4 h-3/4 bg-white/20 rounded-full animate-spin-slow"></div>
                </div>
            </div>
        </div>
    </div>

    <style>
        @keyframes spin-slow {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }
        .animate-spin-slow {
            animation: spin-slow 20s linear infinite;
        }
    </style>
</body>
</html>