<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="logo_new.png">
    <title>Vert Chasseur</title>
    <meta name="description" content="Vert Chasseur est un quartier à Uccle où vous trouverez de la joie et un havre de paix accueillant. Découvrez les commerces partenaire du quartier et les événements qui pourrait vous intéresser.">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Princess+Sofia&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            letter-spacing: -0.01em;
        }
        .card-hover {
            transition: transform 0.3s ease;
        }
        .card-hover:hover {
            transform: translateY(-4px);
        }
        .arrow-hover {
            transition: transform 0.3s ease;
        }
        .card-hover:hover .arrow-hover {
            transform: translateX(8px);
        }
        
        .txt-chasseur {
            font-family: "Princess Sofia", serif;
            font-weight: 400;
            font-style: normal;
        }
    </style>
</head>
<body class="bg-white">
    <header id="header" class="fixed w-full top-0 z-50 transition-all duration-300 bg-transparent text-black">
        <div class="container mx-auto px-4 py-3">
            <div class="flex justify-between items-center">
                <div>
                    <a href="/" class="flex items-center">
                        <img src="logo_new.png" alt="Vert Chasseur" class="h-12">
                    </a>
                </div>
                <nav class="hidden md:flex space-x-6">
                    <a href="/media" class="hover:text-gray-600 text-sm font-medium">Actualité</a>
                    <a href="/shop" class="hover:text-gray-600 text-sm font-medium">Commerce</a>
                    <a href="/event" class="hover:text-gray-600 text-sm font-medium">Évènement</a>
                    <a href="https://imators.com/contact" class="hover:text-gray-600 text-sm font-medium">Contact</a>
                </nav>
                <button id="menuBtn" class="md:hidden w-6 h-6">
                    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4 6h16M4 12h16M4 18h16"/></svg>
                </button>
            </div>
        </div>
        <div id="mobileMenu" class="fixed inset-0 bg-white transform translate-x-full transition-transform duration-300 md:hidden">
            <div class="flex justify-end p-4">
                <button id="closeBtn" class="w-6 h-6">
                    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M6 18L18 6M6 6l12 12"/></svg>
                </button>
            </div>
            <div class="flex justify-center my-4">
                <img src="logo_new.png" alt="Vert Chasseur" class="h-12">
            </div>
            <nav class="mt-8 p-4">
                <ul class="space-y-6 text-center">
                    <li><a href="/media" class="block text-lg">Actualité</a></li>
                    <li><a href="/shop" class="block text-lg">Commerce</a></li>
                    <li><a href="/event" class="block text-lg">Évènement</a></li>
                    <li><a href="https://imators.com/contact" class="block text-lg">Contact</a></li>
                </ul>
            </nav>
        </div>
    </header>


    <footer class="w-full py-4">
        <p class="text-xs text-gray-400 text-center">© 2025 Vert Chasseur · Un projet Imators LLC · <a href="https://imators.com/privacy" class="hover:text-gray-600">Confidentialité</a></p>
    </footer>

    <script>
        const header = document.getElementById('header');
        const menuBtn = document.getElementById('menuBtn');
        const closeBtn = document.getElementById('closeBtn');
        const mobileMenu = document.getElementById('mobileMenu');

        window.addEventListener('scroll', () => {
            header.classList.toggle('bg-white', window.scrollY > 50);
            header.classList.toggle('shadow-sm', window.scrollY > 50);
        });

        menuBtn.addEventListener('click', () => mobileMenu.classList.remove('translate-x-full'));
        closeBtn.addEventListener('click', () => mobileMenu.classList.add('translate-x-full'));
    </script>
</body>
</html>